/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.util.List;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.muc.MucConfig;
import tigase.muc.exceptions.MUCException;
import tigase.muc.modules.AbstractModule;
import tigase.muc.repository.IMucRepository;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;

public class DiscoItemsModule
extends AbstractModule {
    private static final Criteria CRIT = ElementCriteria.nameType((String)"iq", (String)"get").add((Criteria)ElementCriteria.name((String)"query", (String)"http://jabber.org/protocol/disco#items"));

    public DiscoItemsModule(MucConfig config, IMucRepository mucRepository) {
        super(config, mucRepository);
    }

    @Override
    public String[] getFeatures() {
        return null;
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    @Override
    public List<Element> process(Element element) throws MUCException {
        try {
            String roomId = DiscoItemsModule.getRoomId(element.getAttribute("to"));
            Element result = DiscoItemsModule.createResultIQ(element);
            Element resultQuery = new Element("query", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/disco#items"});
            result.addChild((XMLNodeIfc)resultQuery);
            if (roomId == null) {
                String[] roomsId;
                for (String jid : roomsId = this.repository.getPublicVisibleRoomsIdList()) {
                    String name = this.repository.getRoomName(jid);
                    resultQuery.addChild((XMLNodeIfc)new Element("item", new String[]{"jid", "name"}, new String[]{jid, name != null ? name : jid}));
                }
            } else {
                throw new MUCException(Authorization.FEATURE_NOT_IMPLEMENTED, "To be implemented!");
            }
            return DiscoItemsModule.makeArray(result);
        }
        catch (MUCException e1) {
            throw e1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

