/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import tigase.muc.Module;
import tigase.muc.MucConfig;
import tigase.muc.Room;
import tigase.muc.repository.IMucRepository;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;

public abstract class AbstractModule
implements Module {
    protected final MucConfig config;
    protected Logger log = Logger.getLogger(this.getClass().getName());
    protected final IMucRepository repository;

    public static Element createResultIQ(Element iq) {
        return new Element("iq", new String[]{"type", "from", "to", "id"}, new String[]{"result", iq.getAttribute("to"), iq.getAttribute("from"), iq.getAttribute("id")});
    }

    public static String getNicknameFromJid(String jid) {
        if (jid != null) {
            int idx = jid.indexOf(47);
            return idx == -1 ? null : jid.substring(idx + 1);
        }
        return null;
    }

    public static String getRoomId(String jid) {
        if (jid != null) {
            return JIDUtils.getNodeNick((String)jid) == null ? null : JIDUtils.getNodeID((String)jid);
        }
        return null;
    }

    public static List<Element> makeArray(Element ... elements) {
        ArrayList<Element> result = new ArrayList<Element>();
        for (Element element : elements) {
            result.add(element);
        }
        return result;
    }

    protected static Element prepateMucMessage(Room room, String nickname, String message) {
        String occupantJid = room.getOccupantsJidByNickname(nickname);
        Element msg = new Element("message", new String[]{"from", "to", "type"}, new String[]{room.getRoomId(), occupantJid, "groupchat"});
        msg.addChild((XMLNodeIfc)new Element("body", message));
        return msg;
    }

    public AbstractModule(MucConfig config, IMucRepository mucRepository) {
        this.config = config;
        this.repository = mucRepository;
    }

    @Override
    public boolean isProcessedByModule(Element element) {
        return true;
    }
}

