/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.util.List;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.muc.Affiliation;
import tigase.muc.MucConfig;
import tigase.muc.Role;
import tigase.muc.Room;
import tigase.muc.exceptions.MUCException;
import tigase.muc.modules.AbstractModule;
import tigase.muc.repository.IMucRepository;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;

public class MediatedInvitationModule
extends AbstractModule {
    private static final Criteria CRIT = ElementCriteria.name((String)"message").add(ElementCriteria.name((String)"x", (String)"http://jabber.org/protocol/muc#user").add((Criteria)ElementCriteria.name((String)"invite")));

    public MediatedInvitationModule(MucConfig config, IMucRepository mucRepository) {
        super(config, mucRepository);
    }

    @Override
    public String[] getFeatures() {
        return null;
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    @Override
    public List<Element> process(Element element) throws MUCException {
        try {
            String senderJid = element.getAttribute("from");
            String roomId = MediatedInvitationModule.getRoomId(element.getAttribute("to"));
            if (MediatedInvitationModule.getNicknameFromJid(element.getAttribute("to")) != null) {
                throw new MUCException(Authorization.BAD_REQUEST);
            }
            Room room = this.repository.getRoom(roomId);
            if (room == null) {
                throw new MUCException(Authorization.ITEM_NOT_FOUND);
            }
            Role senderRole = room.getRoleByJid(senderJid);
            if (!senderRole.isInviteOtherUsers()) {
                throw new MUCException(Authorization.NOT_ALLOWED);
            }
            Affiliation senderAffiliation = room.getAffiliation(senderJid);
            if (room.getConfig().isRoomMembersOnly() && !senderAffiliation.isEditMemberList()) {
                throw new MUCException(Authorization.FORBIDDEN);
            }
            Element x = element.getChild("x", "http://jabber.org/protocol/muc#user");
            Element invite = x.getChild("invite");
            Element reason = invite.getChild("reason");
            String recipient = invite.getAttribute("to");
            Element resultMessage = new Element("message", new String[]{"from", "to"}, new String[]{roomId, recipient});
            Element resultX = new Element("x", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc#user"});
            resultMessage.addChild((XMLNodeIfc)resultX);
            if (room.getConfig().isRoomMembersOnly() && senderAffiliation.isEditMemberList()) {
                room.addAffiliationByJid(recipient, Affiliation.member);
            }
            Element resultInvite = new Element("invite", new String[]{"from"}, new String[]{senderJid});
            resultX.addChild((XMLNodeIfc)resultInvite);
            if (room.getConfig().isPasswordProtectedRoom()) {
                resultX.addChild((XMLNodeIfc)new Element("password", room.getConfig().getPassword()));
            }
            if (reason != null) {
                resultInvite.addChild((XMLNodeIfc)reason.clone());
            }
            return MediatedInvitationModule.makeArray(resultMessage);
        }
        catch (MUCException e1) {
            throw e1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

