/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.exceptions;

import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;

public class MUCException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final Authorization errorCondition;
    private final String message;
    private String xmlns = "urn:ietf:params:xml:ns:xmpp-stanzas";

    public MUCException(Authorization errorCondition) {
        this(errorCondition, (String)null);
    }

    public MUCException(Authorization errorCondition, String message) {
        this.errorCondition = errorCondition;
        this.message = message;
    }

    public String getCode() {
        return String.valueOf(this.errorCondition.getErrorCode());
    }

    public Authorization getErrorCondition() {
        return this.errorCondition;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public String getName() {
        return this.errorCondition.getCondition();
    }

    public String getType() {
        return this.errorCondition.getErrorType();
    }

    public Element makeElement(Element item, boolean insertOriginal) {
        Element answer = insertOriginal ? item.clone() : new Element(item.getName());
        answer.addAttribute("id", item.getAttribute("id"));
        answer.addAttribute("type", "error");
        answer.addAttribute("to", item.getAttribute("from"));
        answer.addAttribute("from", item.getAttribute("to"));
        if (this.message != null) {
            Element text = new Element("text", this.message, new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-stanzas"});
            answer.addChild((XMLNodeIfc)text);
        }
        answer.addChild((XMLNodeIfc)this.makeErrorElement());
        return answer;
    }

    private Element makeErrorElement() {
        Element error = new Element("error");
        error.setAttribute("code", String.valueOf(this.errorCondition.getErrorCode()));
        error.setAttribute("type", this.errorCondition.getErrorType());
        error.addChild((XMLNodeIfc)new Element(this.errorCondition.getCondition(), new String[]{"xmlns"}, new String[]{this.xmlns}));
        return error;
    }
}

