/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tigase.muc.Affiliation;
import tigase.muc.History;
import tigase.muc.Role;
import tigase.muc.RoomConfig;
import tigase.muc.repository.RepositoryException;
import tigase.util.JIDUtils;
import tigase.xml.Element;

public class Room {
    private final HashMap<String, Affiliation> affiliations = new HashMap();
    private final RoomConfig config;
    private final Date creationDate;
    private final String creatorJid;
    private History history = new History();
    private final HashMap<String, Element> lastPresences = new HashMap();
    private final ArrayList<RoomListener> listeners = new ArrayList();
    private final HashMap<String, String> occupantsJidNickname = new HashMap();
    private final HashMap<String, String> occupantsNicknameJid = new HashMap();
    private final HashMap<String, Role> roles = new HashMap();
    private boolean roomLocked;
    private String subject;
    private Date subjectChangeDate;
    private String subjectChangerNick;

    public Room(RoomConfig rc, Date creationDate, String creatorJid) {
        this.config = rc;
        this.creationDate = creationDate;
        this.creatorJid = creatorJid;
    }

    public void addAffiliationByJid(String jid, Affiliation affiliation) throws RepositoryException {
        String j = JIDUtils.getNodeID((String)jid);
        if (affiliation == Affiliation.none) {
            this.affiliations.remove(j);
        } else {
            this.affiliations.put(j, affiliation);
        }
        this.fireOnSetAffiliation(j, affiliation);
    }

    public void addListener(RoomListener listener) {
        this.listeners.add(listener);
    }

    public void addOccupantByJid(String senderJid, String nickName, Role role) {
        this.occupantsJidNickname.put(senderJid, nickName);
        this.occupantsNicknameJid.put(nickName, senderJid);
        this.roles.put(senderJid, role);
    }

    public void addToHistory(String message, String senderJid, String senderNickname, Date time) {
        this.history.add(message, senderJid, senderNickname, time);
    }

    public void changeNickName(String senderJid, String nickName) {
        String oldNickname = this.occupantsJidNickname.put(senderJid, nickName);
        if (oldNickname != null) {
            this.occupantsNicknameJid.remove(oldNickname);
        }
        this.occupantsNicknameJid.put(nickName, senderJid);
    }

    private void fireOnSetAffiliation(String jid, Affiliation affiliation) {
        for (RoomListener listener : this.listeners) {
            listener.onSetAffiliation(this, jid, affiliation);
        }
    }

    private void fireOnSetSubject(String nick, String subject, Date changeDate) {
        for (RoomListener listener : this.listeners) {
            listener.onChangeSubject(this, nick, subject, changeDate);
        }
    }

    public Affiliation getAffiliation(String jid) {
        Affiliation result = null;
        if (jid != null) {
            result = this.affiliations.get(JIDUtils.getNodeID((String)jid));
        }
        return result == null ? Affiliation.none : result;
    }

    public Collection<String> getAffiliations() {
        return this.affiliations.keySet();
    }

    public RoomConfig getConfig() {
        return this.config;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public String getCreatorJid() {
        return this.creatorJid;
    }

    public List<Element> getHistoryMessages(String recipientJid) {
        Affiliation recipientAffiliation = this.getAffiliation(recipientJid);
        boolean showJids = this.config.getRoomAnonymity() == RoomConfig.Anonymity.nonanonymous || this.config.getRoomAnonymity() == RoomConfig.Anonymity.semianonymous && (recipientAffiliation == Affiliation.owner || recipientAffiliation == Affiliation.admin);
        return this.history.getMessages(recipientJid, this.config.getRoomId(), showJids);
    }

    public Element getLastPresenceCopyByJid(String jid) {
        Element x = this.lastPresences.get(jid);
        return x == null ? null : x.clone();
    }

    public int getOccupantsCount() {
        return this.occupantsJidNickname.size();
    }

    public String getOccupantsJidByNickname(String nickname) {
        return this.occupantsNicknameJid.get(nickname);
    }

    public Collection<String> getOccupantsJids() {
        return Collections.unmodifiableSet(this.occupantsJidNickname.keySet());
    }

    public String getOccupantsNickname(String jid) {
        return this.occupantsJidNickname.get(jid);
    }

    public String getOccupantsNicknameByBareJid(String jid) {
        String j = JIDUtils.getNodeID((String)jid);
        for (Map.Entry<String, String> entry : this.occupantsJidNickname.entrySet()) {
            if (!j.equals(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public String[] getRealJidsByBareJid(String occupantBareJid) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.occupantsJidNickname.entrySet()) {
            if (!occupantBareJid.equals(JIDUtils.getNodeID((String)entry.getKey()))) continue;
            result.add(entry.getKey());
        }
        return result.toArray(new String[0]);
    }

    public Role getRoleByJid(String jid) {
        Role result = null;
        if (jid != null) {
            result = this.roles.get(jid);
        }
        return result == null ? Role.none : result;
    }

    public String getRoomId() {
        return this.config.getRoomId();
    }

    public String getSubject() {
        return this.subject;
    }

    public Date getSubjectChangeDate() {
        return this.subjectChangeDate;
    }

    public String getSubjectChangerNick() {
        return this.subjectChangerNick;
    }

    public boolean isNickNameExists(String nickname) {
        return this.occupantsJidNickname.values().contains(nickname);
    }

    public boolean isOccupantExistsByJid(String senderJid) {
        return this.occupantsJidNickname.containsKey(senderJid);
    }

    public boolean isRoomLocked() {
        return this.roomLocked;
    }

    public void removeListener(RoomListener listener) {
        this.listeners.remove(listener);
    }

    public void removeOccupantByJid(String jid) {
        String nickName = this.occupantsJidNickname.remove(jid);
        if (nickName != null) {
            this.occupantsNicknameJid.remove(nickName);
        }
        this.lastPresences.remove(jid);
        this.roles.remove(jid);
    }

    public void setAffiliations(Map<String, Affiliation> affiliations) {
        this.affiliations.clear();
        this.affiliations.putAll(affiliations);
    }

    public void setNewRole(String occupantJid, Role occupantNewRole) {
        this.roles.put(occupantJid, occupantNewRole);
    }

    public void setNewSubject(String msg, String senderNickname) throws RepositoryException {
        this.subjectChangerNick = senderNickname;
        this.subject = msg;
        this.subjectChangeDate = new Date();
        this.fireOnSetSubject(senderNickname, msg, this.subjectChangeDate);
    }

    public void setRoomLocked(boolean roomLocked) {
        this.roomLocked = roomLocked;
    }

    public void setSubjectChangeDate(Date subjectChangeDate) {
        this.subjectChangeDate = subjectChangeDate;
    }

    public void updatePresenceByJid(String jid, Element element) {
        Element cp = element.clone();
        Element toRemove = cp.getChild("x", "http://jabber.org/protocol/muc");
        if (toRemove != null) {
            cp.removeChild(toRemove);
        }
        this.lastPresences.put(jid, cp);
    }

    public static interface RoomListener {
        public void onChangeSubject(Room var1, String var2, String var3, Date var4);

        public void onSetAffiliation(Room var1, String var2, Affiliation var3);
    }
}

