/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.conf.Configurable;
import tigase.criteria.Criteria;
import tigase.db.RepositoryFactory;
import tigase.db.UserRepository;
import tigase.disco.ServiceEntity;
import tigase.disco.ServiceIdentity;
import tigase.disco.XMPPService;
import tigase.muc.IChatRoomLogger;
import tigase.muc.Module;
import tigase.muc.MucConfig;
import tigase.muc.MucVersion;
import tigase.muc.RoomChatLogger;
import tigase.muc.exceptions.MUCException;
import tigase.muc.modules.DiscoInfoModule;
import tigase.muc.modules.DiscoItemsModule;
import tigase.muc.modules.GroupchatMessageModule;
import tigase.muc.modules.IqStanzaForwarderModule;
import tigase.muc.modules.MediatedInvitationModule;
import tigase.muc.modules.ModeratorModule;
import tigase.muc.modules.PresenceModule;
import tigase.muc.modules.PrivateMessageModule;
import tigase.muc.modules.RoomConfigurationModule;
import tigase.muc.modules.SoftwareVersionModule;
import tigase.muc.modules.UniqueRoomNameModule;
import tigase.muc.modules.XmppPingModule;
import tigase.muc.repository.IMucRepository;
import tigase.muc.repository.MucDAO;
import tigase.muc.repository.inmemory.InMemoryMucRepository;
import tigase.server.AbstractMessageReceiver;
import tigase.server.DisableDisco;
import tigase.server.Packet;
import tigase.util.DNSResolver;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;

public class MUCComponent
extends AbstractMessageReceiver
implements PresenceModule.DelayDeliveryThread.DelDeliverySend,
XMPPService,
Configurable,
DisableDisco {
    public static final String ADMINS_KEY = "admins";
    private static final String LOG_DIR_KEY = "room-log-directory";
    protected static final String MUC_REPO_CLASS_PROP_KEY = "muc-repo-class";
    protected static final String MUC_REPO_URL_PROP_KEY = "muc-repo-url";
    private MucConfig config = new MucConfig();
    private MucDAO dao;
    public String[] HOSTNAMES_PROP_VAL = new String[]{"localhost", "hostname"};
    protected Logger log = Logger.getLogger(this.getClass().getName());
    private final ArrayList<Module> modules = new ArrayList();
    private IMucRepository mucRepository;
    private IChatRoomLogger roomLogger;
    private ServiceEntity serviceEntity;
    private UserRepository userRepository;

    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map props = super.getDefaults(params);
        this.HOSTNAMES_PROP_VAL = params.get("--virt-hosts") != null ? ((String)params.get("--virt-hosts")).split(",") : DNSResolver.getDefHostNames();
        String[] hostnames = new String[this.HOSTNAMES_PROP_VAL.length];
        int i = 0;
        for (String host : this.HOSTNAMES_PROP_VAL) {
            hostnames[i++] = this.getName() + "." + host;
        }
        props.put("hostnames", hostnames);
        String repo_class = "tigase.db.jdbc.JDBCRepository";
        String repo_uri = "jdbc:derby:tigase-derbydb;create=true";
        String conf_db = null;
        if (params.get("--user-db") != null) {
            conf_db = (String)params.get("--user-db");
        }
        if (conf_db != null) {
            if (conf_db.equals("mysql")) {
                repo_class = "tigase.db.jdbc.JDBCRepository";
                repo_uri = "jdbc:mysql://localhost/tigase?user=root&password=mypass";
            }
            if (conf_db.equals("pgsql")) {
                repo_class = "tigase.db.jdbc.JDBCRepository";
                repo_uri = "jdbc:postgresql://localhost/tigase?user=tigase";
            }
        }
        if (params.get("--user-db-uri") != null) {
            repo_uri = (String)params.get("--user-db-uri");
        }
        props.put(MUC_REPO_CLASS_PROP_KEY, repo_class);
        props.put(MUC_REPO_URL_PROP_KEY, repo_uri);
        String[] admins = params.get("--admins") != null ? ((String)params.get("--admins")).split(",") : new String[]{"admin@" + this.getDefHostName()};
        props.put(ADMINS_KEY, admins);
        props.put(LOG_DIR_KEY, new String("./logs/"));
        return props;
    }

    public List<Element> getDiscoFeatures() {
        return null;
    }

    public Element getDiscoInfo(String node, String jid) {
        return null;
    }

    public List<Element> getDiscoItems(String node, String jid) {
        if (node == null) {
            Element result = this.serviceEntity.getDiscoItem(null, this.getName() + "." + jid);
            return Arrays.asList(result);
        }
        return null;
    }

    private Set<String> getFeaturesFromModule() {
        HashSet<String> result = new HashSet<String>();
        for (Module module : this.modules) {
            if (module.getFeatures() == null) continue;
            for (String feature : module.getFeatures()) {
                if (feature == null) continue;
                result.add(feature);
            }
        }
        return result;
    }

    protected void init() {
        this.registerModule(new PrivateMessageModule(this.config, this.mucRepository));
        GroupchatMessageModule messageModule = this.registerModule(new GroupchatMessageModule(this.config, this.mucRepository, this.roomLogger));
        this.registerModule(new PresenceModule(this.config, this.mucRepository, this.roomLogger, this));
        this.registerModule(new RoomConfigurationModule(this.config, this.mucRepository, messageModule));
        this.registerModule(new ModeratorModule(this.config, this.mucRepository));
        this.registerModule(new SoftwareVersionModule());
        this.registerModule(new XmppPingModule());
        this.registerModule(new DiscoItemsModule(this.config, this.mucRepository));
        this.registerModule(new DiscoInfoModule(this.config, this.mucRepository, this.getFeaturesFromModule()));
        this.registerModule(new MediatedInvitationModule(this.config, this.mucRepository));
        this.registerModule(new UniqueRoomNameModule(this.config, this.mucRepository));
        this.registerModule(new IqStanzaForwarderModule(this.config, this.mucRepository));
    }

    public void processPacket(Packet packet) {
        try {
            Collection<Element> result = this.process(packet.getElement());
            for (Element element : result) {
                this.addOutPacket(new Packet(element));
            }
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Unexpected exception: internal-server-error", e);
            e.printStackTrace();
            try {
                this.addOutPacket(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, e.getMessage(), true));
            }
            catch (PacketErrorTypeException e1) {
                e1.printStackTrace();
                this.log.throwing("MUC Component", "processPacket (sending internal-server-error)", e);
            }
        }
    }

    public <T extends Module> T registerModule(T module) {
        this.log.config("Register MUC plugin: " + module.getClass().getCanonicalName());
        this.modules.add(module);
        return module;
    }

    protected boolean runModules(Element element, Collection<Element> sendCollection) throws MUCException {
        boolean handled = false;
        this.log.finest("Processing packet: " + element.toString());
        for (Module module : this.modules) {
            Criteria criteria = module.getModuleCriteria();
            if (criteria == null || !criteria.match(element) || !module.isProcessedByModule(element)) continue;
            handled = true;
            this.log.finest("Handled by module " + module.getClass());
            List<Element> result = module.process(element);
            if (result == null) continue;
            sendCollection.addAll(result);
            return true;
        }
        return handled;
    }

    @Override
    public void sendDelayedPacket(Packet packet) {
        this.addOutPacket(packet);
    }

    public void setProperties(Map<String, Object> props) {
        super.setProperties(props);
        this.serviceEntity = new ServiceEntity(this.getName(), null, "Multi User Chat");
        this.serviceEntity.addIdentities(new ServiceIdentity[]{new ServiceIdentity("conference", "text", "Multi User Chat")});
        this.serviceEntity.addFeatures(new String[]{"http://jabber.org/protocol/muc"});
        this.config.setServiceName("multi-user-chat");
        this.config.setLogDirectory((String)props.get(LOG_DIR_KEY));
        try {
            String cls_name = (String)props.get(MUC_REPO_CLASS_PROP_KEY);
            String res_uri = (String)props.get(MUC_REPO_URL_PROP_KEY);
            this.userRepository = RepositoryFactory.getUserRepository((String)this.getName(), (String)cls_name, (String)res_uri, null);
            this.userRepository.initRepository(res_uri, null);
            this.dao = new MucDAO(this.config, this.userRepository);
            this.mucRepository = new InMemoryMucRepository(this.config, this.dao);
        }
        catch (Exception e) {
            this.log.severe("Can't initialize MUC repository: " + e);
            e.printStackTrace();
            System.exit(1);
        }
        this.roomLogger = new RoomChatLogger(this.config);
        this.init();
        this.log.info("Tigase MUC Component ver. " + MucVersion.getVersion() + " started.");
    }

    public Collection<Element> process(Element element) throws PacketErrorTypeException {
        ArrayList<Element> result = new ArrayList<Element>();
        try {
            boolean handled = this.runModules(element, result);
            if (!handled) {
                StanzaType type;
                String t = element.getAttribute("type");
                StanzaType stanzaType = type = t == null ? null : StanzaType.valueof((String)t);
                if (type != StanzaType.error) {
                    throw new MUCException(Authorization.FEATURE_NOT_IMPLEMENTED);
                }
                this.log.finer(element.getName() + " stanza with type='error' ignored");
            }
        }
        catch (MUCException e) {
            Element r = e.makeElement(element, true);
            result.add(r);
        }
        return result;
    }
}

