/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import tigase.muc.XMPPDateTimeFormatter;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;

public class History {
    private final XMPPDateTimeFormatter dateTimeFormatter = new XMPPDateTimeFormatter();
    private int maxSize = 100;
    private LinkedList<HItem> stanzas = new LinkedList();

    public void add(String message, String senderJid, String senderNickname, Date time) {
        if (this.stanzas.size() >= this.maxSize) {
            this.stanzas.poll();
        }
        HItem item = new HItem();
        item.message = message;
        item.senderJid = senderJid;
        item.senderNickname = senderNickname;
        item.timestamp = time;
        this.stanzas.add(item);
    }

    public List<Element> getMessages(String recipientJid, String roomId, boolean addRealJids) {
        ArrayList<Element> m = new ArrayList<Element>();
        for (HItem item : this.stanzas) {
            Element message = new Element("message", new String[]{"from", "to", "type"}, new String[]{roomId + "/" + item.senderNickname, recipientJid, "groupchat"});
            message.addChild((XMLNodeIfc)new Element("body", item.message));
            String from = addRealJids ? item.senderJid : roomId + "/" + item.senderNickname;
            Element delay = new Element("delay", new String[]{"xmlns", "from", "stamp"}, new String[]{"urn:xmpp:delay", from, this.dateTimeFormatter.format(item.timestamp)});
            Element x = new Element("x", new String[]{"xmlns", "from", "stamp"}, new String[]{"jabber:x:delay", from, this.dateTimeFormatter.formatOld(item.timestamp)});
            message.addChild((XMLNodeIfc)delay);
            message.addChild((XMLNodeIfc)x);
            m.add(message);
        }
        return m;
    }

    private static class HItem {
        String message;
        String senderJid;
        String senderNickname;
        Date timestamp;

        private HItem() {
        }
    }
}

