/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.repository.inmemory;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import tigase.muc.Affiliation;
import tigase.muc.MucConfig;
import tigase.muc.Room;
import tigase.muc.RoomConfig;
import tigase.muc.repository.IMucRepository;
import tigase.muc.repository.MucDAO;
import tigase.muc.repository.RepositoryException;
import tigase.util.JIDUtils;

public class InMemoryMucRepository
implements IMucRepository {
    private final Map<String, InternalRoom> allRooms = new HashMap<String, InternalRoom>();
    private final MucConfig config;
    private final MucDAO dao;
    private RoomConfig defaultConfig = new RoomConfig(null);
    protected Logger log = Logger.getLogger(this.getClass().getName());
    private final RoomConfig.RoomConfigListener roomConfigListener;
    private final Room.RoomListener roomListener;
    private final HashMap<String, Room> rooms = new HashMap();

    public InMemoryMucRepository(MucConfig mucConfig, final MucDAO dao) throws RepositoryException {
        this.dao = dao;
        this.config = mucConfig;
        String[] rooms = dao.getRoomsIdList();
        if (rooms != null) {
            for (String jid : rooms) {
                this.allRooms.put(jid, new InternalRoom());
            }
        }
        this.roomListener = new Room.RoomListener(){

            @Override
            public void onChangeSubject(Room room, String nick, String newSubject, Date changeDate) {
                try {
                    if (room.getConfig().isPersistentRoom()) {
                        dao.setSubject(room.getRoomId(), newSubject, nick, changeDate);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void onSetAffiliation(Room room, String jid, Affiliation newAffiliation) {
                try {
                    if (room.getConfig().isPersistentRoom()) {
                        dao.setAffiliation(room.getRoomId(), jid, newAffiliation);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.roomConfigListener = new RoomConfig.RoomConfigListener(){

            @Override
            public void onConfigChanged(RoomConfig roomConfig, Set<String> modifiedVars) {
                try {
                    InternalRoom ir;
                    if (modifiedVars.contains("muc#roomconfig_publicroom") && (ir = (InternalRoom)InMemoryMucRepository.this.allRooms.get(roomConfig.getRoomId())) != null) {
                        ir.listPublic = roomConfig.isRoomconfigPublicroom();
                    }
                    if (modifiedVars.contains("muc#roomconfig_persistentroom")) {
                        if (roomConfig.isPersistentRoom()) {
                            System.out.println("now is PERSISTENT");
                            Room room = InMemoryMucRepository.this.getRoom(roomConfig.getRoomId());
                            dao.createRoom(room);
                        } else {
                            System.out.println("now is NOT! PERSISTENT");
                            dao.destroyRoom(roomConfig.getRoomId());
                        }
                    } else if (roomConfig.isPersistentRoom()) {
                        dao.updateRoomConfig(roomConfig);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    @Override
    public Room createNewRoom(String roomId, String senderJid) throws RepositoryException {
        this.log.fine("Creating new room '" + roomId + "'");
        RoomConfig rc = new RoomConfig(roomId);
        rc.copyFrom(this.getDefaultRoomConfig(), false);
        Room room = new Room(rc, new Date(), JIDUtils.getNodeID((String)senderJid));
        room.getConfig().addListener(this.roomConfigListener);
        room.addListener(this.roomListener);
        this.rooms.put(roomId, room);
        this.allRooms.put(roomId, new InternalRoom());
        return room;
    }

    @Override
    public RoomConfig getDefaultRoomConfig() throws RepositoryException {
        return this.defaultConfig;
    }

    @Override
    public String[] getPublicVisibleRoomsIdList() throws RepositoryException {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, InternalRoom> entry : this.allRooms.entrySet()) {
            if (!entry.getValue().listPublic) continue;
            result.add(entry.getKey());
        }
        return result.toArray(new String[0]);
    }

    @Override
    public Room getRoom(String roomId) throws RepositoryException {
        Room room = this.rooms.get(roomId);
        if (room == null && (room = this.dao.readRoom(roomId)) != null) {
            room.getConfig().addListener(this.roomConfigListener);
            room.addListener(this.roomListener);
            this.rooms.put(roomId, room);
        }
        return room;
    }

    @Override
    public String getRoomName(String jid) throws RepositoryException {
        return this.dao.getRoomName(jid);
    }

    @Override
    public boolean isRoomIdExists(String newRoomName) {
        return this.allRooms.containsKey(newRoomName);
    }

    @Override
    public void leaveRoom(Room room) {
        String roomId = room.getRoomId();
        this.log.fine("Removing room '" + roomId + "' from memory");
        this.rooms.remove(roomId);
        if (!room.getConfig().isPersistentRoom()) {
            this.allRooms.remove(roomId);
        }
    }

    private class InternalRoom {
        boolean listPublic = true;

        private InternalRoom() {
        }
    }
}

