/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.repository;

import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.muc.Affiliation;
import tigase.muc.MucConfig;
import tigase.muc.Room;
import tigase.muc.RoomConfig;
import tigase.muc.repository.RepositoryException;

public class MucDAO {
    private static final String CREATION_DATE_KEY = "creation-date";
    private static final String CREATOR_JID_KEY = "creator";
    private static final String LAST_ACCESS_DATE_KEY = "last-access-date";
    private static final String ROOMS_KEY = "rooms/";
    private static final String SUBJECT_CREATOR_NICK_KEY = "creator";
    private static final String SUBJECT_DATE_KEY = "date";
    private static final String SUBJECT_KEY = "subject";
    protected Logger log = Logger.getLogger(this.getClass().getName());
    private final MucConfig mucConfig;
    private final UserRepository repository;

    public MucDAO(MucConfig config, UserRepository repository) throws RepositoryException {
        this.mucConfig = config;
        this.repository = repository;
        try {
            this.repository.setData(this.mucConfig.getServiceName(), "last-start", String.valueOf(System.currentTimeMillis()));
        }
        catch (UserNotFoundException e) {
            try {
                this.repository.addUser(this.mucConfig.getServiceName());
                this.repository.setData(this.mucConfig.getServiceName(), "last-start", String.valueOf(System.currentTimeMillis()));
            }
            catch (Exception e1) {
                this.log.log(Level.SEVERE, "MUC repository initialization problem", e1);
                throw new RepositoryException("Cannot initialize MUC repository", e);
            }
        }
        catch (TigaseDBException e) {
            this.log.log(Level.SEVERE, "MUC repository initialization problem", e);
            throw new RepositoryException("Cannot initialize MUC repository", e);
        }
    }

    public void createRoom(Room room) throws RepositoryException {
        try {
            this.repository.setData(this.mucConfig.getServiceName(), ROOMS_KEY + room.getRoomId(), CREATION_DATE_KEY, String.valueOf(room.getCreationDate().getTime()));
            this.repository.setData(this.mucConfig.getServiceName(), ROOMS_KEY + room.getRoomId(), "creator", room.getCreatorJid());
            this.repository.setData(this.mucConfig.getServiceName(), ROOMS_KEY + room.getRoomId(), LAST_ACCESS_DATE_KEY, String.valueOf(new Date().getTime()));
            room.getConfig().write(this.repository, this.mucConfig, ROOMS_KEY + room.getRoomId() + "/config");
            for (String affJid : room.getAffiliations()) {
                Affiliation a = room.getAffiliation(affJid);
                this.setAffiliation(room.getRoomId(), affJid, a);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RepositoryException("Room creation error", e);
        }
    }

    public void destroyRoom(String roomId) throws RepositoryException {
        try {
            this.repository.removeSubnode(this.mucConfig.getServiceName(), ROOMS_KEY + roomId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RepositoryException("Room destroing error", e);
        }
    }

    public Date getCreationDate(String roomId) throws RepositoryException {
        try {
            String creationDate = this.repository.getData(this.mucConfig.getServiceName(), ROOMS_KEY + roomId, CREATION_DATE_KEY);
            if (creationDate == null) {
                return null;
            }
            Date r = new Date(Long.valueOf(creationDate));
            return r;
        }
        catch (Exception e) {
            throw new RepositoryException("Creation Date reading error", e);
        }
    }

    public String getRoomName(String jid) throws RepositoryException {
        try {
            return this.repository.getData(this.mucConfig.getServiceName(), ROOMS_KEY + jid + "/config", "muc#roomconfig_roomname");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RepositoryException("Room name reading error", e);
        }
    }

    public String[] getRoomsIdList() throws RepositoryException {
        try {
            return this.repository.getSubnodes(this.mucConfig.getServiceName(), ROOMS_KEY);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RepositoryException("Room list reading error", e);
        }
    }

    public String getSubject(String roomId) throws RepositoryException {
        try {
            return this.repository.getData(this.mucConfig.getServiceName(), ROOMS_KEY + roomId + "/subject", SUBJECT_KEY);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RepositoryException("Subject saving error", e);
        }
    }

    public Date getSubjectCreationDate(String roomId) throws RepositoryException {
        try {
            String tmp = this.repository.getData(this.mucConfig.getServiceName(), ROOMS_KEY + roomId + "/subject", SUBJECT_DATE_KEY);
            return tmp == null ? null : new Date(Long.valueOf(tmp));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RepositoryException("Subject change date reading error", e);
        }
    }

    public String getSubjectCreatorNickname(String roomId) throws RepositoryException {
        try {
            return this.repository.getData(this.mucConfig.getServiceName(), ROOMS_KEY + roomId + "/subject", "creator");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RepositoryException("Subject saving error", e);
        }
    }

    public Room readRoom(String roomId) throws RepositoryException {
        try {
            String tmpDate = this.repository.getData(this.mucConfig.getServiceName(), ROOMS_KEY + roomId, CREATION_DATE_KEY);
            String creatorJid = this.repository.getData(this.mucConfig.getServiceName(), ROOMS_KEY + roomId, "creator");
            if (tmpDate != null && creatorJid != null) {
                String[] affJids;
                Date date = new Date(Long.valueOf(tmpDate));
                RoomConfig rc = new RoomConfig(roomId);
                rc.read(this.repository, this.mucConfig, ROOMS_KEY + roomId + "/config");
                Room room = new Room(rc, date, creatorJid);
                String subject = this.getSubject(roomId);
                String subjectCreator = this.getSubjectCreatorNickname(roomId);
                Date subjectChangeDate = this.getSubjectCreationDate(roomId);
                room.setNewSubject(subject, subjectCreator);
                room.setSubjectChangeDate(subjectChangeDate);
                HashMap<String, Affiliation> affiliations = new HashMap<String, Affiliation>();
                for (String jid : affJids = this.repository.getKeys(this.mucConfig.getServiceName(), ROOMS_KEY + roomId + "/affiliations")) {
                    String t = this.repository.getData(this.mucConfig.getServiceName(), ROOMS_KEY + roomId + "/affiliations", jid);
                    Affiliation affiliation = Affiliation.valueOf(t);
                    affiliations.put(jid, affiliation);
                }
                room.setAffiliations(affiliations);
                return room;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RepositoryException("Room reading error", e);
        }
    }

    public void setAffiliation(String roomId, String jid, Affiliation affiliation) throws RepositoryException {
        try {
            if (affiliation == Affiliation.none) {
                this.repository.removeData(this.mucConfig.getServiceName(), ROOMS_KEY + roomId + "/affiliations", jid);
            } else {
                this.repository.setData(this.mucConfig.getServiceName(), ROOMS_KEY + roomId + "/affiliations", jid, affiliation.name());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RepositoryException("Affiliation saving error", e);
        }
    }

    public void setSubject(String roomId, String subject, String creatorNickname, Date changeDate) throws RepositoryException {
        try {
            this.repository.setData(this.mucConfig.getServiceName(), ROOMS_KEY + roomId + "/subject", "creator", creatorNickname);
            this.repository.setData(this.mucConfig.getServiceName(), ROOMS_KEY + roomId + "/subject", SUBJECT_KEY, subject);
            this.repository.setData(this.mucConfig.getServiceName(), ROOMS_KEY + roomId + "/subject", SUBJECT_DATE_KEY, String.valueOf(changeDate.getTime()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RepositoryException("Subject saving error", e);
        }
    }

    public void updateLastAccessDate(String roomId) throws RepositoryException {
        try {
            this.repository.setData(this.mucConfig.getServiceName(), ROOMS_KEY + roomId, LAST_ACCESS_DATE_KEY, String.valueOf(new Date().getTime()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RepositoryException("Last access date writing error", e);
        }
    }

    public void updateRoomConfig(RoomConfig roomConfig) throws RepositoryException {
        try {
            roomConfig.write(this.repository, this.mucConfig, ROOMS_KEY + roomConfig.getRoomId() + "/config");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RepositoryException("Room config writing error", e);
        }
    }
}

