/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.List;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.muc.MucConfig;
import tigase.muc.exceptions.MUCException;
import tigase.muc.modules.AbstractModule;
import tigase.muc.repository.IMucRepository;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xmpp.Authorization;

public class UniqueRoomNameModule
extends AbstractModule {
    private static final String CHARS = "abcdefghijklmnopqrstuvwxyz0123456789";
    private static final Criteria CRIT = ElementCriteria.nameType((String)"iq", (String)"get").add((Criteria)ElementCriteria.name((String)"unique", (String)"http://jabber.org/protocol/muc#unique"));
    private SecureRandom random;

    public UniqueRoomNameModule(MucConfig config, IMucRepository mucRepository) {
        super(config, mucRepository);
        try {
            this.random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            this.random = new SecureRandom();
        }
    }

    private String generateName(int len) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            int a = this.random.nextInt(CHARS.length());
            sb.append(CHARS.charAt(a));
        }
        return sb.toString();
    }

    @Override
    public String[] getFeatures() {
        return null;
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    @Override
    public List<Element> process(Element element) throws MUCException {
        try {
            String newRoomName;
            if (JIDUtils.getNodeResource((String)element.getAttribute("to")) != null || JIDUtils.getNodeNick((String)element.getAttribute("to")) != null) {
                throw new MUCException(Authorization.BAD_REQUEST);
            }
            String host = JIDUtils.getNodeHost((String)element.getAttribute("to"));
            while (this.repository.isRoomIdExists((newRoomName = this.generateName(30)) + "@" + host)) {
            }
            Element iq = UniqueRoomNameModule.createResultIQ(element);
            Element unique = new Element("unique", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc#unique"});
            iq.addChild(unique);
            unique.setCData(newRoomName);
            return UniqueRoomNameModule.makeArray(iq);
        }
        catch (MUCException e1) {
            throw e1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

