/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.util.List;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.form.Form;
import tigase.muc.Affiliation;
import tigase.muc.MucConfig;
import tigase.muc.Room;
import tigase.muc.RoomConfig;
import tigase.muc.exceptions.MUCException;
import tigase.muc.modules.AbstractModule;
import tigase.muc.modules.GroupchatMessageModule;
import tigase.muc.repository.IMucRepository;
import tigase.muc.repository.RepositoryException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;

public class RoomConfigurationModule
extends AbstractModule {
    private static final Criteria CRIT = ElementCriteria.name((String)"iq").add((Criteria)ElementCriteria.name((String)"query", (String)"http://jabber.org/protocol/muc#owner"));
    private final GroupchatMessageModule messageModule;

    public RoomConfigurationModule(MucConfig config, IMucRepository mucRepository, GroupchatMessageModule messageModule) {
        super(config, mucRepository);
        this.messageModule = messageModule;
    }

    @Override
    public String[] getFeatures() {
        return null;
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    private Element makeConfigFormIq(Element request, RoomConfig roomConfig) {
        Element response = RoomConfigurationModule.createResultIQ(request);
        Element query = new Element("query", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc#owner"});
        response.addChild(query);
        query.addChild(roomConfig.getConfigForm().getElement());
        return response;
    }

    @Override
    public List<Element> process(Element element) throws MUCException {
        try {
            if (RoomConfigurationModule.getNicknameFromJid(element.getAttribute("to")) != null) {
                throw new MUCException(Authorization.BAD_REQUEST);
            }
            String type = element.getAttribute("type");
            if ("set".equals(type)) {
                return this.processSet(element);
            }
            if ("get".equals(type)) {
                return this.processGet(element);
            }
            throw new MUCException(Authorization.BAD_REQUEST);
        }
        catch (MUCException e1) {
            throw e1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private List<Element> processGet(Element element) throws RepositoryException, MUCException {
        String roomId = RoomConfigurationModule.getRoomId(element.getAttribute("to"));
        String senderJid = element.getAttribute("from");
        Room room = this.repository.getRoom(roomId);
        if (room == null) {
            return RoomConfigurationModule.makeArray(this.makeConfigFormIq(element, this.repository.getDefaultRoomConfig()));
        }
        if (room.getAffiliation(senderJid) != Affiliation.owner) {
            throw new MUCException(Authorization.FORBIDDEN);
        }
        Element response = this.makeConfigFormIq(element, room.getConfig());
        return RoomConfigurationModule.makeArray(response);
    }

    private List<Element> processSet(Element element) throws RepositoryException, MUCException {
        String roomId = RoomConfigurationModule.getRoomId(element.getAttribute("to"));
        String senderJid = element.getAttribute("from");
        Element query = element.getChild("query", "http://jabber.org/protocol/muc#owner");
        Room room = this.repository.getRoom(roomId);
        if (room == null) {
            room = this.repository.createNewRoom(roomId, senderJid);
        } else if (room.getAffiliation(senderJid) != Affiliation.owner) {
            throw new MUCException(Authorization.FORBIDDEN);
        }
        List<Element> result = RoomConfigurationModule.makeArray(RoomConfigurationModule.createResultIQ(element));
        Element x = query.getChild("x", "jabber:x:data");
        Form form = new Form(x);
        if ("submit".equals(form.getType())) {
            String ps = form.getAsString("muc#roomconfig_roomsecret");
            if (form.getAsBoolean("muc#roomconfig_passwordprotectedroom") == Boolean.TRUE && (ps == null || ps.length() == 0)) {
                throw new MUCException(Authorization.NOT_ACCEPTABLE, "Passwords cannot be empty");
            }
            RoomConfig oldConfig = room.getConfig().clone();
            if (room.isRoomLocked()) {
                room.setRoomLocked(false);
                this.log.fine("Room " + room.getRoomId() + " is now unlocked");
                result.add(RoomConfigurationModule.prepateMucMessage(room, room.getOccupantsNickname(senderJid), "Room is now unlocked"));
            }
            room.getConfig().copyFrom(form);
            String[] compareResult = room.getConfig().compareTo(oldConfig);
            if (compareResult != null) {
                Element z = new Element("x", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc#user"});
                for (String code : compareResult) {
                    z.addChild(new Element("status", new String[]{"code"}, new String[]{code}));
                }
                result.addAll(this.messageModule.sendMessagesToAllOccupants(room, roomId, z));
            }
        }
        return result;
    }
}

