/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.util.List;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.muc.MucConfig;
import tigase.muc.Role;
import tigase.muc.Room;
import tigase.muc.exceptions.MUCException;
import tigase.muc.modules.AbstractModule;
import tigase.muc.repository.IMucRepository;
import tigase.xml.Element;
import tigase.xmpp.Authorization;

public class PrivateMessageModule
extends AbstractModule {
    private static final Criteria CRIT = ElementCriteria.nameType((String)"message", (String)"chat");

    public PrivateMessageModule(MucConfig config, IMucRepository mucRepository) {
        super(config, mucRepository);
    }

    @Override
    public String[] getFeatures() {
        return null;
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    @Override
    public List<Element> process(Element element) throws MUCException {
        try {
            String senderJid = element.getAttribute("from");
            String roomId = PrivateMessageModule.getRoomId(element.getAttribute("to"));
            String recipientNickname = PrivateMessageModule.getNicknameFromJid(element.getAttribute("to"));
            if (recipientNickname == null) {
                throw new MUCException(Authorization.BAD_REQUEST);
            }
            Room room = this.repository.getRoom(roomId);
            if (room == null) {
                throw new MUCException(Authorization.ITEM_NOT_FOUND);
            }
            Role senderRole = room.getRoleByJid(senderJid);
            if (!senderRole.isSendPrivateMessages()) {
                throw new MUCException(Authorization.NOT_ALLOWED);
            }
            String recipientJid = room.getOccupantsJidByNickname(recipientNickname);
            if (recipientJid == null) {
                throw new MUCException(Authorization.ITEM_NOT_FOUND, "Unknown recipient");
            }
            String senderNickname = room.getOccupantsNickname(senderJid);
            Element message = element.clone();
            message.setAttribute("from", roomId + "/" + senderNickname);
            message.setAttribute("to", recipientJid);
            return PrivateMessageModule.makeArray(message);
        }
        catch (MUCException e1) {
            throw e1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

