/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.muc.Affiliation;
import tigase.muc.IChatRoomLogger;
import tigase.muc.MucConfig;
import tigase.muc.Role;
import tigase.muc.Room;
import tigase.muc.RoomConfig;
import tigase.muc.XMPPDateTimeFormatter;
import tigase.muc.exceptions.MUCException;
import tigase.muc.modules.AbstractModule;
import tigase.muc.repository.IMucRepository;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.Authorization;

public class PresenceModule
extends AbstractModule {
    private static final Criteria CRIT = ElementCriteria.name((String)"presence");
    private static final XMPPDateTimeFormatter sdf = new XMPPDateTimeFormatter();
    private final IChatRoomLogger chatRoomLogger;
    private final DelayDeliveryThread delayDeliveryThread;

    private static Role getDefaultRole(RoomConfig config, Affiliation affiliation) {
        Role newRole;
        if (config.isRoomModerated() && affiliation == Affiliation.none) {
            newRole = Role.visitor;
        } else {
            switch (affiliation) {
                case admin: {
                    newRole = Role.moderator;
                    break;
                }
                case member: {
                    newRole = Role.participant;
                    break;
                }
                case none: {
                    newRole = Role.participant;
                    break;
                }
                case outcast: {
                    newRole = Role.none;
                    break;
                }
                case owner: {
                    newRole = Role.moderator;
                    break;
                }
                default: {
                    newRole = Role.none;
                }
            }
        }
        return newRole;
    }

    public PresenceModule(MucConfig config, IMucRepository mucRepository, IChatRoomLogger chatRoomLogger, DelayDeliveryThread.DelDeliverySend sender) {
        super(config, mucRepository);
        this.chatRoomLogger = chatRoomLogger;
        this.delayDeliveryThread = new DelayDeliveryThread(sender);
        this.delayDeliveryThread.start();
    }

    @Override
    public String[] getFeatures() {
        return null;
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    private List<Element> preparePresenceToAllOccupants(Room room, String roomURL, String nickName, Affiliation affiliation, Role role, String senderJid, boolean newRoomCreated, String newNickName) {
        ArrayList<Element> result = new ArrayList<Element>();
        RoomConfig.Anonymity anonymity = room.getConfig().getRoomAnonymity();
        for (String occupantJid : room.getOccupantsJids()) {
            Element presence;
            Affiliation occupantAffiliation = room.getAffiliation(occupantJid);
            if (newNickName != null) {
                presence = new Element("presence");
                presence.setAttribute("type", "unavailable");
            } else {
                presence = room.getLastPresenceCopyByJid(senderJid);
            }
            presence.setAttribute("from", roomURL + "/" + nickName);
            presence.setAttribute("to", occupantJid);
            Element x = new Element("x", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc#user"});
            Element item = new Element("item", new String[]{"affiliation", "role"}, new String[]{affiliation.name(), role.name()});
            if (senderJid.equals(occupantJid)) {
                x.addChild(new Element("status", new String[]{"code"}, new String[]{"110"}));
                if (anonymity == RoomConfig.Anonymity.nonanonymous) {
                    x.addChild(new Element("status", new String[]{"code"}, new String[]{"100"}));
                }
                if (room.getConfig().isLoggingEnabled()) {
                    x.addChild(new Element("status", new String[]{"code"}, new String[]{"170"}));
                }
            }
            if (newRoomCreated) {
                x.addChild(new Element("status", new String[]{"code"}, new String[]{"201"}));
            }
            if (anonymity == RoomConfig.Anonymity.nonanonymous || anonymity == RoomConfig.Anonymity.semianonymous && occupantAffiliation.isViewOccupantsJid()) {
                item.setAttribute("jid", senderJid);
            }
            if (newNickName != null) {
                x.addChild(new Element("status", new String[]{"code"}, new String[]{"303"}));
                item.setAttribute("nick", newNickName);
            }
            x.addChild(item);
            presence.addChild(x);
            result.add(presence);
        }
        return result;
    }

    @Override
    public List<Element> process(Element element) throws MUCException {
        try {
            Role role;
            boolean changeNickName;
            boolean newOccupant;
            Element password;
            ArrayList<Element> result = new ArrayList<Element>();
            String senderJid = element.getAttribute("from");
            String roomId = PresenceModule.getRoomId(element.getAttribute("to"));
            String nickName = PresenceModule.getNicknameFromJid(element.getAttribute("to"));
            String presenceType = element.getAttribute("type");
            boolean newRoomCreated = false;
            boolean exitingRoom = presenceType != null && "unavailable".equals(presenceType);
            Element $x = element.getChild("x");
            Element element2 = password = $x == null ? null : $x.getChild("password");
            if (nickName == null) {
                throw new MUCException(Authorization.JID_MALFORMED);
            }
            Room room = this.repository.getRoom(roomId);
            if (room == null) {
                this.log.info("Creating new room '" + roomId + "' by user " + nickName + "' <" + senderJid + ">");
                room = this.repository.createNewRoom(roomId, senderJid);
                room.addAffiliationByJid(senderJid, Affiliation.owner);
                room.setRoomLocked(true);
                newRoomCreated = true;
            }
            boolean bl = newOccupant = !room.isOccupantExistsByJid(senderJid);
            if (newOccupant && room.getConfig().isPasswordProtectedRoom()) {
                String psw;
                String string = psw = password == null ? null : password.getCData();
                if (psw == null || !psw.equals(room.getConfig().getPassword())) {
                    throw new MUCException(Authorization.NOT_AUTHORIZED);
                }
            }
            if (!newRoomCreated && room.isRoomLocked() && !exitingRoom) {
                throw new MUCException(Authorization.ITEM_NOT_FOUND, "Room is locked");
            }
            if (exitingRoom && !room.isOccupantExistsByJid(senderJid)) {
                return null;
            }
            RoomConfig.Anonymity anonymity = room.getConfig().getRoomAnonymity();
            Affiliation affiliation = room.getAffiliation(senderJid);
            if (!affiliation.isEnterOpenRoom()) {
                this.log.info("User " + nickName + "' <" + senderJid + "> is on rooms '" + roomId + "' blacklist");
                throw new MUCException(Authorization.FORBIDDEN);
            }
            if (room.getConfig().isRoomMembersOnly() && !affiliation.isEnterMembersOnlyRoom()) {
                this.log.info("User " + nickName + "' <" + senderJid + "> is NOT on rooms '" + roomId + "' member list.");
                throw new MUCException(Authorization.REGISTRATION_REQUIRED);
            }
            boolean bl2 = changeNickName = !newOccupant && !room.getOccupantsNickname(senderJid).equals(nickName);
            if ((newOccupant || changeNickName) && room.isNickNameExists(nickName)) {
                throw new MUCException(Authorization.CONFLICT);
            }
            if (newOccupant) {
                for (String occupantJid : room.getOccupantsJids()) {
                    String occupantNickname = room.getOccupantsNickname(occupantJid);
                    Affiliation occupantAffiliation = room.getAffiliation(occupantJid);
                    Role occupantRole = room.getRoleByJid(occupantJid);
                    Element presence = room.getLastPresenceCopyByJid(occupantJid);
                    presence.setAttribute("from", roomId + "/" + occupantNickname);
                    presence.setAttribute("to", senderJid);
                    Element x = new Element("x", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc#user"});
                    Element item = new Element("item", new String[]{"affiliation", "role"}, new String[]{occupantAffiliation.name(), occupantRole.name()});
                    if (anonymity == RoomConfig.Anonymity.nonanonymous || anonymity == RoomConfig.Anonymity.semianonymous && (affiliation == Affiliation.admin || affiliation == Affiliation.owner)) {
                        item.setAttribute("jid", occupantJid);
                    }
                    x.addChild(item);
                    presence.addChild(x);
                    result.add(presence);
                }
                Role newRole = PresenceModule.getDefaultRole(room.getConfig(), affiliation);
                this.log.finest("Occupant '" + nickName + "' <" + senderJid + "> is entering room " + roomId + " as role=" + newRole.name() + ", affiliation=" + affiliation.name());
                room.addOccupantByJid(senderJid, nickName, newRole);
            }
            room.updatePresenceByJid(senderJid, element);
            Role role2 = role = exitingRoom ? Role.none : room.getRoleByJid(senderJid);
            if (changeNickName) {
                String nck = room.getOccupantsNickname(senderJid);
                this.log.finest("Occupant '" + nck + "' <" + senderJid + "> is changing his nickname to '" + nickName + "'");
                result.addAll(this.preparePresenceToAllOccupants(room, roomId, nck, affiliation, role, senderJid, newRoomCreated, nickName));
                room.changeNickName(senderJid, nickName);
            }
            result.addAll(this.preparePresenceToAllOccupants(room, roomId, nickName, affiliation, role, senderJid, newRoomCreated, null));
            if (exitingRoom) {
                this.log.finest("Occupant '" + nickName + "' <" + senderJid + "> is leaving room " + roomId);
                room.removeOccupantByJid(senderJid);
            }
            if (newOccupant) {
                this.delayDeliveryThread.put(room.getHistoryMessages(senderJid));
            }
            if (newOccupant && room.getSubject() != null && room.getSubjectChangerNick() != null && room.getSubjectChangeDate() != null) {
                Element message = new Element("message", new String[]{"type", "from", "to"}, new String[]{"groupchat", roomId + "/" + room.getSubjectChangerNick(), senderJid});
                message.addChild(new Element("subject", room.getSubject()));
                String stamp = sdf.format(room.getSubjectChangeDate());
                Element delay = new Element("delay", new String[]{"xmlns", "stamp"}, new String[]{"urn:xmpp:delay", stamp});
                delay.setAttribute("jid", roomId + "/" + room.getSubjectChangerNick());
                Element x = new Element("x", new String[]{"xmlns", "stamp"}, new String[]{"jabber:x:delay", sdf.formatOld(room.getSubjectChangeDate())});
                message.addChild(delay);
                message.addChild(x);
                this.delayDeliveryThread.put(message);
            }
            if (room.isRoomLocked() && newOccupant) {
                result.add(PresenceModule.prepateMucMessage(room, room.getOccupantsNickname(senderJid), "Room is locked. Please configure."));
            }
            if (room.getConfig().isLoggingEnabled() && newOccupant) {
                this.chatRoomLogger.addJoin(room.getConfig().getLoggingFormat(), roomId, new Date(), nickName);
            } else if (room.getConfig().isLoggingEnabled() && exitingRoom) {
                this.chatRoomLogger.addLeave(room.getConfig().getLoggingFormat(), roomId, new Date(), nickName);
            }
            int occupantsCount = room.getOccupantsCount();
            if (occupantsCount == 0) {
                this.repository.leaveRoom(room);
            }
            return result;
        }
        catch (MUCException e1) {
            throw e1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static class DelayDeliveryThread
    extends Thread {
        private final LinkedList<Element[]> items = new LinkedList();
        private final DelDeliverySend sender;

        public DelayDeliveryThread(DelDeliverySend component) {
            this.sender = component;
        }

        public void put(Element element) {
            this.items.add(new Element[]{element});
        }

        public void put(List<Element> elements) {
            if (elements != null && elements.size() > 0) {
                this.items.push(elements.toArray(new Element[0]));
            }
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            try {
                block2: while (true) {
                    DelayDeliveryThread.sleep(553L);
                    if (this.items.size() <= 0 || (toSend = this.items.poll()) == null) continue;
                    arr$ = toSend;
                    len$ = arr$.length;
                    i$ = 0;
                    while (true) {
                        if (i$ < len$) ** break;
                        continue block2;
                        element = arr$[i$];
                        this.sender.sendDelayedPacket(new Packet(element));
                        ++i$;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
        }

        public static interface DelDeliverySend {
            public void sendDelayedPacket(Packet var1);
        }
    }
}

