/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.util.ArrayList;
import java.util.List;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.muc.Affiliation;
import tigase.muc.MucConfig;
import tigase.muc.Role;
import tigase.muc.Room;
import tigase.muc.RoomConfig;
import tigase.muc.exceptions.MUCException;
import tigase.muc.modules.AbstractModule;
import tigase.muc.repository.IMucRepository;
import tigase.muc.repository.RepositoryException;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xmpp.Authorization;

public class ModeratorModule
extends AbstractModule {
    private static final Criteria CRIT = ElementCriteria.name((String)"iq").add((Criteria)ElementCriteria.name((String)"query", (String)"http://jabber.org/protocol/muc#admin"));

    private static Affiliation getAffiliation(Element item) {
        String tmp = item.getAttribute("affiliation");
        return tmp == null ? null : Affiliation.valueOf(tmp);
    }

    private static String getOccupantJidFromItem(Room room, Element item) {
        String nick = item.getAttribute("nick");
        String jid = item.getAttribute("jid");
        String resultJid = null;
        if (nick != null) {
            resultJid = room.getOccupantsJidByNickname(nick);
        } else if (jid != null) {
            String tmpNick = room.getOccupantsNicknameByBareJid(jid);
            resultJid = room.getOccupantsJidByNickname(nick);
        }
        return resultJid;
    }

    private static String getReason(Element item) {
        Element r = item.getChild("reason");
        return r == null ? null : r.getCData();
    }

    private static Role getRole(Element item) {
        String tmp = item.getAttribute("role");
        return tmp == null ? null : Role.valueOf(tmp);
    }

    public ModeratorModule(MucConfig config, IMucRepository mucRepository) {
        super(config, mucRepository);
    }

    private void checkItem(Room room, Element item, Affiliation senderaAffiliation, Role senderRole) throws MUCException {
        Role newRole = ModeratorModule.getRole(item);
        Affiliation newAffiliation = ModeratorModule.getAffiliation(item);
        String occupantJid = ModeratorModule.getOccupantJidFromItem(room, item);
        Affiliation occupantAffiliation = room.getAffiliation(occupantJid);
        Role occupantRole = room.getRoleByJid(occupantJid);
        if (newRole != null && newAffiliation == null) {
            if (newRole == Role.none && !senderRole.isKickParticipantsAndVisitors()) {
                throw new MUCException(Authorization.NOT_ALLOWED, "You cannot kick");
            }
            if (newRole == Role.none && occupantAffiliation.getWeight() >= senderaAffiliation.getWeight()) {
                throw new MUCException(Authorization.NOT_ALLOWED, "You cannot kick occupant with higher affiliation");
            }
            if (newRole == Role.participant && !senderRole.isGrantVoice()) {
                throw new MUCException(Authorization.NOT_ALLOWED, "You cannot grant voice");
            }
            if (newRole == Role.visitor && !senderRole.isRevokeVoice()) {
                throw new MUCException(Authorization.NOT_ALLOWED, "You cannot revoke voice");
            }
            if (newRole == Role.visitor && occupantAffiliation.getWeight() >= senderaAffiliation.getWeight()) {
                throw new MUCException(Authorization.NOT_ALLOWED, "You revoke voice occupant with higher affiliation");
            }
            if (newRole == Role.moderator && !senderaAffiliation.isEditModeratorList()) {
                throw new MUCException(Authorization.NOT_ALLOWED, "You cannot grant moderator provileges");
            }
        } else if (newRole == null && newAffiliation != null) {
            if (item.getAttribute("jid") == null) {
                throw new MUCException(Authorization.BAD_REQUEST);
            }
            if (newAffiliation == Affiliation.outcast && !senderaAffiliation.isBanMembersAndUnaffiliatedUsers()) {
                throw new MUCException(Authorization.NOT_ALLOWED, "You cannot ban");
            }
            if (newAffiliation == Affiliation.outcast && occupantAffiliation.getWeight() >= senderaAffiliation.getWeight()) {
                throw new MUCException(Authorization.NOT_ALLOWED, "You ban occupant with higher affiliation");
            }
            if (newAffiliation == Affiliation.member && !senderaAffiliation.isEditMemberList()) {
                throw new MUCException(Authorization.NOT_ALLOWED, "You cannot grant membership");
            }
            if (newAffiliation == Affiliation.admin && !senderaAffiliation.isEditAdminList()) {
                throw new MUCException(Authorization.NOT_ALLOWED, "You cannot grant admin provileges");
            }
            if (newAffiliation == Affiliation.owner && !senderaAffiliation.isEditOwnerList()) {
                throw new MUCException(Authorization.NOT_ALLOWED, "You cannot grant owner provileges");
            }
            if (newAffiliation == Affiliation.none && occupantAffiliation.getWeight() >= senderaAffiliation.getWeight()) {
                throw new MUCException(Authorization.NOT_ALLOWED, "You remove affiliation occupant with higher affiliation");
            }
        } else {
            throw new MUCException(Authorization.BAD_REQUEST);
        }
    }

    @Override
    public String[] getFeatures() {
        return null;
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    private Element makePresence(String destinationJid, String roomURL, Room room, String occupantJid, boolean unavailable, Affiliation affiliation, Role role, String nick, String reason, String actor, String ... codes) {
        Element presence = unavailable ? new Element("presence", new String[]{"type"}, new String[]{"unavailable"}) : room.getLastPresenceCopyByJid(occupantJid);
        presence.setAttribute("from", roomURL + "/" + nick);
        presence.setAttribute("to", destinationJid);
        Element x = new Element("x", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc#user"});
        presence.addChild(x);
        Element item = new Element("item");
        x.addChild(item);
        if (role != null) {
            item.setAttribute("role", role.name());
        }
        if (affiliation != null) {
            item.setAttribute("affiliation", affiliation.name());
        }
        if (nick != null) {
            item.setAttribute("nick", nick);
        }
        if (actor != null) {
            x.addChild(new Element("actor", new String[]{"jid"}, new String[]{actor}));
        }
        if (reason != null) {
            x.addChild(new Element("reason", reason));
        }
        if (codes != null) {
            for (String code : codes) {
                if (code == null) continue;
                x.addChild(new Element("status", new String[]{"code"}, new String[]{code}));
            }
        }
        return presence;
    }

    @Override
    public List<Element> process(Element element) throws MUCException {
        try {
            String type = element.getAttribute("type");
            if (ModeratorModule.getNicknameFromJid(element.getAttribute("to")) != null) {
                throw new MUCException(Authorization.BAD_REQUEST);
            }
            if ("set".equals(type)) {
                return this.processSet(element);
            }
            if ("get".equals(type)) {
                return this.processGet(element);
            }
            throw new MUCException(Authorization.BAD_REQUEST);
        }
        catch (MUCException e1) {
            throw e1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private List<Element> processGet(Element element) throws RepositoryException, MUCException {
        String roomId = ModeratorModule.getRoomId(element.getAttribute("to"));
        Room room = this.repository.getRoom(roomId);
        if (room == null) {
            throw new MUCException(Authorization.ITEM_NOT_FOUND);
        }
        Element query = element.getChild("query");
        Element item = query.getChild("item");
        String senderJid = element.getAttribute("from");
        Role senderRole = room.getRoleByJid(senderJid);
        Affiliation senderAffiliation = room.getAffiliation(senderJid);
        if (senderAffiliation != Affiliation.admin && senderAffiliation != Affiliation.owner) {
            throw new MUCException(Authorization.FORBIDDEN);
        }
        Role filterRole = ModeratorModule.getRole(item);
        Affiliation filterAffiliation = ModeratorModule.getAffiliation(item);
        Element response = ModeratorModule.createResultIQ(element);
        Element responseQuery = new Element("query", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc#admin"});
        response.addChild(responseQuery);
        if (filterAffiliation != null && filterRole == null) {
            for (String jid : room.getAffiliations()) {
                Affiliation affiliation = room.getAffiliation(jid);
                if (affiliation != filterAffiliation) continue;
                String nickName = room.getOccupantsNicknameByBareJid(jid);
                String fullJid = room.getOccupantsJidByNickname(nickName);
                Role role = room.getRoleByJid(fullJid);
                Element ir = new Element("item", new String[]{"affiliation", "jid"}, new String[]{affiliation.name(), jid});
                if (nickName != null) {
                    ir.setAttribute("nick", nickName);
                    ir.setAttribute("role", role.name());
                }
                responseQuery.addChild(ir);
            }
        } else if (filterAffiliation == null && filterRole != null) {
            for (String jid : room.getOccupantsJids()) {
                Role role = room.getRoleByJid(jid);
                if (role != filterRole) continue;
                Affiliation affiliation = room.getAffiliation(jid);
                String nick = room.getOccupantsNickname(jid);
                Element ir = new Element("item", new String[]{"affiliation", "nick", "role"}, new String[]{affiliation.name(), nick, role.name()});
                if (room.getConfig().getRoomAnonymity() != RoomConfig.Anonymity.fullanonymous) {
                    ir.setAttribute("jid", jid);
                }
                responseQuery.addChild(ir);
            }
        } else {
            throw new MUCException(Authorization.BAD_REQUEST);
        }
        return ModeratorModule.makeArray(response);
    }

    private List<Element> processSet(Element element) throws RepositoryException, MUCException {
        String roomId = ModeratorModule.getRoomId(element.getAttribute("to"));
        Room room = this.repository.getRoom(roomId);
        if (room == null) {
            throw new MUCException(Authorization.ITEM_NOT_FOUND);
        }
        String senderJid = element.getAttribute("from");
        Affiliation senderAffiliation = room.getAffiliation(senderJid);
        Role senderRole = room.getRoleByJid(senderJid);
        Element query = element.getChild("query");
        List items = query.getChildren();
        for (Element item : items) {
            this.checkItem(room, item, senderAffiliation, senderRole);
        }
        List<Element> result = ModeratorModule.makeArray(ModeratorModule.createResultIQ(element));
        for (Element item : items) {
            Role newRole = ModeratorModule.getRole(item);
            Affiliation newAffiliation = ModeratorModule.getAffiliation(item);
            String reason = ModeratorModule.getReason(item);
            String actor = JIDUtils.getNodeID((String)senderJid);
            if (newAffiliation != null) {
                String[] realOccupantJids;
                String occupantBareJid = item.getAttribute("jid");
                Affiliation previuosAffiliation = room.getAffiliation(occupantBareJid);
                room.addAffiliationByJid(occupantBareJid, newAffiliation);
                for (String realJid : realOccupantJids = room.getRealJidsByBareJid(occupantBareJid)) {
                    String occupantNick = room.getOccupantsNickname(realJid);
                    Role currentRole = room.getRoleByJid(realJid);
                    ArrayList<String> codes = new ArrayList<String>();
                    boolean isUnavailable = false;
                    if (newAffiliation == Affiliation.outcast) {
                        codes.add("301");
                        isUnavailable = true;
                        Element occupantKickPresence = this.makePresence(realJid, roomId, room, realJid, isUnavailable, newAffiliation, newRole, occupantNick, reason, actor, codes.toArray(new String[0]));
                        room.removeOccupantByJid(realJid);
                        result.add(occupantKickPresence);
                    }
                    if (newAffiliation.isViewOccupantsJid() != previuosAffiliation.isViewOccupantsJid()) {
                        // empty if block
                    }
                    for (String jid : room.getOccupantsJids()) {
                        Element occupantPresence = this.makePresence(jid, roomId, room, realJid, isUnavailable, newAffiliation, currentRole, occupantNick, reason, null, codes.toArray(new String[0]));
                        result.add(occupantPresence);
                    }
                }
            }
            if (newRole == null) continue;
            String occupantJid = ModeratorModule.getOccupantJidFromItem(room, item);
            String occupantNick = room.getOccupantsNickname(occupantJid);
            Affiliation occupantAffiliation = room.getAffiliation(occupantJid);
            boolean isUnavailable = false;
            ArrayList<String> codes = new ArrayList<String>();
            if (newRole == Role.none) {
                codes.add("307");
                isUnavailable = true;
                Element occupantKickPresence = this.makePresence(occupantJid, roomId, room, occupantJid, isUnavailable, occupantAffiliation, newRole, occupantNick, reason, actor, codes.toArray(new String[0]));
                room.removeOccupantByJid(occupantJid);
                result.add(occupantKickPresence);
            } else {
                room.setNewRole(occupantJid, newRole);
            }
            for (String jid : room.getOccupantsJids()) {
                Element occupantPresence = this.makePresence(jid, roomId, room, occupantJid, isUnavailable, occupantAffiliation, newRole, occupantNick, reason, null, codes.toArray(new String[0]));
                result.add(occupantPresence);
            }
        }
        return result;
    }
}

