/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.util.List;
import java.util.Set;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.muc.MucConfig;
import tigase.muc.Room;
import tigase.muc.exceptions.MUCException;
import tigase.muc.modules.AbstractModule;
import tigase.muc.repository.IMucRepository;
import tigase.xml.Element;
import tigase.xmpp.Authorization;

public class DiscoInfoModule
extends AbstractModule {
    private static final Criteria CRIT = ElementCriteria.nameType((String)"iq", (String)"get").add((Criteria)ElementCriteria.name((String)"query", (String)"http://jabber.org/protocol/disco#info"));
    private final Set<String> features;

    private static void addFeature(Element query, String feature) {
        query.addChild(new Element("feature", new String[]{"var"}, new String[]{feature}));
    }

    public DiscoInfoModule(MucConfig config, IMucRepository mucRepository, Set<String> features) {
        super(config, mucRepository);
        this.features = features;
    }

    @Override
    public String[] getFeatures() {
        return null;
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    @Override
    public List<Element> process(Element element) throws MUCException {
        try {
            String roomID = DiscoInfoModule.getRoomId(element.getAttribute("to"));
            Element result = DiscoInfoModule.createResultIQ(element);
            Element resultQuery = new Element("query", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/disco#info"});
            result.addChild(resultQuery);
            if (roomID == null) {
                Element resultIdentity = new Element("identity", new String[]{"category", "name", "type"}, new String[]{"conference", "Multi User Chat", "text"});
                resultQuery.addChild(resultIdentity);
                resultQuery.addChild(new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/muc"}));
                if (this.features != null) {
                    for (String featur : this.features) {
                        resultQuery.addChild(new Element("feature", new String[]{"var"}, new String[]{featur}));
                    }
                }
            } else {
                Room room = this.repository.getRoom(roomID);
                if (room == null) {
                    throw new MUCException(Authorization.ITEM_NOT_FOUND);
                }
                Element resultIdentity = new Element("identity", new String[]{"category", "name", "type"}, new String[]{"conference", room.getConfig().getRoomName(), "text"});
                resultQuery.addChild(resultIdentity);
                DiscoInfoModule.addFeature(resultQuery, "http://jabber.org/protocol/muc");
                switch (room.getConfig().getRoomAnonymity()) {
                    case fullanonymous: {
                        DiscoInfoModule.addFeature(resultQuery, "muc_fullyanonymous");
                        break;
                    }
                    case semianonymous: {
                        DiscoInfoModule.addFeature(resultQuery, "muc_semianonymous");
                        break;
                    }
                    case nonanonymous: {
                        DiscoInfoModule.addFeature(resultQuery, "muc_nonanonymous");
                    }
                }
                if (room.getConfig().isRoomModerated()) {
                    DiscoInfoModule.addFeature(resultQuery, "muc_moderated");
                } else {
                    DiscoInfoModule.addFeature(resultQuery, "muc_unmoderated");
                }
                if (room.getConfig().isRoomMembersOnly()) {
                    DiscoInfoModule.addFeature(resultQuery, "muc_membersonly");
                } else {
                    DiscoInfoModule.addFeature(resultQuery, "muc_open");
                }
                if (room.getConfig().isPersistentRoom()) {
                    DiscoInfoModule.addFeature(resultQuery, "muc_persistent");
                } else {
                    DiscoInfoModule.addFeature(resultQuery, "muc_temporary");
                }
                if (!room.getConfig().isRoomconfigPublicroom()) {
                    DiscoInfoModule.addFeature(resultQuery, "muc_hidden");
                } else {
                    DiscoInfoModule.addFeature(resultQuery, "muc_public");
                }
                if (room.getConfig().isPasswordProtectedRoom()) {
                    DiscoInfoModule.addFeature(resultQuery, "muc_passwordprotected");
                } else {
                    DiscoInfoModule.addFeature(resultQuery, "muc_unsecured");
                }
            }
            return DiscoInfoModule.makeArray(result);
        }
        catch (MUCException e1) {
            throw e1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

