/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.util.List;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.muc.Module;
import tigase.muc.MucVersion;
import tigase.muc.exceptions.MUCException;
import tigase.muc.modules.AbstractModule;
import tigase.util.JIDUtils;
import tigase.xml.Element;

public class SoftwareVersionModule
implements Module {
    private static final Criteria CRIT = ElementCriteria.nameType((String)"iq", (String)"get").add((Criteria)ElementCriteria.name((String)"query", (String)"jabber:iq:version"));

    @Override
    public String[] getFeatures() {
        return new String[]{"jabber:iq:version"};
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    @Override
    public boolean isProcessedByModule(Element element) {
        String jid = element.getAttribute("to");
        return jid != null && JIDUtils.getNodeResource((String)jid) == null;
    }

    @Override
    public List<Element> process(Element iq) throws MUCException {
        Element response = AbstractModule.createResultIQ(iq);
        Element query = new Element("query", new String[]{"xmlns"}, new String[]{"jabber:iq:version"});
        query.addChild(new Element("name", "Tigase Multi-User Chat Component"));
        query.addChild(new Element("version", MucVersion.getVersion()));
        query.addChild(new Element("os", System.getProperty("os.name") + "-" + System.getProperty("os.arch") + "-" + System.getProperty("os.version") + ", " + System.getProperty("java.vm.name") + "-" + System.getProperty("java.version") + " " + System.getProperty("java.vm.vendor")));
        response.addChild(query);
        return AbstractModule.makeArray(response);
    }
}

