/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.util.List;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.muc.MucConfig;
import tigase.muc.Role;
import tigase.muc.Room;
import tigase.muc.exceptions.MUCException;
import tigase.muc.modules.AbstractModule;
import tigase.muc.repository.IMucRepository;
import tigase.xml.Element;
import tigase.xmpp.Authorization;

public class IqStanzaForwarderModule
extends AbstractModule {
    private static final Criteria CRIT = ElementCriteria.name((String)"iq");

    public IqStanzaForwarderModule(MucConfig config, IMucRepository mucRepository) {
        super(config, mucRepository);
    }

    @Override
    public String[] getFeatures() {
        return null;
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    @Override
    public boolean isProcessedByModule(Element element) {
        return IqStanzaForwarderModule.getNicknameFromJid(element.getAttribute("to")) != null;
    }

    @Override
    public List<Element> process(Element element) throws MUCException {
        try {
            String senderJid = element.getAttribute("from");
            String roomId = IqStanzaForwarderModule.getRoomId(element.getAttribute("to"));
            String recipientNickname = IqStanzaForwarderModule.getNicknameFromJid(element.getAttribute("to"));
            if (recipientNickname == null) {
                throw new MUCException(Authorization.BAD_REQUEST);
            }
            Room room = this.repository.getRoom(roomId);
            if (room == null) {
                throw new MUCException(Authorization.ITEM_NOT_FOUND);
            }
            Role senderRole = room.getRoleByJid(senderJid);
            if (!senderRole.isSendPrivateMessages()) {
                throw new MUCException(Authorization.NOT_ALLOWED);
            }
            String recipientJid = room.getOccupantsJidByNickname(recipientNickname);
            if (recipientJid == null) {
                throw new MUCException(Authorization.ITEM_NOT_FOUND, "Unknown recipient");
            }
            String senderNickname = room.getOccupantsNickname(senderJid);
            Element iq = element.clone();
            iq.setAttribute("from", roomId + "/" + senderNickname);
            iq.setAttribute("to", recipientJid);
            return IqStanzaForwarderModule.makeArray(iq);
        }
        catch (MUCException e1) {
            throw e1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

