/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.xmpp;

import java.io.Serializable;

public class JID
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String host;
    private String resource;
    private String username;

    public static JID fromString(String jid) {
        if (jid == null) {
            return null;
        }
        String usr = null;
        String hst = null;
        String rsr = null;
        int pos = jid.indexOf(64);
        if (pos != -1) {
            usr = jid.substring(0, pos);
            jid = jid.substring(pos + 1);
        } else if (pos == 0) {
            throw new RuntimeException("Invalid JID: found @ but no username specified");
        }
        pos = jid.indexOf(47);
        if (pos == -1) {
            hst = jid;
        } else {
            hst = jid.substring(0, pos);
            rsr = jid = jid.substring(pos + 1);
        }
        return new JID(usr, hst, rsr);
    }

    private JID() {
    }

    public JID(String username, String host) {
        this(username, host, null);
    }

    public JID(String username, String host, String resource) {
        this.username = username;
        this.host = host;
        this.resource = resource;
        if ("".equals(this.username)) {
            this.username = null;
        }
        if ("".equals(this.host)) {
            this.host = null;
        }
        if ("".equals(this.resource)) {
            this.resource = null;
        }
        if (this.host == null) {
            throw new RuntimeException("Illegal host value.");
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof JID)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (this.toString() == null || other.toString() == null) {
            return false;
        }
        return this.toString().equals(other.toString());
    }

    public JID getBareJID() {
        JID result = new JID();
        result.host = this.host;
        result.username = this.username;
        return result;
    }

    public String getHost() {
        return this.host;
    }

    public String getResource() {
        return this.resource;
    }

    public String getUsername() {
        return this.username;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        if (this.username != null) {
            out.append(this.username);
            out.append("@");
        }
        out.append(this.host);
        if (this.resource != null) {
            out.append("/");
            out.append(this.resource);
        }
        return out.toString();
    }
}

