/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules.admin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.muc.Affiliation;
import tigase.muc.MucInternalException;
import tigase.muc.Role;
import tigase.muc.RoomContext;
import tigase.muc.modules.AbstractModule;
import tigase.muc.modules.PresenceModule;
import tigase.muc.xmpp.JID;
import tigase.muc.xmpp.stanzas.IQ;
import tigase.muc.xmpp.stanzas.Presence;
import tigase.xml.Element;

public class AdminSetModule
extends AbstractModule {
    private static final Criteria CRIT = new ElementCriteria("iq", new String[]{"type"}, new String[]{"set"}).add(ElementCriteria.name("query", "http://jabber.org/protocol/muc#admin"));

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    @Override
    protected List<Element> intProcess(RoomContext roomContext, Element element) throws MucInternalException {
        IQ iq = new IQ(element);
        LinkedList<Element> result = new LinkedList<Element>();
        Affiliation senderAffiliation = roomContext.getAffiliation(iq.getFrom());
        Role senderRole = roomContext.getRole(iq.getFrom());
        Element query = iq.getChild("query", "http://jabber.org/protocol/muc#admin");
        List items = query.getChildren("/query");
        HashMap<JID, Affiliation> affiliationsToSet = new HashMap<JID, Affiliation>();
        HashMap<String, Role> rolesToSet = new HashMap<String, Role>();
        HashSet<JID> jidsToRemove = new HashSet<JID>();
        for (Element element2 : items) {
            Affiliation newAffiliation;
            Role newRole;
            HashSet<JID> occupantJids = new HashSet<JID>();
            String occupantNick = element2.getAttribute("nick");
            if (occupantNick != null) {
                occupantJids.add(roomContext.getOccupantsByNick().get(occupantNick));
            }
            try {
                newRole = Role.valueOf(element2.getAttribute("role").toUpperCase());
            }
            catch (Exception e) {
                newRole = null;
            }
            JID occupantBareJid = JID.fromString(element2.getAttribute("jid"));
            if (occupantBareJid != null) {
                occupantJids.addAll(roomContext.getOccupantJidsByBare(occupantBareJid));
            } else {
                occupantBareJid = roomContext.getOccupantsByNick().get(occupantNick).getBareJID();
            }
            try {
                newAffiliation = Affiliation.valueOf(element2.getAttribute("affiliation").toUpperCase());
            }
            catch (Exception e) {
                newAffiliation = null;
            }
            Affiliation currentAffiliation = roomContext.getAffiliation(occupantBareJid);
            if (senderAffiliation.getWeight() < currentAffiliation.getWeight()) {
                throw new MucInternalException(element2, "forbidden", "403", "auth");
            }
            if (newAffiliation != null && occupantBareJid != null) {
                affiliationsToSet.put(occupantBareJid, newAffiliation);
            }
            if (newRole != null && occupantNick != null) {
                if (newRole == Role.MODERATOR && senderAffiliation != Affiliation.ADMIN && senderAffiliation != Affiliation.OWNER) {
                    throw new MucInternalException(element2, "not-allowed", "405", "cancel");
                }
                if (senderRole != Role.MODERATOR) {
                    throw new MucInternalException(element2, "not-allowed", "405", "cancel");
                }
                rolesToSet.put(occupantNick, newRole);
            }
            List reasons = element2.getChildren("/item");
            for (JID occupantJid : occupantJids) {
                occupantNick = roomContext.getOccupantsByJID().get(occupantJid);
                for (Map.Entry<String, JID> entry : roomContext.getOccupantsByNick().entrySet()) {
                    Presence presence = roomContext.getLastReceivedPresence().get(occupantJid);
                    if (presence == null) continue;
                    presence = PresenceModule.clonePresence(presence);
                    presence.setAttribute("from", roomContext.getId() + "/" + occupantNick);
                    presence.setAttribute("to", entry.getValue().toString());
                    Element x = new Element("x");
                    presence.addChild(x);
                    x.setAttribute("xmlns", "http://jabber.org/protocol/muc#user");
                    if (newRole == Role.NONE) {
                        x.addChild(new Element("status", new String[]{"code"}, new String[]{"307"}));
                        presence.setAttribute("type", "unavailable");
                        jidsToRemove.add(occupantJid);
                    }
                    if (newAffiliation == Affiliation.OUTCAST) {
                        x.addChild(new Element("status", new String[]{"code"}, new String[]{"301"}));
                        presence.setAttribute("type", "unavailable");
                        jidsToRemove.add(occupantJid);
                    }
                    if (occupantJid.equals(entry.getValue())) {
                        x.addChild(new Element("status", new String[]{"code"}, new String[]{"110"}));
                    }
                    Role roleToSend = newRole != null ? newRole : roomContext.getRole(occupantJid);
                    Affiliation affiliationToSend = newAffiliation != null ? newAffiliation : roomContext.getAffiliation(occupantJid);
                    Element subItem = PresenceModule.preparePresenceSubItem(roomContext, occupantJid, affiliationToSend, roleToSend, entry.getValue());
                    x.addChild(subItem);
                    if (reasons != null && reasons.size() > 0) {
                        subItem.addChildren(reasons);
                    }
                    result.add(presence);
                }
            }
        }
        for (Map.Entry entry : affiliationsToSet.entrySet()) {
            roomContext.setAffiliation((JID)entry.getKey(), (Affiliation)((Object)entry.getValue()));
        }
        for (Map.Entry entry : rolesToSet.entrySet()) {
            roomContext.setRole((String)entry.getKey(), (Role)((Object)entry.getValue()));
        }
        for (JID jID : jidsToRemove) {
            roomContext.removeOccupantByJID(jID);
        }
        Element answer = new Element("iq");
        answer.addAttribute("id", iq.getAttribute("id"));
        answer.addAttribute("type", "result");
        answer.addAttribute("to", iq.getAttribute("from"));
        answer.addAttribute("from", roomContext.getId());
        result.add(answer);
        return result;
    }
}

