/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules.admin;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.muc.Affiliation;
import tigase.muc.MucInternalException;
import tigase.muc.Role;
import tigase.muc.RoomContext;
import tigase.muc.modules.AbstractModule;
import tigase.muc.modules.PresenceModule;
import tigase.muc.xmpp.JID;
import tigase.muc.xmpp.stanzas.IQ;
import tigase.muc.xmpp.stanzas.IQType;
import tigase.xml.Element;

public class AdminGetModule
extends AbstractModule {
    private static final Criteria CRIT = new ElementCriteria("iq", new String[]{"type"}, new String[]{"get"}).add(ElementCriteria.name("query", "http://jabber.org/protocol/muc#admin"));
    private static final String XMLNS_MUC_ADMIN = "http://jabber.org/protocol/muc#admin";

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    @Override
    protected List<Element> intProcess(RoomContext roomContext, Element element) throws MucInternalException {
        IQ iq = new IQ(element);
        LinkedList<Element> result = new LinkedList<Element>();
        Element query = iq.getChild("query", XMLNS_MUC_ADMIN);
        List items = query.getChildren("/query");
        IQ answer = new IQ(IQType.RESULT);
        answer.setId(iq.getId());
        answer.setTo(iq.getFrom());
        answer.setFrom(JID.fromString(roomContext.getId()));
        Element answerQuery = new Element("query");
        answer.addChild(answerQuery);
        answerQuery.setAttribute("query", XMLNS_MUC_ADMIN);
        HashSet<? extends JID> occupantsJid = new HashSet<JID>();
        for (Element element2 : items) {
            try {
                Affiliation reqAffiliation = Affiliation.valueOf(element2.getAttribute("affiliation").toUpperCase());
                occupantsJid.addAll(roomContext.findBareJidsByAffiliations(reqAffiliation));
                if (reqAffiliation == Affiliation.NONE) {
                    occupantsJid.addAll(roomContext.findBareJidsWithoutAffiliations());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                Role reqRole = Role.valueOf(element2.getAttribute("role").toUpperCase());
                occupantsJid.addAll(roomContext.findJidsByRole(reqRole));
            }
            catch (Exception e) {}
        }
        for (JID jID : occupantsJid) {
            Element answerItem = PresenceModule.preparePresenceSubItem(roomContext, jID, iq.getFrom());
            answerQuery.addChild(answerItem);
        }
        result.add(answer);
        return result;
    }
}

