/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.util.LinkedList;
import java.util.List;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.criteria.Or;
import tigase.muc.Affiliation;
import tigase.muc.MucInternalException;
import tigase.muc.RoomContext;
import tigase.muc.modules.AbstractModule;
import tigase.muc.xmpp.JID;
import tigase.muc.xmpp.stanzas.Message;
import tigase.xml.Element;

public class InvitationModule
extends AbstractModule {
    private static final Criteria CRIT_DECLINE = ElementCriteria.name("message").add(ElementCriteria.name("x", "http://jabber.org/protocol/muc#user")).add(ElementCriteria.name("decline"));
    private static final Criteria CRIT_INVITE = ElementCriteria.name("message").add(ElementCriteria.name("x", "http://jabber.org/protocol/muc#user")).add(ElementCriteria.name("invite"));

    @Override
    public Criteria getModuleCriteria() {
        return new Or(CRIT_INVITE, CRIT_DECLINE);
    }

    @Override
    protected List<Element> intProcess(RoomContext roomContext, Element e) throws MucInternalException {
        Message element = new Message(e);
        LinkedList<Element> result = new LinkedList<Element>();
        String senderNick = roomContext.getOccupantsByJID().get(element.getFrom());
        String recipentNick = element.getTo().getResource();
        if (recipentNick != null) {
            throw new MucInternalException(element, "jid-malformed", "400", "modify");
        }
        Element x = element.getChild("x", "http://jabber.org/protocol/muc#user");
        Element decline = x.getChild("decline");
        Element invite = x.getChild("invite");
        if (decline != null) {
            Element reason = decline.getChild("reason");
            Message msg = new Message(JID.fromString(decline.getAttribute("to")), null);
            msg.setFrom(JID.fromString(roomContext.getId()));
            Element msgX = new Element("x", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc#user"});
            msg.addChild(msgX);
            Element dec = new Element("decline");
            msgX.addChild(dec);
            dec.setAttribute("from", element.getFrom().toString());
            if (reason != null) {
                dec.addChild(reason.clone());
            }
            result.add(msg);
            return result;
        }
        if (senderNick == null) {
            throw new MucInternalException(element, "not-acceptable", "406", "modify");
        }
        if (invite != null && !roomContext.isRoomconfigAllowInvites() && roomContext.getAffiliation(element.getFrom()).getWeight() < Affiliation.ADMIN.getWeight()) {
            throw new MucInternalException(element, "forbidden", "403", "auth");
        }
        if (invite != null) {
            Message invitingMessage = new Message(JID.fromString(invite.getAttribute("to")), "You have been invited to " + roomContext.getId() + " by " + element.getFrom().toString() + ".");
            invitingMessage.setFrom(JID.fromString(roomContext.getId()));
            Element ix = new Element("x", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc#user"});
            invitingMessage.addChild(ix);
            Element ii = new Element("invite", new String[]{"from"}, new String[]{element.getFrom().toString()});
            ix.addChild(ii);
            if (invite.getChild("reason") != null) {
                ii.addChild(invite.getChild("reason"));
            }
            if (roomContext.isRoomconfigPasswordProtectedRoom()) {
                ix.addChild(new Element("password", roomContext.getRoomconfigRoomSecret()));
            }
            result.add(invitingMessage);
        }
        return result;
    }
}

