/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.TigaseDBException;
import tigase.db.UserExistsException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.disco.ServiceEntity;
import tigase.disco.ServiceIdentity;
import tigase.muc.Affiliation;
import tigase.muc.RoomConfiguration;
import tigase.muc.RoomContext;
import tigase.muc.xmpp.JID;

public class RoomsContainer {
    private Set<String> allRooms = new HashSet<String>();
    private Logger log = Logger.getLogger(this.getClass().getName());
    private UserRepository mucRepository;
    private String myDomain;
    private final Map<String, RoomContext> rooms = new HashMap<String, RoomContext>();
    private ServiceEntity serviceEntity;

    RoomsContainer(String myDomain, UserRepository mucRepository, ServiceEntity serviceEntity) {
        this.mucRepository = mucRepository;
        this.serviceEntity = serviceEntity;
        this.myDomain = myDomain;
    }

    public void addRoom(RoomContext context) {
        this.rooms.put(context.getId(), context);
        this.allRooms.add(context.getId());
    }

    public void configRoomDiscovery(RoomConfiguration config) {
        ServiceEntity x = new ServiceEntity(config.getId(), config.getId(), config.getRoomconfigRoomname());
        x.addIdentities(new ServiceIdentity[]{new ServiceIdentity("conference", "text", config.getRoomconfigRoomname())});
        x.addFeatures(new String[]{"http://jabber.org/protocol/muc"});
        if (config.isRoomconfigPasswordProtectedRoom()) {
            x.addFeatures(new String[]{"muc_passwordprotected"});
        } else {
            x.addFeatures(new String[]{"muc_unsecured"});
        }
        if (config.isRoomconfigPersistentRoom()) {
            x.addFeatures(new String[]{"muc_persistent"});
        } else {
            x.addFeatures(new String[]{"muc_temporary"});
        }
        if (config.isRoomconfigMembersOnly()) {
            x.addFeatures(new String[]{"muc_membersonly"});
        } else {
            x.addFeatures(new String[]{"muc_open"});
        }
        if (config.isRoomconfigModeratedRoom()) {
            x.addFeatures(new String[]{"muc_moderated"});
        } else {
            x.addFeatures(new String[]{"muc_unmoderated"});
        }
        if (config.affiliationCanViewJid(Affiliation.NONE)) {
            x.addFeatures(new String[]{"muc_nonanonymous"});
        } else {
            x.addFeatures(new String[]{"muc_semianonymous"});
        }
        if (this.serviceEntity != null) {
            this.serviceEntity.addItems(new ServiceEntity[]{x});
        }
    }

    public void configRoomDiscovery(String jid) {
        try {
            RoomConfiguration config = new RoomConfiguration(this.myDomain, jid, this.mucRepository);
            this.configRoomDiscovery(config);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Error on read room " + jid + " configuration", e);
        }
    }

    public void destroyRoom(JID room) {
        this.allRooms.remove(room.toString());
        this.rooms.remove(room.toString());
    }

    public RoomContext getRoomContext(String roomID) {
        return this.rooms.get(roomID);
    }

    public boolean isRoomExists(JID jid) {
        return this.allRooms.contains(jid.toString());
    }

    public void readAllRomms() {
        this.log.config("Reading rooms...");
        try {
            String[] roomsJid = this.mucRepository.getSubnodes(this.myDomain);
            this.allRooms.clear();
            if (roomsJid != null) {
                for (String jid : roomsJid) {
                    this.allRooms.add(jid);
                    this.configRoomDiscovery(jid);
                }
            }
        }
        catch (UserNotFoundException e) {
            try {
                this.mucRepository.addUser(this.myDomain);
            }
            catch (UserExistsException e1) {
                e1.printStackTrace();
            }
            catch (TigaseDBException e1) {
                e1.printStackTrace();
            }
        }
        catch (TigaseDBException e) {
            e.printStackTrace();
        }
        this.log.config(this.allRooms.size() + " known rooms.");
    }

    public void removeRoom(JID room) {
        this.rooms.remove(room.toString());
    }
}

