/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import tigase.db.UserRepository;
import tigase.muc.Affiliation;
import tigase.muc.History;
import tigase.muc.Role;
import tigase.muc.RoomConfiguration;
import tigase.muc.xmpp.JID;
import tigase.muc.xmpp.stanzas.Message;
import tigase.muc.xmpp.stanzas.Presence;

public class RoomContext
extends RoomConfiguration {
    private static final long serialVersionUID = 1L;
    private History conversationHistory = new History(10);
    private Message currentSubject;
    private Map<JID, Presence> lastReceivedPresence = new HashMap<JID, Presence>();
    private boolean lockedRoom;
    private Logger log = Logger.getLogger(this.getClass().getName());
    private Map<JID, String> occupantsByJID = new HashMap<JID, String>();
    private Map<String, JID> occupantsByNick = new HashMap<String, JID>();
    private Map<JID, Role> occupantsRole = new HashMap<JID, Role>();
    private boolean roomCreated = false;
    private String roomID;

    public RoomContext(String namespace, String id, UserRepository mucRepocitory, JID constructorJid, boolean roomCreated) {
        super(namespace, id, mucRepocitory, constructorJid);
        this.roomCreated = roomCreated;
        this.lockedRoom = roomCreated;
    }

    public Role calculateInitialRole(JID realJID) {
        Role result;
        Affiliation affiliation = this.getAffiliation(realJID);
        Role role = result = this.isRoomconfigModeratedRoom() ? Role.VISITOR : Role.PARTICIPANT;
        if (affiliation == Affiliation.ADMIN || affiliation == Affiliation.OWNER) {
            return Role.MODERATOR;
        }
        if (affiliation == Affiliation.MEMBER) {
            return Role.PARTICIPANT;
        }
        return result;
    }

    public List<? extends JID> findBareJidsWithoutAffiliations() {
        ArrayList<JID> result = new ArrayList<JID>();
        for (Map.Entry<JID, String> entry : this.occupantsByJID.entrySet()) {
            if (this.getAffiliation(entry.getKey()) != Affiliation.NONE) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    public List<JID> findJidsByRole(Role reqRole) {
        ArrayList<JID> result = new ArrayList<JID>();
        for (Map.Entry<JID, Role> entry : this.occupantsRole.entrySet()) {
            if (reqRole != entry.getValue()) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    public History getConversationHistory() {
        return this.conversationHistory;
    }

    public Message getCurrentSubject() {
        return this.currentSubject;
    }

    public Map<JID, Presence> getLastReceivedPresence() {
        return this.lastReceivedPresence;
    }

    public List<JID> getOccupantJidsByBare(JID jid) {
        ArrayList<JID> result = new ArrayList<JID>();
        JID sf = jid.getBareJID();
        for (Map.Entry<JID, String> entry : this.occupantsByJID.entrySet()) {
            JID k = entry.getKey().getBareJID();
            if (!k.equals(sf)) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    public Map<JID, String> getOccupantsByJID() {
        return this.occupantsByJID;
    }

    public Map<String, JID> getOccupantsByNick() {
        return this.occupantsByNick;
    }

    public Map<JID, Role> getOccupantsRole() {
        return this.occupantsRole;
    }

    public Role getRole(JID jid) {
        Role result = this.occupantsRole.get(jid.getBareJID());
        return result == null ? Role.NONE : result;
    }

    public String getRoomID() {
        return this.roomID;
    }

    public boolean isLockedRoom() {
        return this.lockedRoom;
    }

    public boolean isRoomCreated() {
        return this.roomCreated;
    }

    public void removeOccupantByJID(JID jid) {
        String nick = this.occupantsByJID.remove(jid);
        this.occupantsByNick.remove(nick);
        this.lastReceivedPresence.remove(jid);
        this.setRole(jid, null);
    }

    public void setConversationHistory(History conversationHistory) {
        this.conversationHistory = conversationHistory;
    }

    public void setCurrentSubject(Message currentSubject) {
        this.currentSubject = currentSubject;
    }

    public void setLastReceivedPresence(Map<JID, Presence> lastReceivedPresence) {
        this.lastReceivedPresence = lastReceivedPresence;
    }

    public void setLockedRoom(boolean lockedRoom) {
        this.lockedRoom = lockedRoom;
    }

    public void setOccupantsByJID(Map<JID, String> occupantsByJID) {
        this.occupantsByJID = occupantsByJID;
    }

    public void setOccupantsByNick(Map<String, JID> occupantsByNick) {
        this.occupantsByNick = occupantsByNick;
    }

    public void setOccupantsRole(Map<JID, Role> occupantsRole) {
        this.occupantsRole = occupantsRole;
    }

    public void setRole(JID jid, Role role) {
        if (role == null) {
            this.occupantsRole.remove(jid.getBareJID());
        } else {
            this.occupantsRole.put(jid.getBareJID(), role);
        }
    }

    public void setRole(String nick, Role role) {
        JID jid = this.occupantsByNick.get(nick);
        if (role == null) {
            this.occupantsRole.remove(jid.getBareJID());
        } else {
            this.occupantsRole.put(jid.getBareJID(), role);
        }
    }

    public void setRoomCreated(boolean roomCreated) {
        this.roomCreated = roomCreated;
    }
}

