/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.TigaseDBException;
import tigase.db.UserExistsException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.form.Field;
import tigase.form.Form;
import tigase.muc.Affiliation;
import tigase.muc.xmpp.JID;
import tigase.util.JIDUtils;
import tigase.xml.Element;

public class RoomConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<JID, Affiliation> affiliations = new HashMap<JID, Affiliation>();
    private String id;
    private Logger log = Logger.getLogger(this.getClass().getName());
    private UserRepository mucRepocitory;
    private boolean roomconfigAllowInvites;
    private boolean roomconfigChangeSubject;
    private boolean roomconfigEnableLogging;
    private int roomconfigMaxUsers;
    private boolean roomconfigMembersOnly;
    private boolean roomconfigModeratedRoom = false;
    private boolean roomconfigPasswordProtectedRoom;
    private boolean roomconfigPersistentRoom;
    private boolean roomconfigPublicRoom;
    private String roomconfigRoomdesc;
    private String roomconfigRoomname;
    private String roomconfigRoomSecret;
    private String roomconfigWhois = "";
    private String namespace;

    RoomConfiguration(String namespace, String id, UserRepository mucRepocitory) {
        this.namespace = namespace;
        this.id = id;
        this.mucRepocitory = mucRepocitory;
        String roomName = JIDUtils.getNodeNick((String)id);
        this.defaultSettings(roomName);
        try {
            this.restoreConfiguration();
        }
        catch (Exception e) {
            this.log.info("Room [" + this.id + "] not found in database.");
            throw new RuntimeException("Room [" + this.id + "] not found in database. Config object not created.", e);
        }
    }

    private void defaultSettings(String roomName) {
        this.roomconfigRoomdesc = roomName;
        this.roomconfigRoomname = roomName;
        this.roomconfigChangeSubject = true;
        this.roomconfigAllowInvites = true;
        this.roomconfigPublicRoom = true;
        this.roomconfigMembersOnly = false;
        this.roomconfigEnableLogging = false;
        this.roomconfigMaxUsers = 100;
        this.roomconfigModeratedRoom = true;
        this.roomconfigRoomSecret = null;
        this.roomconfigPasswordProtectedRoom = false;
        this.roomconfigPersistentRoom = false;
        this.roomconfigWhois = "admin";
    }

    RoomConfiguration(String namespace, String id, UserRepository mucRepocitory, JID constructorJid) {
        this.namespace = namespace;
        this.id = id;
        this.mucRepocitory = mucRepocitory;
        String roomName = JIDUtils.getNodeNick((String)id);
        this.defaultSettings(roomName);
        this.affiliations.put(constructorJid.getBareJID(), Affiliation.OWNER);
        try {
            this.restoreConfiguration();
        }
        catch (UserNotFoundException e) {
            this.log.info("Room [" + this.id + "] not found in database. Using defaults.");
        }
        catch (TigaseDBException e) {
            e.printStackTrace();
        }
    }

    private void restoreConfiguration() throws UserNotFoundException, TigaseDBException {
        String[] keysTable = this.mucRepocitory.getKeys(this.namespace, this.id);
        if (keysTable == null) {
            return;
        }
        HashSet<String> keys = new HashSet<String>();
        for (String key : keysTable) {
            this.log.finest(" Found config key: " + key);
            if (keys.add(key)) continue;
            this.log.log(Level.SEVERE, "Duplicated config key for room " + this.id + ", key: " + key);
        }
        String var = "roomconfigRoomname";
        if (keys.contains(var)) {
            this.roomconfigRoomname = this.getString(var);
        }
        if (keys.contains(var = "roomconfigChangeSubject")) {
            this.roomconfigChangeSubject = this.getBoolean(var);
        }
        if (keys.contains(var = "roomconfigMaxUsers")) {
            this.roomconfigMaxUsers = this.getInteger(var);
        }
        if (keys.contains(var = "roomconfigPublicRoom")) {
            this.roomconfigPublicRoom = this.getBoolean(var);
        }
        if (keys.contains(var = "roomconfigPersistentRoom")) {
            this.roomconfigPersistentRoom = this.getBoolean(var);
        }
        if (keys.contains(var = "roomconfigModeratedRoom")) {
            this.roomconfigModeratedRoom = this.getBoolean(var);
        }
        if (keys.contains(var = "roomconfigMembersOnly")) {
            this.roomconfigMembersOnly = this.getBoolean(var);
        }
        if (keys.contains(var = "roomconfigAllowInvites")) {
            this.roomconfigAllowInvites = this.getBoolean(var);
        }
        if (keys.contains(var = "roomconfigPasswordProtectedRoom")) {
            this.roomconfigPasswordProtectedRoom = this.getBoolean(var);
        }
        if (keys.contains(var = "roomconfigRoomSecret")) {
            this.roomconfigRoomSecret = this.getString(var);
        }
        if (keys.contains(var = "roomconfigWhois")) {
            this.roomconfigWhois = this.getString(var);
        }
        if (keys.contains(var = "roomconfigEnableLogging")) {
            this.roomconfigEnableLogging = this.getBoolean(var);
        }
        HashMap<JID, Affiliation> tmp = new HashMap<JID, Affiliation>();
        String[] jids = this.mucRepocitory.getKeys(this.namespace, this.id + "/affiliation");
        if (jids != null) {
            String l = "";
            for (String jid : jids) {
                String affName = this.mucRepocitory.getData(this.namespace, this.id + "/affiliation", JIDUtils.getNodeID((String)jid));
                JID j = JID.fromString(jid);
                Affiliation a = Affiliation.valueOf(affName);
                tmp.put(j, a);
                l = l + j + "(" + (Object)((Object)a) + "); ";
            }
            this.log.finest("Reading room affiliations: " + l);
            this.affiliations.clear();
            this.affiliations.putAll(tmp);
        }
    }

    public boolean affiliationCanViewJid(Affiliation affiliation) {
        if ("owner".equals(this.roomconfigWhois)) {
            return affiliation.getWeight() >= Affiliation.OWNER.getWeight();
        }
        if ("admin".equals(this.roomconfigWhois)) {
            return affiliation.getWeight() >= Affiliation.ADMIN.getWeight();
        }
        if ("member".equals(this.roomconfigWhois)) {
            return affiliation.getWeight() >= Affiliation.MEMBER.getWeight();
        }
        return "anyone".equals(this.roomconfigWhois);
    }

    public boolean checkPassword(String password) {
        return password != null && this.roomconfigRoomSecret != null && password.equals(this.roomconfigRoomSecret);
    }

    public Collection<JID> findBareJidsByAffiliations(Affiliation reqAffiliation) {
        ArrayList<JID> result = new ArrayList<JID>();
        for (Map.Entry<JID, Affiliation> entry : this.affiliations.entrySet()) {
            if (reqAffiliation != entry.getValue()) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    public void flushConfig() {
        this.log.info("Storing room configuration...");
        try {
            if (this.roomconfigRoomname != null) {
                this.mucRepocitory.setData(this.namespace, this.id, "roomconfigRoomname", this.roomconfigRoomname);
            }
            if (this.roomconfigRoomdesc != null) {
                this.mucRepocitory.setData(this.namespace, this.id, "roomconfigRoomdesc", this.roomconfigRoomdesc);
            }
            if (this.roomconfigWhois != null) {
                this.mucRepocitory.setData(this.namespace, this.id, "roomconfigWhois", this.roomconfigWhois);
            }
            this.mucRepocitory.setData(this.namespace, this.id, "roomconfigChangeSubject", Boolean.toString(this.roomconfigChangeSubject));
            this.mucRepocitory.setData(this.namespace, this.id, "roomconfigAllowInvites", Boolean.toString(this.roomconfigAllowInvites));
            this.mucRepocitory.setData(this.namespace, this.id, "roomconfigPublicRoom", Boolean.toString(this.roomconfigPublicRoom));
            this.mucRepocitory.setData(this.namespace, this.id, "roomconfigMembersOnly", Boolean.toString(this.roomconfigMembersOnly));
            this.mucRepocitory.setData(this.namespace, this.id, "roomconfigEnableLogging", Boolean.toString(this.roomconfigEnableLogging));
            this.mucRepocitory.setData(this.namespace, this.id, "roomconfigModeratedRoom", Boolean.toString(this.roomconfigModeratedRoom));
            this.mucRepocitory.setData(this.namespace, this.id, "roomconfigPersistentRoom", Boolean.toString(this.roomconfigPersistentRoom));
            this.mucRepocitory.setData(this.namespace, this.id, "roomconfigPasswordProtectedRoom", Boolean.toString(this.roomconfigPasswordProtectedRoom));
            this.mucRepocitory.setData(this.namespace, this.id, "roomconfigMaxUsers", Integer.toString(this.roomconfigMaxUsers));
            if (this.roomconfigRoomSecret != null) {
                this.mucRepocitory.setData(this.namespace, this.id, "roomconfigRoomSecret", this.roomconfigRoomSecret);
            }
            for (Map.Entry<JID, Affiliation> entry : this.affiliations.entrySet()) {
                this.mucRepocitory.setData(this.namespace, this.id + "/affiliation", entry.getKey().getBareJID().toString(), entry.getValue().name());
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Error on storing room [" + this.id + "] configuration", e);
        }
    }

    public Affiliation getAffiliation(JID jid) {
        Affiliation result = this.affiliations.get(jid.getBareJID());
        return result == null ? Affiliation.NONE : result;
    }

    private Boolean getBoolean(String key) throws UserNotFoundException, TigaseDBException {
        Boolean val = Boolean.valueOf(this.mucRepocitory.getData(this.namespace, this.id, key));
        this.log.finest("Read from repository key " + key + " == " + val);
        return val;
    }

    public Form getFormElement() {
        Form x = new Form("form", "Room configuration", "Please configure");
        x.addField(Field.fieldHidden("FORM_TYPE", "http://jabber.org/protocol/muc#roomconfig"));
        String once = UUID.randomUUID().toString();
        x.addField(Field.fieldHidden("once", once));
        x.addField(Field.fieldTextSingle("muc#roomconfig_roomname", this.roomconfigRoomname, "Natural-Language Room Name"));
        x.addField(Field.fieldTextMulti("muc#roomconfig_roomdesc", this.roomconfigRoomdesc, "Short Description of Room"));
        x.addField(Field.fieldBoolean("muc#roomconfig_changesubject", this.roomconfigChangeSubject, "Allow Occupants to Change Subject"));
        x.addField(Field.fieldListSingle("muc#roomconfig_maxusers", String.valueOf(this.roomconfigMaxUsers), "Maximum Number of Room Occupants", new String[]{"1", "10", "20", "30", "50", "100", "150"}, new String[]{"1", "10", "20", "30", "50", "100", "150"}));
        x.addField(Field.fieldBoolean("muc#roomconfig_publicroom", this.roomconfigPublicRoom, "Allow Public Searching for Room"));
        x.addField(Field.fieldBoolean("muc#roomconfig_persistentroom", this.roomconfigPersistentRoom, "Make Room Persistent"));
        x.addField(Field.fieldBoolean("muc#roomconfig_moderatedroom", this.roomconfigModeratedRoom, "Make Room Moderated"));
        x.addField(Field.fieldBoolean("muc#roomconfig_membersonly", this.roomconfigMembersOnly, "An Invitation is Required to Enter"));
        x.addField(Field.fieldBoolean("muc#roomconfig_allowinvites", this.roomconfigAllowInvites, "Allow Occupants to Invite Others"));
        x.addField(Field.fieldBoolean("muc#roomconfig_passwordprotectedroom", this.roomconfigPasswordProtectedRoom, "A Password is required to enter"));
        x.addField(Field.fieldTextPrivate("muc#roomconfig_roomsecret", this.roomconfigRoomSecret, "The Room Password"));
        x.addField(Field.fieldListSingle("muc#roomconfig_whois", this.roomconfigWhois, "Affiliations that May Discover Real JIDs of Occupants", new String[]{"Room Owner and Admins Only", "Room Owner, Admins and Members Only", "Anyone"}, new String[]{"admin", "member", "anyone"}));
        x.addField(Field.fieldBoolean("muc#roomconfig_enablelogging", this.roomconfigEnableLogging, "Enable Logging of Room Conversations"));
        return x;
    }

    private Integer getInteger(String key) throws NumberFormatException, UserNotFoundException, TigaseDBException {
        String v = this.mucRepocitory.getData(this.namespace, this.id, key);
        this.log.finest("Read from repository key " + key + " == " + v);
        Integer val = Integer.valueOf(v);
        return val;
    }

    public int getRoomconfigMaxUsers() {
        return this.roomconfigMaxUsers;
    }

    public String getRoomconfigRoomdesc() {
        return this.roomconfigRoomdesc;
    }

    public String getRoomconfigRoomname() {
        return this.roomconfigRoomname;
    }

    public String getRoomconfigRoomSecret() {
        return this.roomconfigRoomSecret;
    }

    private String getString(String key) throws UserNotFoundException, TigaseDBException {
        String val = this.mucRepocitory.getData(this.namespace, this.id, key);
        this.log.finest("Read from repository key " + key + " == " + val);
        return val;
    }

    public boolean isRoomconfigAllowInvites() {
        return this.roomconfigAllowInvites;
    }

    public boolean isRoomconfigChangeSubject() {
        return this.roomconfigChangeSubject;
    }

    public boolean isRoomconfigEnableLogging() {
        return this.roomconfigEnableLogging;
    }

    public boolean isRoomconfigMembersOnly() {
        return this.roomconfigMembersOnly;
    }

    public boolean isRoomconfigModeratedRoom() {
        return this.roomconfigModeratedRoom;
    }

    public boolean isRoomconfigPasswordProtectedRoom() {
        return this.roomconfigPasswordProtectedRoom;
    }

    public boolean isRoomconfigPersistentRoom() {
        return this.roomconfigPersistentRoom;
    }

    public boolean isRoomconfigPublicRoom() {
        return this.roomconfigPublicRoom;
    }

    public boolean parseConfig(Element x) {
        LinkedList result = new LinkedList();
        Form form = new Form(x);
        boolean oldPersist = this.roomconfigPersistentRoom;
        String once = form.getAsString("once");
        String var = "muc#roomconfig_whois";
        if (form.is(var)) {
            String val;
            this.roomconfigWhois = val = form.getAsString(var);
            this.log.finest("Set variable " + var + " to " + val);
        }
        if (form.is(var = "muc#roomconfig_roomname")) {
            this.roomconfigRoomname = form.getAsString(var);
        }
        if (form.is(var = "muc#roomconfig_roomdesc")) {
            this.roomconfigRoomdesc = form.getAsString(var);
        }
        if (form.is(var = "muc#roomconfig_changesubject")) {
            this.roomconfigChangeSubject = form.getAsBoolean(var);
        }
        if (form.is(var = "muc#roomconfig_maxusers")) {
            this.roomconfigMaxUsers = form.getAsInteger(var);
        }
        if (form.is(var = "muc#roomconfig_publicroom")) {
            this.roomconfigPublicRoom = form.getAsBoolean(var);
        }
        if (form.is(var = "muc#roomconfig_persistentroom")) {
            this.roomconfigPersistentRoom = form.getAsBoolean(var);
        }
        if (form.is(var = "muc#roomconfig_moderatedroom")) {
            this.roomconfigModeratedRoom = form.getAsBoolean(var);
        }
        if (form.is(var = "muc#roomconfig_membersonly")) {
            this.roomconfigMembersOnly = form.getAsBoolean(var);
        }
        if (form.is(var = "muc#roomconfig_allowinvites")) {
            this.roomconfigAllowInvites = form.getAsBoolean(var);
        }
        if (form.is(var = "muc#roomconfig_passwordprotectedroom")) {
            this.roomconfigPasswordProtectedRoom = form.getAsBoolean(var);
        }
        if (form.is(var = "muc#roomconfig_roomsecret")) {
            this.roomconfigRoomSecret = form.getAsString(var);
        }
        if (form.is(var = "muc#roomconfig_enablelogging")) {
            this.roomconfigEnableLogging = form.getAsBoolean(var);
        }
        try {
            if (!(oldPersist != this.roomconfigPersistentRoom && this.roomconfigPersistentRoom || oldPersist == this.roomconfigPersistentRoom || this.roomconfigPersistentRoom)) {
                this.mucRepocitory.removeSubnode(this.namespace, this.id);
            }
            if (this.roomconfigPersistentRoom) {
                this.flushConfig();
            }
        }
        catch (UserExistsException e) {
            e.printStackTrace();
        }
        catch (TigaseDBException e) {
            e.printStackTrace();
        }
        return true;
    }

    public void setAffiliation(JID jid, Affiliation affiliation) {
        if (affiliation == null || affiliation == Affiliation.NONE) {
            this.affiliations.remove(jid.getBareJID());
        } else {
            this.affiliations.put(jid.getBareJID(), affiliation);
        }
        if (this.isRoomconfigPersistentRoom()) {
            try {
                if (affiliation == null || affiliation == Affiliation.NONE) {
                    this.mucRepocitory.removeData(this.namespace, this.id + "/affiliation", jid.getBareJID().toString());
                } else {
                    this.mucRepocitory.setData(this.namespace, this.id + "/affiliation", jid.getBareJID().toString(), affiliation.name());
                }
            }
            catch (UserNotFoundException e) {
                e.printStackTrace();
            }
            catch (TigaseDBException e) {
                e.printStackTrace();
            }
        }
    }

    public void setRoomconfigAllowInvites(boolean allowedOccupantsToInvite) {
        this.roomconfigAllowInvites = allowedOccupantsToInvite;
    }

    public void setRoomconfigChangeSubject(boolean allowedOccupantChangeSubject) {
        this.roomconfigChangeSubject = allowedOccupantChangeSubject;
    }

    public void setRoomconfigEnableLogging(boolean logging) {
        this.roomconfigEnableLogging = logging;
    }

    public void setRoomconfigMaxUsers(int maxOccupantNumber) {
        this.roomconfigMaxUsers = maxOccupantNumber;
    }

    public void setRoomconfigMembersOnly(boolean invitationRequired) {
        this.roomconfigMembersOnly = invitationRequired;
    }

    public void setRoomconfigModeratedRoom(boolean moderated) {
        this.roomconfigModeratedRoom = moderated;
    }

    public void setRoomconfigPasswordProtectedRoom(boolean passwordRequired) {
        this.roomconfigPasswordProtectedRoom = passwordRequired;
    }

    public void setRoomconfigPersistentRoom(boolean persist) {
        this.roomconfigPersistentRoom = persist;
    }

    public void setRoomconfigPublicRoom(boolean allowedPublicSearch) {
        this.roomconfigPublicRoom = allowedPublicSearch;
    }

    public void setRoomconfigRoomdesc(String roomFullName) {
        this.roomconfigRoomdesc = roomFullName;
    }

    public void setRoomconfigRoomname(String roomShortName) {
        this.roomconfigRoomname = roomShortName;
    }

    public void setRoomconfigRoomSecret(String password) {
        this.roomconfigRoomSecret = password;
    }

    public String getId() {
        return this.id;
    }
}

