/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc;

import tigase.xml.Element;

public class MucInternalException
extends Exception {
    private static final long serialVersionUID = 1L;
    private String code;
    private Element item;
    private String name;
    private String type;
    private String xmlns = "urn:ietf:params:xml:ns:xmpp-stanzas";
    private String message;

    public MucInternalException(Element item, String name, String code, String type) {
        this.item = item;
        this.name = name;
        this.code = code;
        this.type = type;
    }

    public MucInternalException(Element item, String name, String code, String type, String message) {
        this.item = item;
        this.name = name;
        this.code = code;
        this.type = type;
        this.message = message;
    }

    public String getCode() {
        return this.code;
    }

    public Element getItem() {
        return this.item;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Element makeElement() {
        return this.makeElement(true);
    }

    public Element makeElement(boolean insertOriginal) {
        Element answer = insertOriginal ? this.item.clone() : new Element(this.item.getName());
        answer.addAttribute("id", this.item.getAttribute("id"));
        answer.addAttribute("type", "error");
        answer.addAttribute("to", this.item.getAttribute("from"));
        answer.addAttribute("from", this.item.getAttribute("to"));
        if (this.message != null) {
            Element text = new Element("text", this.message, new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-stanzas"});
            answer.addChild(text);
        }
        answer.addChild(this.makeErrorElement());
        return answer;
    }

    public Element makeErrorElement() {
        Element error = new Element("error");
        error.setAttribute("code", this.code);
        error.setAttribute("type", this.type);
        error.addChild(new Element(this.name, new String[]{"xmlns"}, new String[]{this.xmlns}));
        return error;
    }
}

