/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc;

import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import tigase.muc.RoomContext;
import tigase.muc.RoomListener;
import tigase.muc.RoomsContainer;
import tigase.muc.modules.BroadcastMessageModule;
import tigase.muc.modules.ChangeSubjectModule;
import tigase.muc.modules.InvitationModule;
import tigase.muc.modules.MUCModule;
import tigase.muc.modules.Module;
import tigase.muc.modules.PresenceModule;
import tigase.muc.modules.PrivateMessageModule;
import tigase.muc.modules.RoomModule;
import tigase.muc.modules.UniqueRoomNameModule;
import tigase.muc.modules.admin.AdminGetModule;
import tigase.muc.modules.admin.AdminSetModule;
import tigase.muc.modules.owner.OwnerGetModule;
import tigase.muc.modules.owner.OwnerSetModule;
import tigase.xml.Element;

public class ModulesProcessor {
    private Logger log = Logger.getLogger(this.getClass().getName());
    private List<Module> modules = new LinkedList<Module>();

    public ModulesProcessor(RoomListener listener) {
        this.registerModule(new UniqueRoomNameModule());
        this.registerModule(new InvitationModule());
        this.registerModule(new ChangeSubjectModule());
        this.registerModule(new BroadcastMessageModule());
        this.registerModule(new PrivateMessageModule());
        this.registerModule(new PresenceModule(listener));
        this.registerModule(new AdminGetModule());
        this.registerModule(new AdminSetModule());
        this.registerModule(new OwnerGetModule());
        this.registerModule(new OwnerSetModule(listener));
    }

    public List<Element> processStanza(RoomContext roomContext, RoomsContainer roomsContainer, Element element) {
        for (Module module : this.modules) {
            if (!module.getModuleCriteria().match(element)) continue;
            List<Element> result = null;
            if (module instanceof RoomModule && roomContext != null) {
                RoomModule roomModule = (RoomModule)module;
                result = roomModule.process(roomContext, element);
            } else if (module instanceof MUCModule && roomsContainer != null) {
                MUCModule mucModule = (MUCModule)module;
                result = mucModule.process(roomsContainer, element);
            }
            if (result == null || result.size() <= 0) continue;
            return result;
        }
        return null;
    }

    public void registerModule(Module module) {
        this.modules.add(module);
        this.log.config("Registered MUC module: " + module.toString());
    }
}

