/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import tigase.conf.Configurable;
import tigase.db.RepositoryFactory;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.disco.ServiceEntity;
import tigase.disco.ServiceIdentity;
import tigase.disco.XMPPService;
import tigase.muc.ModulesProcessor;
import tigase.muc.MucVersion;
import tigase.muc.RoomContext;
import tigase.muc.RoomListener;
import tigase.muc.RoomsContainer;
import tigase.muc.xmpp.JID;
import tigase.muc.xmpp.stanzas.IQ;
import tigase.server.AbstractMessageReceiver;
import tigase.server.Packet;
import tigase.util.DNSResolver;
import tigase.util.JIDUtils;
import tigase.xml.Element;

public class MUCService
extends AbstractMessageReceiver
implements XMPPService,
Configurable,
RoomListener {
    private static final String MUC_REPO_CLASS_PROP_KEY = "muc-repo-class";
    private static final String MUC_REPO_CLASS_PROP_VAL = "tigase.db.xml.XMLRepository";
    private static final String MUC_REPO_URL_PROP_KEY = "muc-repo-url";
    private static final String MUC_REPO_URL_PROP_VAL = "muc-repository.xml";
    private Logger log = Logger.getLogger(this.getClass().getName());
    private UserRepository mucRepository;
    private ModulesProcessor processor;
    private RoomsContainer rooms;
    private ServiceEntity serviceEntity = null;

    public static Element errorPresence(JID from, JID to, String type, String code, String errorElement) {
        Element p = new Element("presence");
        p.setAttribute("from", from.toString());
        p.setAttribute("to", to.toString());
        p.setAttribute("type", "error");
        Element error = new Element("error");
        error.setAttribute("code", code);
        error.setAttribute("type", type);
        error.addChild(new Element(errorElement, new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-stanzas"}));
        p.addChild(error);
        return p;
    }

    public MUCService() {
        this.log.info("Creating tigase-muc ver." + MucVersion.getVersion() + " Service.");
        this.processor = new ModulesProcessor(this);
    }

    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map props = super.getDefaults(params);
        String[] hostnamesPropVal = null;
        hostnamesPropVal = params.get("--virt-hosts") != null ? ((String)params.get("--virt-hosts")).split(",") : DNSResolver.getDefHostNames();
        for (int i = 0; i < hostnamesPropVal.length; ++i) {
            hostnamesPropVal[i] = ((String)params.get("config-type")).equals("--gen-config-comp") ? hostnamesPropVal[i] : "muc." + hostnamesPropVal[i];
        }
        String repo_class = MUC_REPO_CLASS_PROP_VAL;
        String repo_uri = "user-repository.xml";
        String conf_db = null;
        if (params.get("--user-db") != null) {
            conf_db = (String)params.get("--user-db");
        }
        if (conf_db != null) {
            if (conf_db.equals("mysql")) {
                repo_class = "tigase.db.jdbc.JDBCRepository";
                repo_uri = "jdbc:mysql://localhost/tigase?user=root&password=mypass";
            }
            if (conf_db.equals("pgsql")) {
                repo_class = "tigase.db.jdbc.JDBCRepository";
                repo_uri = "jdbc:postgresql://localhost/tigase?user=tigase";
            }
        }
        if (params.get("--user-db-uri") != null) {
            repo_uri = (String)params.get("--user-db-uri");
        }
        props.put(MUC_REPO_CLASS_PROP_KEY, repo_class);
        props.put(MUC_REPO_URL_PROP_KEY, repo_uri);
        props.put("hostnames", hostnamesPropVal);
        return props;
    }

    public List<Element> getDiscoFeatures() {
        return null;
    }

    public Element getDiscoInfo(String node, String jid) {
        if (jid != null && JIDUtils.getNodeHost((String)jid).startsWith(this.getName() + ".")) {
            return this.serviceEntity.getDiscoInfo(node);
        }
        return null;
    }

    public List<Element> getDiscoItems(String node, String jid) {
        if (JIDUtils.getNodeHost((String)jid).startsWith(this.getName() + ".")) {
            return this.serviceEntity.getDiscoItems(node, null);
        }
        return Arrays.asList(this.serviceEntity.getDiscoItem(null, this.getName() + "." + jid));
    }

    public String myDomain() {
        return this.getName() + "." + this.getDefHostName();
    }

    @Override
    public void onConfigurationChange(RoomContext room) {
        ServiceEntity ent = this.serviceEntity.findNode(room.getRoomID());
        if (ent != null) {
            this.serviceEntity.removeItems(new ServiceEntity[]{ent});
        }
        this.rooms.configRoomDiscovery(room);
    }

    @Override
    public void onDestroy(RoomContext room) {
        ServiceEntity ent = this.serviceEntity.findNode(room.getRoomID());
        if (ent != null) {
            this.serviceEntity.removeItems(new ServiceEntity[]{ent});
        }
        this.rooms.destroyRoom(JID.fromString(room.getRoomID()));
        try {
            this.mucRepository.removeSubnode(this.myDomain(), room.getRoomID());
        }
        catch (UserNotFoundException e) {
            e.printStackTrace();
        }
        catch (TigaseDBException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onOccupantLeave(RoomContext room) {
        int c = room.getOccupantsByJID().size();
        if (c == 0) {
            this.rooms.removeRoom(JID.fromString(room.getRoomID()));
        }
    }

    private Element processDisco(IQ iq) {
        Element queryInfo = iq.getChild("query", "http://jabber.org/protocol/disco#info");
        Element queryItems = iq.getChild("query", "http://jabber.org/protocol/disco#items");
        String jid = iq.getTo().getBareJID().toString();
        if (queryInfo != null) {
            String node = queryInfo.getAttribute("node");
            Element result = this.getDiscoInfo(node, jid);
            return result;
        }
        if (queryItems != null) {
            String node = queryItems.getAttribute("node");
            Element result = this.serviceEntity.getDiscoItem(node, jid);
            return result;
        }
        return null;
    }

    public void processPacket(Packet packet) {
        try {
            String roomID = JIDUtils.getNodeID((String)packet.getElemTo());
            if ("iq".equals(packet.getElemName()) && packet.getElement().getChild("query", "http://jabber.org/protocol/disco#info") != null || packet.getElement().getChild("query", "http://jabber.org/protocol/disco#items") != null) {
                Packet result = packet.okResult(this.processDisco(new IQ(packet.getElement())), 0);
                this.addOutPacket(result);
                return;
            }
            LinkedList<Element> stanzasToSend = new LinkedList<Element>();
            RoomContext room = null;
            if (roomID != null) {
                room = this.rooms.getRoomContext(roomID);
                if (room == null && "presence".equals(packet.getElemName())) {
                    boolean newRoom = !this.rooms.isRoomExists(JID.fromString(roomID));
                    room = new RoomContext(this.myDomain(), roomID, this.mucRepository, JID.fromString(packet.getElemFrom()), newRoom);
                    this.rooms.addRoom(room);
                } else if (room == null && !"presence".equals(packet.getElemName())) {
                    this.addOutPacket(packet.errorResult("cancel", "item-not-found", null, true));
                    return;
                }
            }
            List<Element> result = this.processor.processStanza(room, this.rooms, packet.getElement());
            stanzasToSend.addAll(result);
            if (stanzasToSend != null && stanzasToSend.size() > 0) {
                for (Element element : stanzasToSend) {
                    this.addOutPacket(new Packet(element));
                }
            } else {
                this.addOutPacket(packet.errorResult("cancel", "feature-not-implemented", "Stanza is not processed", true));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.throwing("Muc Service", "processPacket", e);
        }
    }

    public void setProperties(Map<String, Object> props) {
        super.setProperties(props);
        this.serviceEntity = new ServiceEntity(this.getName(), null, "Multi User Chat");
        this.serviceEntity.addIdentities(new ServiceIdentity[]{new ServiceIdentity("conference", "text", "Multi User Chat")});
        this.serviceEntity.addFeatures(new String[]{"http://jabber.org/protocol/muc", "muc_rooms"});
        this.log.config("Register Service discovery " + this.serviceEntity.getJID());
        try {
            String cls_name = (String)props.get(MUC_REPO_CLASS_PROP_KEY);
            String res_uri = (String)props.get(MUC_REPO_URL_PROP_KEY);
            this.mucRepository = RepositoryFactory.getUserRepository((String)"muc", (String)cls_name, (String)res_uri);
            this.mucRepository.initRepository(res_uri);
            this.log.config("Initialized " + cls_name + " as user repository: " + res_uri);
        }
        catch (Exception e) {
            this.log.severe("Can't initialize user repository: " + e);
            e.printStackTrace();
            System.exit(1);
        }
        String[] hostnames = (String[])props.get("hostnames");
        this.clearRoutings();
        for (String host : hostnames) {
            this.addRouting(host);
        }
        this.rooms = new RoomsContainer(this.myDomain(), this.mucRepository, this.serviceEntity);
        this.rooms.readAllRomms();
        this.log.info("MUC Service started.");
        System.out.println(".");
    }
}

