/*
 * Decompiled with CFR 0.152.
 */
package tigase.form;

import java.util.LinkedList;
import tigase.xml.Element;

public class Field {
    private String description;
    private String label;
    private String[] optionLabels;
    private String[] optionValues;
    private boolean required;
    private String type;
    private String[] values;
    private String var;

    public static Field fieldBoolean(String var, Boolean value, String label) {
        Field field = new Field("boolean");
        field.label = label;
        field.var = var;
        if (value != null && value.booleanValue()) {
            field.values = new String[]{"1"};
        } else if (value != null && !value.booleanValue()) {
            field.values = new String[]{"0"};
        }
        return field;
    }

    public static Field fieldFixed(String value) {
        Field field = new Field("fixed");
        field.values = new String[]{value};
        return field;
    }

    public static Field fieldHidden(String var, String value) {
        Field field = new Field("hidden", var);
        field.values = new String[]{value};
        return field;
    }

    public static Field fieldListMulti(String var, String[] values, String label, String[] optionsLabel, String optionsValue) {
        if (optionsLabel.length != optionsValue.length()) {
            throw new RuntimeException("Invalid optionsLabel and optinsValue length");
        }
        Field field = new Field("list-single", var);
        field.label = label;
        field.values = values;
        field.optionLabels = optionsLabel;
        field.optionValues = optionsLabel;
        return field;
    }

    public static Field fieldListSingle(String var, String value, String label, String[] optionsLabel, String[] optionsValue) {
        if (optionsLabel.length != optionsValue.length) {
            throw new RuntimeException("Invalid optionsLabel and optinsValue length");
        }
        Field field = new Field("list-single", var);
        field.label = label;
        field.values = new String[]{value};
        field.optionLabels = optionsLabel;
        field.optionValues = optionsValue;
        return field;
    }

    public static Field fieldTextMulti(String var, String value, String label) {
        Field field = new Field("text-multi", var);
        field.label = label;
        field.values = new String[]{value};
        return field;
    }

    public static Field fieldTextPrivate(String var, String value, String label) {
        Field field = new Field("text-private", var);
        field.label = label;
        field.values = new String[]{value};
        return field;
    }

    public static Field fieldTextSingle(String var, String value, String label) {
        Field field = new Field("text-single", var);
        field.label = label;
        field.values = new String[]{value};
        return field;
    }

    public Field(Element fieldElement) {
        this.var = fieldElement.getAttribute("var");
        this.type = fieldElement.getAttribute("type");
        this.label = fieldElement.getAttribute("label");
        Element d = fieldElement.getChild("desc");
        if (d != null) {
            this.description = d.getCData();
        }
        this.required = fieldElement.getChild("required") != null;
        LinkedList<String> valueList = new LinkedList<String>();
        LinkedList<String> optionsLabelList = new LinkedList<String>();
        LinkedList<String> optionsValueList = new LinkedList<String>();
        for (Element element : fieldElement.getChildren()) {
            if ("value".equals(element.getName())) {
                valueList.add(element.getCData());
                continue;
            }
            if (!"value".equals(element.getName())) continue;
            optionsLabelList.add(element.getAttribute("label"));
            Element v = element.getChild("value");
            optionsValueList.add(v.getCData());
        }
        this.values = valueList.toArray(new String[0]);
        this.optionLabels = optionsLabelList.toArray(new String[0]);
        this.optionValues = optionsValueList.toArray(new String[0]);
    }

    private Field(String type) {
        this.type = type;
    }

    private Field(String type, String var) {
        this.type = type;
        this.var = var;
    }

    public String getDescription() {
        return this.description;
    }

    public Element getElement() {
        Element field = new Element("field");
        if (this.var != null) {
            field.setAttribute("var", this.var);
        }
        if (this.type != null) {
            field.setAttribute("type", this.type);
        }
        if (this.label != null) {
            field.setAttribute("label", this.label);
        }
        if (this.description != null) {
            field.addChild(new Element("desc", this.description));
        }
        if (this.required) {
            field.addChild(new Element("required"));
        }
        if (this.values != null) {
            for (String value : this.values) {
                field.addChild(new Element("value", value));
            }
        }
        if (this.optionLabels != null) {
            for (int i = 0; i < this.optionLabels.length; ++i) {
                Element option = new Element("option");
                option.setAttribute("label", this.optionLabels[i]);
                Element vo = new Element("value", this.optionValues[i]);
                option.addChild(vo);
                field.addChild(option);
            }
        }
        return field;
    }

    public String getLabel() {
        return this.label;
    }

    public String[] getOptionLabels() {
        return this.optionLabels;
    }

    public String[] getOptionValues() {
        return this.optionValues;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        if (this.values != null && this.values.length > 0) {
            return this.values[0];
        }
        return null;
    }

    public String[] getValues() {
        return this.values;
    }

    public String getVar() {
        return this.var;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setOptionLabels(String[] optionLabels) {
        this.optionLabels = optionLabels;
    }

    public void setOptionValues(String[] optionValues) {
        this.optionValues = optionValues;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setValues(String[] values) {
        this.values = values;
    }

    public void setVar(String var) {
        this.var = var;
    }
}

