/*
 * Decompiled with CFR 0.152.
 */
package tigase.mongodb;

import com.mongodb.ConnectionString;
import com.mongodb.MongoException;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.UpdateOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bson.Document;
import org.bson.conversions.Bson;
import tigase.db.DBInitException;
import tigase.db.DataSource;
import tigase.db.util.DBSchemaLoader;
import tigase.db.util.RepositoryVersionAware;
import tigase.db.util.SchemaLoader;
import tigase.db.util.SchemaManager;
import tigase.mongodb.Helper;
import tigase.mongodb.MongoDataSource;
import tigase.util.Version;
import tigase.util.log.LogFormatter;
import tigase.util.ui.console.CommandlineParameter;
import tigase.xmpp.jid.BareJID;

public class MongoSchemaLoader
extends SchemaLoader<Parameters> {
    protected static final String SCHEMA_VERSION = "tig_schema_versions";
    private static final Logger log = Logger.getLogger(MongoSchemaLoader.class.getCanonicalName());
    private static final List<SchemaLoader.TypeInfo> supportedTypes = Stream.of(new SchemaLoader.TypeInfo(50, "mongodb", "MongoDB", MongoClient.class.getCanonicalName())).collect(Collectors.toList());
    private MongoClient client;
    private MongoDataSource dataSource;
    private Parameters params;

    public SchemaLoader.Result addXmppAdminAccount(SchemaManager.SchemaInfo schemaInfo) {
        if (this.dataSource == null) {
            log.log(Level.WARNING, "Connection not validated");
            return SchemaLoader.Result.error;
        }
        List<BareJID> jids = this.params.getAdmins();
        if (jids.size() < 1) {
            log.log(Level.WARNING, "Error: No admin users entered");
            return SchemaLoader.Result.warning;
        }
        String pwd = this.params.getAdminPassword();
        if (pwd == null) {
            log.log(Level.WARNING, "Error: No admin password entered");
            return SchemaLoader.Result.warning;
        }
        return this.addUsersToRepository(schemaInfo, this.dataSource, MongoDataSource.class, jids, pwd, log);
    }

    public Parameters createParameters() {
        return new Parameters();
    }

    public SchemaLoader.Result destroyDataSource() {
        if (this.client == null) {
            log.log(Level.WARNING, "Connection not validated");
            return SchemaLoader.Result.error;
        }
        try {
            MongoDatabase db = this.client.getDatabase(this.params.getDbName());
            if (db != null) {
                db.runCommand((Bson)new Document().append("dropUser", (Object)this.params.getDbUser()));
                db.drop();
            }
            return SchemaLoader.Result.ok;
        }
        catch (MongoException ex) {
            if (ex.getCode() == 11) {
                return SchemaLoader.Result.ok;
            }
            log.log(Level.WARNING, ex.getMessage());
            return SchemaLoader.Result.error;
        }
    }

    public void execute(SchemaLoader.Parameters params) {
    }

    public List<CommandlineParameter> getCommandlineParameters() {
        List<CommandlineParameter> options = this.getSetupOptions();
        options.add(new CommandlineParameter.Builder("L", DBSchemaLoader.PARAMETERS_ENUM.LOG_LEVEL.getName()).description("Java Logger level during loading process").defaultValue(DBSchemaLoader.PARAMETERS_ENUM.LOG_LEVEL.getDefaultValue()).build());
        options.add(new CommandlineParameter.Builder("J", DBSchemaLoader.PARAMETERS_ENUM.ADMIN_JID.getName()).description("Comma separated list of administrator JID(s)").build());
        options.add(new CommandlineParameter.Builder("N", DBSchemaLoader.PARAMETERS_ENUM.ADMIN_JID_PASS.getName()).description("Password that will be used for the entered JID(s) - one for all configured administrators").secret().build());
        return options;
    }

    public Optional<Version> getComponentVersionFromDb(String component) {
        if (this.dataSource == null) {
            log.log(Level.WARNING, "Connection not validated");
            return Optional.empty();
        }
        return this.dataSource.getSchemaVersion(component);
    }

    public Optional<Version> getMinimalRequiredComponentVersionForUpgrade(SchemaManager.SchemaInfo schemaInfo) {
        return Optional.of(Version.ZERO);
    }

    public String getDBUri() {
        return this.getDBUri(false);
    }

    private String getDBUri(boolean useRootCredentials) {
        StringBuilder sb = new StringBuilder();
        sb.append("mongodb://");
        if (useRootCredentials && this.params.getDbRootUser() != null) {
            if (this.params.getDbRootUser() != null) {
                sb.append(this.params.getDbRootUser());
                if (this.params.getDbPass() != null) {
                    sb.append(":").append(this.params.getDbRootPass());
                }
                sb.append("@");
            }
            sb.append(this.params.getDbHostname()).append("/").append("admin");
        } else {
            if (this.params.getDbUser() != null) {
                sb.append(this.params.getDbUser());
                if (this.params.getDbPass() != null) {
                    sb.append(":").append(this.params.getDbPass());
                }
                sb.append("@");
            }
            sb.append(this.params.getDbHostname()).append("/").append(this.params.getDbName());
        }
        String options = this.params.getDbOptions();
        if (options == null || options.isEmpty()) {
            if (this.params.isUseSSL()) {
                sb.append("?ssl=true");
            }
        } else {
            sb.append("?").append(options);
            if (this.params.isUseSSL()) {
                sb.append("&ssl=true");
            }
        }
        return sb.toString();
    }

    public List<CommandlineParameter> getSetupOptions() {
        ArrayList<CommandlineParameter> options = new ArrayList<CommandlineParameter>();
        options.add(new CommandlineParameter.Builder("D", DBSchemaLoader.PARAMETERS_ENUM.DATABASE_NAME.getName()).description("Name of the database that will be created and to which schema will be loaded").defaultValue(DBSchemaLoader.PARAMETERS_ENUM.DATABASE_NAME.getDefaultValue()).required(true).build());
        options.add(new CommandlineParameter.Builder("H", DBSchemaLoader.PARAMETERS_ENUM.DATABASE_HOSTNAME.getName()).description("Address of the database instance").defaultValue(DBSchemaLoader.PARAMETERS_ENUM.DATABASE_HOSTNAME.getDefaultValue()).required(true).build());
        options.add(new CommandlineParameter.Builder("U", DBSchemaLoader.PARAMETERS_ENUM.TIGASE_USERNAME.getName()).description("Name of the user that will be used").defaultValue(DBSchemaLoader.PARAMETERS_ENUM.TIGASE_USERNAME.getDefaultValue()).build());
        options.add(new CommandlineParameter.Builder("P", DBSchemaLoader.PARAMETERS_ENUM.TIGASE_PASSWORD.getName()).description("Password of the user that will be used").defaultValue(DBSchemaLoader.PARAMETERS_ENUM.TIGASE_PASSWORD.getDefaultValue()).secret().build());
        options.add(new CommandlineParameter.Builder("R", DBSchemaLoader.PARAMETERS_ENUM.ROOT_USERNAME.getName()).description("Database root account username used to create tigase user and database").build());
        options.add(new CommandlineParameter.Builder("A", DBSchemaLoader.PARAMETERS_ENUM.ROOT_PASSWORD.getName()).description("Database root account password used to create tigase user and database").secret().build());
        options.add(new CommandlineParameter.Builder("S", DBSchemaLoader.PARAMETERS_ENUM.USE_SSL.getName()).description("Enable SSL support for database connection").requireArguments(false).defaultValue(DBSchemaLoader.PARAMETERS_ENUM.USE_SSL.getDefaultValue()).type(Boolean.class).build());
        options.add(new CommandlineParameter.Builder("O", DBSchemaLoader.PARAMETERS_ENUM.DATABASE_OPTIONS.getName()).description("Additional databse options query").requireArguments(false).build());
        return options;
    }

    public List<SchemaLoader.TypeInfo> getSupportedTypes() {
        return supportedTypes;
    }

    public void init(Parameters params, Optional<SchemaManager.RootCredentialsCache> rootCredentialsCache) {
        this.params = params;
        params.init(rootCredentialsCache);
        Level lvl = params.logLevel;
        log.setUseParentHandlers(false);
        log.setLevel(lvl);
        Arrays.stream(log.getHandlers()).filter(handler -> handler instanceof ConsoleHandler).findAny().orElseGet(() -> {
            ConsoleHandler handler = new ConsoleHandler();
            handler.setLevel(lvl);
            handler.setFormatter((Formatter)new LogFormatter());
            log.addHandler(handler);
            return handler;
        });
        log.log(Level.CONFIG, "Parameters: {0}", new Object[]{params});
    }

    public SchemaLoader.Result loadSchema(SchemaManager.SchemaInfo schema, String version) {
        if ("common".equals(schema.getId())) {
            return SchemaLoader.Result.ok;
        }
        if (this.dataSource == null) {
            log.log(Level.WARNING, "Connection not validated");
            return SchemaLoader.Result.error;
        }
        Optional<Version> currentVersion = this.getComponentVersionFromDb(schema.getId());
        log.log(Level.INFO, "Loading schema " + schema.getId() + ", version: " + version);
        Set results = this.getInitializedDataSourceAwareForSchemaInfo(schema, MongoDataSource.class, this.dataSource, log).map(repo -> {
            if (repo == null) {
                return SchemaLoader.Result.error;
            }
            try {
                repo.setDataSource((DataSource)this.dataSource);
                if (repo instanceof RepositoryVersionAware) {
                    RepositoryVersionAware versionAwareRepo = (RepositoryVersionAware)repo;
                    Version newVersion = Version.of((String)version);
                    SchemaLoader.Result res = versionAwareRepo.updateSchema(currentVersion, newVersion);
                    if (!currentVersion.isPresent() && SchemaLoader.Result.skipped.equals((Object)res) || SchemaLoader.Result.ok.equals((Object)res)) {
                        this.setComponentVersion(schema.getId(), newVersion.toString());
                    }
                    return res;
                }
                return SchemaLoader.Result.skipped;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                log.log(Level.WARNING, ex.getMessage());
                return SchemaLoader.Result.error;
            }
        }).collect(Collectors.toSet());
        return results.contains(SchemaLoader.Result.error) ? SchemaLoader.Result.error : (results.contains(SchemaLoader.Result.warning) ? SchemaLoader.Result.warning : SchemaLoader.Result.ok);
    }

    public SchemaLoader.Result loadSchemaFile(String fileName) {
        return SchemaLoader.Result.error;
    }

    public SchemaLoader.Result postInstallation() {
        return SchemaLoader.Result.ok;
    }

    public SchemaLoader.Result printInfo() {
        if (this.dataSource == null) {
            log.log(Level.WARNING, "Connection not validated");
            return SchemaLoader.Result.error;
        }
        return super.printInfo();
    }

    public SchemaLoader.Result setComponentVersion(String component, String version) {
        if (this.dataSource == null) {
            log.log(Level.WARNING, "Connection not validated");
            return SchemaLoader.Result.error;
        }
        if (component == null || component.isEmpty()) {
            log.log(Level.WARNING, "Wrong component name passed: " + component);
            return SchemaLoader.Result.warning;
        }
        try {
            MongoDatabase db = this.dataSource.getDatabase();
            if (db != null) {
                if (!Helper.collectionExists(db, SCHEMA_VERSION)) {
                    db.createCollection(SCHEMA_VERSION);
                }
                Document crit = new Document("_id", (Object)component);
                Document dto = new Document("version", (Object)version);
                db.getCollection(SCHEMA_VERSION).updateOne((Bson)crit, (Bson)new Document("$set", (Object)dto), new UpdateOptions().upsert(true));
            }
        }
        catch (MongoException ex) {
            log.log(Level.WARNING, ex.getMessage());
            return SchemaLoader.Result.error;
        }
        return SchemaLoader.Result.ok;
    }

    public SchemaLoader.Result shutdown() {
        if (this.client == null) {
            log.log(Level.WARNING, "Connection not validated");
            return SchemaLoader.Result.error;
        }
        try {
            this.client.close();
            if (this.dataSource != null) {
                this.dataSource.beforeUnregister();
            }
            return SchemaLoader.Result.ok;
        }
        catch (MongoException ex) {
            log.log(Level.WARNING, ex.getMessage());
            return SchemaLoader.Result.error;
        }
    }

    public SchemaLoader.Result validateDBConnection() {
        try {
            String uri = this.getDBUri(true);
            this.client = MongoClients.create((String)uri);
            this.client.listDatabaseNames().iterator().hasNext();
            return SchemaLoader.Result.ok;
        }
        catch (MongoException ex) {
            log.log(Level.WARNING, ex.getMessage());
            this.client = null;
            return SchemaLoader.Result.error;
        }
    }

    public SchemaLoader.Result validateDBExists() {
        if (this.client == null) {
            log.log(Level.WARNING, "Connection not validated");
            return SchemaLoader.Result.error;
        }
        try {
            MongoDatabase db;
            boolean exists = false;
            for (String name : this.client.listDatabaseNames()) {
                if (!this.params.getDbName().equals(name)) continue;
                exists = true;
                break;
            }
            if (exists) {
                log.log(Level.INFO, "Exists OK");
                db = this.client.getDatabase(this.params.getDbName());
            } else {
                log.log(Level.INFO, "Creating database...");
                db = this.client.getDatabase(this.params.getDbName());
                log.log(Level.INFO, "OK");
            }
            if (this.params.getDbUser() != null && this.params.getDbPass() != null) {
                boolean createUser;
                boolean bl = createUser = this.client.getDatabase("admin").getCollection("system.users").find(Filters.and((Bson[])new Bson[]{Filters.eq((String)"user", (Object)this.params.getDbUser()), Filters.eq((String)"db", (Object)this.params.getDbName())})).first() == null;
                if (createUser) {
                    Document document = db.runCommand((Bson)new Document().append("createUser", (Object)this.params.getDbUser()).append("pwd", (Object)this.params.getDbPass()).append("roles", Collections.singletonList(new Document("role", (Object)"dbOwner").append("db", (Object)this.params.getDbName()))));
                }
            }
            this.client.close();
            this.client = null;
            String uri = this.getDBUri();
            this.dataSource = new MongoDataSource();
            this.dataSource.initRepository(uri, new HashMap<String, String>());
            return SchemaLoader.Result.ok;
        }
        catch (MongoException | DBInitException ex) {
            log.log(Level.WARNING, ex.getMessage());
            return SchemaLoader.Result.error;
        }
    }

    public static class Parameters
    implements SchemaLoader.Parameters {
        private String adminPassword;
        private List<BareJID> admins;
        private String dbHostname = null;
        private String dbName = null;
        private String dbOptions = null;
        private String dbPass = null;
        private String dbRootPass = null;
        private String dbRootUser = null;
        private String dbUser = null;
        private Level logLevel = Level.CONFIG;
        private boolean useSSL = false;
        private boolean forceReloadSchema = false;

        private static String getProperty(Properties props, DBSchemaLoader.PARAMETERS_ENUM param) {
            return props.getProperty(param.getName(), null);
        }

        private static String getPropertyWithDefault(Properties props, DBSchemaLoader.PARAMETERS_ENUM param) {
            return props.getProperty(param.getName(), param.getDefaultValue());
        }

        private static <T> T getProperty(Properties props, DBSchemaLoader.PARAMETERS_ENUM param, Function<String, T> converter) {
            String tmp = Parameters.getProperty(props, param);
            if (tmp == null) {
                return null;
            }
            return converter.apply(tmp);
        }

        private static <T> T getPropertyWithDefault(Properties props, DBSchemaLoader.PARAMETERS_ENUM param, Function<String, T> converter) {
            String tmp = Parameters.getPropertyWithDefault(props, param);
            if (tmp == null) {
                return null;
            }
            return converter.apply(tmp);
        }

        public String getAdminPassword() {
            return this.adminPassword;
        }

        public List<BareJID> getAdmins() {
            return this.admins == null ? Collections.emptyList() : this.admins;
        }

        public String getDbHostname() {
            return this.dbHostname;
        }

        public String getDbName() {
            return this.dbName;
        }

        public String getDbOptions() {
            return this.dbOptions;
        }

        public String getDbPass() {
            return this.dbPass;
        }

        public String getDbRootPass() {
            return this.dbRootPass;
        }

        public String getDbRootUser() {
            return this.dbRootUser;
        }

        public String getDbUser() {
            return this.dbUser;
        }

        public Level getLogLevel() {
            return this.logLevel;
        }

        public void setLogLevel(Level level) {
            this.logLevel = level;
        }

        public boolean isForceReloadSchema() {
            return this.forceReloadSchema;
        }

        public void setForceReloadSchema(boolean forceReloadSchema) {
            this.forceReloadSchema = forceReloadSchema;
        }

        protected void init(Optional<SchemaManager.RootCredentialsCache> rootCredentialsCache) {
            SchemaManager.RootCredentialsCache cache;
            SchemaManager.RootCredentials credentials;
            if (this.dbRootUser == null && this.dbRootPass == null && rootCredentialsCache.isPresent() && (credentials = (cache = rootCredentialsCache.get()).get(this.dbHostname)) != null) {
                this.dbRootUser = credentials.user;
                this.dbRootPass = credentials.password;
            }
        }

        public boolean isUseSSL() {
            return this.useSSL;
        }

        public void parseUri(String uri) {
            ConnectionString connectionString = new ConnectionString(uri);
            this.dbUser = connectionString.getUsername();
            this.dbPass = connectionString.getPassword() != null ? new String(connectionString.getPassword()) : null;
            this.dbHostname = connectionString.getHosts().stream().collect(Collectors.joining(","));
            this.dbName = connectionString.getDatabase();
            this.useSSL = Optional.ofNullable(connectionString.getSslEnabled()).orElse(false);
            int idx = uri.indexOf(this.dbName + "?");
            if (idx > 0) {
                this.dbOptions = uri.substring(idx + this.dbName.length() + 1);
            }
            if (this.dbOptions != null) {
                String tmp = "ssl=" + this.useSSL;
                idx = this.dbOptions.indexOf(tmp);
                if (idx == 0) {
                    this.dbOptions = this.dbOptions.length() == tmp.length() ? "" : this.dbOptions.substring(tmp.length() + 1);
                } else if (idx > 0) {
                    this.dbOptions = this.dbOptions.replace("&" + tmp, "");
                }
            }
        }

        public void setAdmins(List<BareJID> admins, String password) {
            this.admins = admins;
            this.adminPassword = password;
        }

        public void setDbRootCredentials(String username, String password) {
            this.dbRootUser = username;
            this.dbRootPass = password;
        }

        public void setProperties(Properties props) {
            this.logLevel = Parameters.getPropertyWithDefault(props, DBSchemaLoader.PARAMETERS_ENUM.LOG_LEVEL, val -> Level.parse(val));
            this.admins = Parameters.getProperty(props, DBSchemaLoader.PARAMETERS_ENUM.ADMIN_JID, tmp -> Arrays.stream(tmp.split(",")).map(str -> BareJID.bareJIDInstanceNS((String)str)).collect(Collectors.toList()));
            this.adminPassword = Parameters.getProperty(props, DBSchemaLoader.PARAMETERS_ENUM.ADMIN_JID_PASS);
            this.dbName = Parameters.getProperty(props, DBSchemaLoader.PARAMETERS_ENUM.DATABASE_NAME);
            this.dbHostname = Parameters.getProperty(props, DBSchemaLoader.PARAMETERS_ENUM.DATABASE_HOSTNAME);
            this.dbUser = Parameters.getProperty(props, DBSchemaLoader.PARAMETERS_ENUM.TIGASE_USERNAME);
            this.dbPass = Parameters.getProperty(props, DBSchemaLoader.PARAMETERS_ENUM.TIGASE_PASSWORD);
            this.useSSL = Optional.ofNullable(Parameters.getProperty(props, DBSchemaLoader.PARAMETERS_ENUM.USE_SSL, tmp -> Boolean.parseBoolean(tmp))).orElse(false);
            this.dbOptions = Parameters.getProperty(props, DBSchemaLoader.PARAMETERS_ENUM.DATABASE_OPTIONS);
            this.dbRootUser = Parameters.getProperty(props, DBSchemaLoader.PARAMETERS_ENUM.ROOT_USERNAME);
            this.dbRootPass = Parameters.getProperty(props, DBSchemaLoader.PARAMETERS_ENUM.ROOT_PASSWORD);
        }

        public String toString() {
            return "[" + Arrays.stream(this.getClass().getDeclaredFields()).map(field -> {
                Object value;
                String result = field.getName() + ": ";
                try {
                    field.setAccessible(true);
                    value = field.get(this);
                }
                catch (Exception ex) {
                    value = "Error!";
                }
                return result + value;
            }).collect(Collectors.joining(", ")) + "]";
        }
    }
}

