/*
 * Decompiled with CFR 0.152.
 */
package tigase.mongodb.archive;

import com.mongodb.client.MongoCollection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Optional;
import org.bson.Document;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.ClassRule;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.MethodSorters;
import org.junit.runners.model.Statement;
import tigase.archive.QueryCriteria;
import tigase.archive.db.AbstractMessageArchiveRepositoryTest;
import tigase.archive.db.MessageArchiveRepository;
import tigase.component.exceptions.RepositoryException;
import tigase.db.util.RepositoryVersionAware;
import tigase.mongodb.MongoDataSource;
import tigase.util.Version;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;
import tigase.xmpp.mam.Query;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class MongoMessageArchiveRepositoryTest
extends AbstractMessageArchiveRepositoryTest<MongoDataSource, MessageArchiveRepository<QueryCriteria, MongoDataSource>> {
    protected static String uri = System.getProperty("testDbUri");
    @ClassRule
    public static TestRule rule = new TestRule(){

        public Statement apply(Statement stmnt, Description d) {
            if (uri == null) {
                return new Statement(){

                    public void evaluate() throws Throwable {
                        Assume.assumeTrue((String)"Ignored due to not passed DB URI!", (boolean)false);
                    }
                };
            }
            return stmnt;
        }
    };

    private byte[] generateId(String in) throws RepositoryException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            return md.digest(in.getBytes());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RepositoryException("Should not happen!!", (Throwable)ex);
        }
    }

    private MongoCollection<Document> getCollection(String name) {
        return ((MongoDataSource)this.getDataSource()).getDatabase().getCollection(name);
    }

    @Test
    public void testSchemaUpgrade_JidComparison() throws Exception {
        Date start = new Date();
        MongoCollection<Document> msgsCollection = this.getCollection("tig_ma_msgs");
        BareJID ownerJid = BareJID.bareJIDInstance((String)"TeSt1@example.com");
        JID buddyJid = JID.jidInstance((String)"TeSt12X@example.com");
        String owner = ownerJid.toString();
        String buddy = buddyJid.getBareJID().toString();
        byte[] oid = this.generateId(owner);
        byte[] bid = this.generateId(buddy);
        byte[] odid = this.generateId(ownerJid.getDomain());
        String type = "chat";
        Date timestamp = new Date();
        Date date = new Date(timestamp.getTime() - timestamp.getTime() % 86400000L);
        byte[] hash = "hash-dummy".getBytes();
        Document dto = new Document("owner", (Object)owner).append("owner_id", (Object)oid).append("owner_domain_id", (Object)odid).append("buddy", (Object)buddy).append("buddy_id", (Object)bid).append("buddy_res", (Object)buddyJid.getResource()).append("date", (Object)date).append("direction", (Object)MessageArchiveRepository.Direction.incoming.name()).append("ts", (Object)timestamp).append("type", (Object)type).append("msg", (Object)("<message from='" + buddyJid.toString() + "' to='" + ownerJid.toString() + "' type='chat'><body>Test body</body></message>")).append("hash", (Object)hash);
        msgsCollection.insertOne((Object)dto);
        QueryCriteria crit = (QueryCriteria)this.repo.newQuery();
        crit.setUseMessageIdInRsm(false);
        crit.setQuestionerJID(JID.jidInstance((String)owner));
        crit.setWith(buddyJid.copyWithoutResource());
        ArrayList msgs = new ArrayList();
        this.repo.queryItems((Query)crit, (qc, item) -> {
            item.getMessage().setName(((MessageArchiveRepository.Item)item).getDirection().toElementName());
            msgs.add(item.getMessage());
            if (qc.getRsm().getFirst() == null) {
                qc.getRsm().setFirst(item.getId());
            }
            qc.getRsm().setLast(item.getId());
        });
        Assert.assertEquals((String)"Incorrect number of message", (long)0L, (long)msgs.size());
        msgs.clear();
        ((RepositoryVersionAware)this.repo).updateSchema(Optional.of(Version.ZERO), Version.ZERO);
        this.repo.queryItems((Query)crit, (qc, item) -> {
            item.getMessage().setName(((MessageArchiveRepository.Item)item).getDirection().toElementName());
            msgs.add(item.getMessage());
            if (qc.getRsm().getFirst() == null) {
                qc.getRsm().setFirst(item.getId());
            }
            qc.getRsm().setLast(item.getId());
        });
        Assert.assertEquals((String)"Incorrect number of message", (long)1L, (long)msgs.size());
        this.repo.removeItems(ownerJid, buddyJid.getBareJID().toString(), start, new Date());
    }
}

