/*
 * Decompiled with CFR 0.152.
 */
package tigase.mongodb.stats;

import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;
import tigase.component.exceptions.RepositoryException;
import tigase.db.Repository;
import tigase.mongodb.Helper;
import tigase.mongodb.MongoDataSource;
import tigase.stats.db.CounterDataLoggerRepositoryIfc;

@Repository.Meta(supportedUris={"mongodb:.*"})
public class CounterDataLoggerMongo
implements CounterDataLoggerRepositoryIfc<MongoDataSource> {
    private static final Logger log = Logger.getLogger(CounterDataLoggerMongo.class.getName());
    private MongoDatabase db;
    private MongoCollection<Document> tigaseStatsLogCollection;

    public void addStatsLogEntry(String hostname, float cpu_usage, float mem_usage, long uptime, int vhosts, long sm_packets, long muc_packets, long pubsub_packets, long c2s_packets, long ws2s_packets, long s2s_packets, long ext_packets, long presences, long messages, long iqs, long registered, int c2s_conns, int ws2s_conns, int bosh_conns, int s2s_conns, int sm_sessions, int sm_connections) {
        try {
            Document dto = new Document().append("ts", (Object)new Date()).append("hostname", (Object)hostname).append("cpu_usage", (Object)Float.valueOf(cpu_usage)).append("mem_usage", (Object)Float.valueOf(mem_usage)).append("uptime", (Object)uptime).append("vhosts", (Object)vhosts).append("sm_packets", (Object)sm_packets).append("muc_packets", (Object)muc_packets).append("pubsub_packets", (Object)pubsub_packets).append("c2s_packets", (Object)c2s_packets).append("ws2s_packets", (Object)ws2s_packets).append("s2s_packets", (Object)s2s_packets).append("ext_packets", (Object)ext_packets).append("presences", (Object)presences).append("messages", (Object)messages).append("iqs", (Object)iqs).append("registered", (Object)registered).append("c2s_conns", (Object)c2s_conns).append("ws2s_conns", (Object)ws2s_conns).append("bosh_conns", (Object)bosh_conns).append("s2s_conns", (Object)s2s_conns).append("sm_connections", (Object)sm_connections).append("sm_sessions", (Object)sm_sessions);
            this.tigaseStatsLogCollection.insertOne((Object)dto);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Problem setting element to DB: ", ex);
        }
    }

    public void setDataSource(MongoDataSource dataSource) throws RepositoryException {
        this.db = dataSource.getDatabase();
        if (!Helper.collectionExists(this.db, "tig_stats_log")) {
            this.db.createCollection("tig_stats_log");
        }
        this.tigaseStatsLogCollection = this.db.getCollection("tig_stats_log");
        this.tigaseStatsLogCollection.createIndex((Bson)new BasicDBObject("hostname", (Object)1));
    }
}

