/*
 * Decompiled with CFR 0.152.
 */
package tigase.mongodb.pubsub;

import com.mongodb.MongoException;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.model.UpdateOptions;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.Binary;
import org.bson.types.ObjectId;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.db.Repository;
import tigase.db.util.RepositoryVersionAware;
import tigase.db.util.SchemaLoader;
import tigase.kernel.beans.config.ConfigField;
import tigase.mongodb.Helper;
import tigase.mongodb.MongoDataSource;
import tigase.mongodb.MongoRepositoryVersionAware;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.Affiliation;
import tigase.pubsub.CollectionItemsOrdering;
import tigase.pubsub.NodeType;
import tigase.pubsub.Subscription;
import tigase.pubsub.repository.IItems;
import tigase.pubsub.repository.INodeMeta;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.NodeAffiliations;
import tigase.pubsub.repository.PubSubDAO;
import tigase.pubsub.repository.cached.NodeSubscriptions;
import tigase.pubsub.repository.stateless.NodeMeta;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.util.Version;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.mam.MAMRepository;
import tigase.xmpp.mam.Query;

@Repository.Meta(supportedUris={"mongodb:.*"})
@Repository.SchemaId(id="pubsub", name="Tigase PubSub Component", external=false)
@RepositoryVersionAware.SchemaVersion
public class PubSubDAOMongo
extends PubSubDAO<ObjectId, MongoDataSource, tigase.pubsub.modules.mam.Query>
implements MongoRepositoryVersionAware {
    public static final String PUBSUB_AFFILIATIONS = "tig_pubsub_affiliations";
    public static final String PUBSUB_ITEMS = "tig_pubsub_items";
    public static final String PUBSUB_NODES = "tig_pubsub_nodes";
    public static final String PUBSUB_SERVICE_JIDS = "tig_pubsub_service_jids";
    public static final String PUBSUB_SUBSCRIPTIONS = "tig_pubsub_subscriptions";
    private static final String JID_HASH_ALG = "SHA-256";
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final int DEF_BATCH_SIZE = 100;
    private MongoCollection<Document> affiliationsCollection;
    @ConfigField(desc="Batch size", alias="batch-size")
    private int batchSize = 100;
    private MongoDatabase db;
    private MongoCollection<Document> itemsCollecton;
    private MongoCollection<Document> nodesCollection;
    private MongoCollection<Document> serviceJidsCollection;
    private MongoCollection<Document> subscriptionsCollection;

    public void addToRootCollection(BareJID serviceJid, String nodeName) throws RepositoryException {
    }

    private byte[] calculateHash(String in) throws RepositoryException {
        try {
            MessageDigest md = MessageDigest.getInstance(JID_HASH_ALG);
            return md.digest(in.getBytes(UTF8));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RepositoryException("Should not happen!!", (Throwable)ex);
        }
    }

    private Document createCrit(BareJID serviceJid, String nodeName) throws RepositoryException {
        byte[] serviceJidId = this.generateId(serviceJid);
        Document crit = new Document("service_jid_id", (Object)serviceJidId);
        if (nodeName != null) {
            byte[] nodeNameId = this.calculateHash(nodeName);
            crit.append("node_name_id", (Object)nodeNameId).append("node_name", (Object)nodeName);
        } else {
            crit.append("node_name", (Object)new Document("$exists", (Object)false));
        }
        return crit;
    }

    public ObjectId createNode(BareJID serviceJid, String nodeName, BareJID ownerJid, AbstractNodeConfig nodeConfig, NodeType nodeType, ObjectId collectionId) throws RepositoryException {
        this.ensureServiceJid(serviceJid);
        try {
            String serializedNodeConfig = null;
            if (nodeConfig != null) {
                nodeConfig.setNodeType(nodeType);
                serializedNodeConfig = nodeConfig.getFormElement().toString();
            }
            Document dto = this.createCrit(serviceJid, nodeName);
            dto.append("service_jid", (Object)serviceJid.toString()).append("owner", (Object)ownerJid.toString()).append("type", (Object)nodeType.name()).append("configuration", (Object)serializedNodeConfig).append("creation_time", (Object)new Date());
            if (collectionId != null) {
                dto.append("collection", (Object)collectionId);
            }
            ObjectId id = new ObjectId();
            dto.append("_id", (Object)id);
            this.nodesCollection.insertOne((Object)dto);
            return id;
        }
        catch (MongoException ex) {
            throw new RepositoryException("Error while adding node to repository", (Throwable)ex);
        }
    }

    public void deleteItem(BareJID serviceJid, ObjectId nodeId, String id) throws RepositoryException {
        try {
            Document crit = new Document("node_id", (Object)nodeId).append("item_id", (Object)id);
            this.itemsCollecton.deleteOne((Bson)crit);
        }
        catch (MongoException ex) {
            throw new RepositoryException("Error while deleting node from repository", (Throwable)ex);
        }
    }

    public void deleteNode(BareJID serviceJid, ObjectId nodeId) throws RepositoryException {
        try {
            Document crit = new Document("node_id", (Object)nodeId);
            this.itemsCollecton.deleteMany((Bson)crit);
            this.affiliationsCollection.deleteMany((Bson)crit);
            this.subscriptionsCollection.deleteMany((Bson)crit);
            this.nodesCollection.deleteOne((Bson)new Document("_id", (Object)nodeId));
        }
        catch (MongoException ex) {
            throw new RepositoryException("Could not retrieve node id", (Throwable)ex);
        }
    }

    private void ensureServiceJid(BareJID serviceJid) throws RepositoryException {
        byte[] id = this.generateId(serviceJid);
        try {
            Document crit = new Document("_id", (Object)id).append("service_jid", (Object)serviceJid.toString());
            this.serviceJidsCollection.updateOne((Bson)crit, (Bson)new Document("$set", (Object)crit), new UpdateOptions().upsert(true));
        }
        catch (MongoException ex) {
            throw new RepositoryException("Could not create entry for service jid " + serviceJid, (Throwable)ex);
        }
    }

    private byte[] generateId(BareJID jid) throws RepositoryException {
        return this.calculateHash(jid.toString().toLowerCase());
    }

    public String[] getAllNodesList(BareJID serviceJid) throws RepositoryException {
        try {
            byte[] serviceJidId = this.generateId(serviceJid);
            Document crit = new Document("service_jid_id", (Object)serviceJidId);
            List<String> result = this.readAllValuesForField(this.nodesCollection, "node_name", (Bson)crit);
            return result.toArray(new String[result.size()]);
        }
        catch (MongoException ex) {
            throw new RepositoryException("Could not retrieve list of all nodes", (Throwable)ex);
        }
    }

    public String[] getChildNodes(BareJID serviceJid, String nodeName) throws RepositoryException {
        return this.getNodesList(serviceJid, nodeName);
    }

    public Element getItem(BareJID serviceJid, ObjectId nodeId, String id) throws RepositoryException {
        try {
            Document crit = new Document("node_id", (Object)nodeId).append("item_id", (Object)id);
            Document dto = (Document)this.itemsCollecton.find((Bson)crit).first();
            if (dto == null) {
                return null;
            }
            return this.itemDataToElement(((String)dto.get((Object)"item")).toCharArray());
        }
        catch (MongoException ex) {
            throw new RepositoryException("Error while retrieving item from repository", (Throwable)ex);
        }
    }

    public Date getItemCreationDate(BareJID serviceJid, ObjectId nodeId, String id) throws RepositoryException {
        try {
            Document crit = new Document("node_id", (Object)nodeId).append("item_id", (Object)id);
            Document dto = (Document)this.itemsCollecton.find((Bson)crit).projection((Bson)new Document("creation_date", (Object)1)).first();
            if (dto == null) {
                return null;
            }
            return (Date)dto.get((Object)"creation_date");
        }
        catch (MongoException ex) {
            throw new RepositoryException("Error while retrieving item creation date from repository", (Throwable)ex);
        }
    }

    private Long getItemPosition(String msgId, Bson filter, String timestampField) throws ComponentException {
        if (msgId == null) {
            return null;
        }
        ObjectId id = new ObjectId(msgId);
        Document doc = (Document)this.itemsCollecton.find(Filters.eq((String)"_id", (Object)id)).projection(Projections.include((String[])new String[]{timestampField})).first();
        if (doc == null) {
            throw new ComponentException(Authorization.ITEM_NOT_FOUND, "Not found item with id = " + msgId);
        }
        Date ts = doc.getDate((Object)timestampField);
        return this.itemsCollecton.count(Filters.and((Bson[])new Bson[]{filter, Filters.lt((String)timestampField, (Object)ts)}));
    }

    public Date getItemUpdateDate(BareJID serviceJid, ObjectId nodeId, String id) throws RepositoryException {
        try {
            Document crit = new Document("node_id", (Object)nodeId).append("item_id", (Object)id);
            Document dto = (Document)this.itemsCollecton.find((Bson)crit).projection((Bson)new Document("update_date", (Object)1)).first();
            if (dto == null) {
                return null;
            }
            return (Date)dto.get((Object)"update_date");
        }
        catch (MongoException ex) {
            throw new RepositoryException("Error while retrieving item update date from repository", (Throwable)ex);
        }
    }

    public String[] getItemsIds(BareJID serviceJid, ObjectId nodeId, CollectionItemsOrdering order) throws RepositoryException {
        try {
            Bson filter = Filters.eq((String)"node_id", (Object)nodeId);
            Bson sort = Sorts.ascending((String[])new String[]{order == CollectionItemsOrdering.byCreationDate ? "creation_date" : "update_date"});
            List<String> ids = this.readAllValuesForField(this.itemsCollecton, "item_id", filter, sort);
            return ids.toArray(new String[ids.size()]);
        }
        catch (MongoException ex) {
            throw new RepositoryException("Error while retrieving item ids from repository", (Throwable)ex);
        }
    }

    public String[] getItemsIdsSince(BareJID serviceJid, ObjectId nodeId, CollectionItemsOrdering order, Date since) throws RepositoryException {
        try {
            String orderField = order == CollectionItemsOrdering.byCreationDate ? "creation_date" : "update_date";
            Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"node_id", (Object)nodeId), Filters.gte((String)orderField, (Object)since)});
            Bson sort = Sorts.ascending((String[])new String[]{orderField});
            List<String> ids = this.readAllValuesForField(this.itemsCollecton, "item_id", filter, sort);
            return ids.toArray(new String[ids.size()]);
        }
        catch (MongoException ex) {
            throw new RepositoryException("Error while retrieving item ids since timestamp from repository", (Throwable)ex);
        }
    }

    public List<IItems.ItemMeta> getItemsMeta(BareJID serviceJid, ObjectId nodeId, String nodeName) throws RepositoryException {
        try {
            Document crit = new Document("node_id", (Object)nodeId);
            FindIterable cursor = this.itemsCollecton.find((Bson)crit).projection((Bson)new Document("item_id", (Object)1).append("creation_date", (Object)1));
            ArrayList<IItems.ItemMeta> results = new ArrayList<IItems.ItemMeta>();
            for (Document it : cursor) {
                results.add(new IItems.ItemMeta(nodeName, (String)it.get((Object)"item_id"), (Date)it.get((Object)"creation_date")));
            }
            return results;
        }
        catch (MongoException ex) {
            throw new RepositoryException("Error while retrieving item ids from repository", (Throwable)ex);
        }
    }

    public NodeAffiliations getNodeAffiliations(BareJID serviceJid, ObjectId nodeId) throws RepositoryException {
        try {
            Document crit = new Document("node_id", (Object)nodeId);
            FindIterable cursor = this.affiliationsCollection.find((Bson)crit).projection((Bson)new Document("jid", (Object)1).append("affiliation", (Object)1)).batchSize(this.batchSize);
            ArrayDeque<UsersAffiliation> data = new ArrayDeque<UsersAffiliation>();
            for (Document it : cursor) {
                BareJID jid = BareJID.bareJIDInstanceNS((String)((String)it.get((Object)"jid")));
                Affiliation affil = Affiliation.valueOf((String)((String)it.get((Object)"affiliation")));
                data.offer(new UsersAffiliation(jid, affil));
            }
            return NodeAffiliations.create(data);
        }
        catch (MongoException ex) {
            throw new RepositoryException("Could not retrieve node affiliations", (Throwable)ex);
        }
    }

    public String getNodeConfig(BareJID serviceJid, ObjectId nodeId) throws RepositoryException {
        try {
            Document crit = new Document("_id", (Object)nodeId);
            Document result = (Document)this.nodesCollection.find((Bson)crit).first();
            return result == null ? null : (String)result.get((Object)"configuration");
        }
        catch (MongoException ex) {
            throw new RepositoryException("Could not retrieve node configuration", (Throwable)ex);
        }
    }

    public ObjectId getNodeId(BareJID serviceJid, String nodeName) throws RepositoryException {
        try {
            Document crit = this.createCrit(serviceJid, nodeName);
            Document result = (Document)this.nodesCollection.find((Bson)crit).first();
            return result == null ? null : (ObjectId)result.get((Object)"_id");
        }
        catch (MongoException ex) {
            throw new RepositoryException("Could not retrieve node id", (Throwable)ex);
        }
    }

    public INodeMeta<ObjectId> getNodeMeta(BareJID serviceJid, String nodeName) throws RepositoryException {
        try {
            Document crit = this.createCrit(serviceJid, nodeName);
            Document result = (Document)this.nodesCollection.find((Bson)crit).first();
            if (result == null) {
                return null;
            }
            AbstractNodeConfig nodeConfig = this.parseConfig(nodeName, (String)result.get((Object)"configuration"));
            return new NodeMeta((Object)((ObjectId)result.get((Object)"_id")), nodeConfig, result.get((Object)"owner") != null ? BareJID.bareJIDInstance((String)((String)result.get((Object)"owner"))) : null, (Date)result.get((Object)"creation_time"));
        }
        catch (MongoException | TigaseStringprepException ex) {
            throw new RepositoryException("Could not retrieve node metadata", ex);
        }
    }

    public tigase.pubsub.repository.NodeSubscriptions getNodeSubscriptions(BareJID serviceJid, ObjectId nodeId) throws RepositoryException {
        try {
            Document crit = new Document("node_id", (Object)nodeId);
            FindIterable cursor = this.subscriptionsCollection.find((Bson)crit).projection((Bson)new Document("jid", (Object)1).append("subscription", (Object)1).append("subscription_id", (Object)1)).batchSize(this.batchSize);
            ArrayDeque<UsersSubscription> data = new ArrayDeque<UsersSubscription>();
            for (Document it : cursor) {
                BareJID jid = BareJID.bareJIDInstanceNS((String)((String)it.get((Object)"jid")));
                Subscription subscr = Subscription.valueOf((String)((String)it.get((Object)"subscription")));
                String subscr_id = (String)it.get((Object)"subscription_id");
                data.offer(new UsersSubscription(jid, subscr_id, subscr));
            }
            NodeSubscriptions result = tigase.pubsub.repository.NodeSubscriptions.create();
            result.init(data);
            return result;
        }
        catch (MongoException ex) {
            throw new RepositoryException("Could not retrieve node affiliations", (Throwable)ex);
        }
    }

    public long getNodesCount(BareJID serviceJid) throws RepositoryException {
        try {
            if (serviceJid == null) {
                return this.nodesCollection.count();
            }
            return this.nodesCollection.count((Bson)this.createCrit(serviceJid, null));
        }
        catch (MongoException ex) {
            throw new RepositoryException("Could not count nodes", (Throwable)ex);
        }
    }

    public String[] getNodesList(BareJID serviceJid, String nodeName) throws RepositoryException {
        ObjectId collectionId;
        ObjectId objectId = collectionId = nodeName == null ? null : this.getNodeId(serviceJid, nodeName);
        if (collectionId == null && nodeName != null) {
            return new String[0];
        }
        try {
            byte[] serviceJidId = this.generateId(serviceJid);
            Document crit = new Document("service_jid_id", (Object)serviceJidId);
            if (collectionId != null) {
                crit.append("collection", (Object)collectionId);
            } else {
                crit.append("collection", (Object)new Document("$exists", (Object)false));
            }
            List<String> result = this.readAllValuesForField(this.nodesCollection, "node_name", (Bson)crit);
            return result.toArray(new String[result.size()]);
        }
        catch (MongoException ex) {
            throw new RepositoryException("Could not retrieve list of all nodes", (Throwable)ex);
        }
    }

    public Map<String, UsersAffiliation> getUserAffiliations(BareJID serviceJid, BareJID jid) throws RepositoryException {
        try {
            byte[] serviceJidId = this.generateId(serviceJid);
            byte[] jidId = this.generateId(jid);
            Document crit = new Document("service_jid_id", (Object)serviceJidId).append("jid_id", (Object)jidId);
            FindIterable cursor = this.affiliationsCollection.find((Bson)crit).projection((Bson)new Document("node_name", (Object)1).append("affiliation", (Object)1)).batchSize(this.batchSize);
            HashMap<String, UsersAffiliation> result = new HashMap<String, UsersAffiliation>();
            for (Document it : cursor) {
                String node = (String)it.get((Object)"node_name");
                Affiliation affil = Affiliation.valueOf((String)((String)it.get((Object)"affiliation")));
                result.put(node, new UsersAffiliation(jid, affil));
            }
            return result;
        }
        catch (MongoException ex) {
            throw new RepositoryException("Could not retrieve user affiliations", (Throwable)ex);
        }
    }

    public Map<String, UsersSubscription> getUserSubscriptions(BareJID serviceJid, BareJID jid) throws RepositoryException {
        try {
            byte[] serviceJidId = this.generateId(serviceJid);
            byte[] jidId = this.generateId(jid);
            Document crit = new Document("service_jid_id", (Object)serviceJidId).append("jid_id", (Object)jidId);
            FindIterable cursor = this.subscriptionsCollection.find((Bson)crit).projection((Bson)new Document("node_name", (Object)1).append("subscription", (Object)1).append("subscription_id", (Object)1)).batchSize(this.batchSize);
            HashMap<String, UsersSubscription> result = new HashMap<String, UsersSubscription>();
            for (Document it : cursor) {
                String node = (String)it.get((Object)"node_name");
                Subscription subscr = Subscription.valueOf((String)((String)it.get((Object)"subscription")));
                String subscr_id = (String)it.get((Object)"subscription_id");
                result.put(node, new UsersSubscription(jid, subscr_id, subscr));
            }
            return result;
        }
        catch (MongoException ex) {
            throw new RepositoryException("Could not retrieve user affiliations", (Throwable)ex);
        }
    }

    public void queryItems(tigase.pubsub.modules.mam.Query query, List<ObjectId> nodesIds, MAMRepository.ItemHandler<tigase.pubsub.modules.mam.Query, IPubSubRepository.Item> itemHandler) throws RepositoryException, ComponentException {
        try {
            String timestampField;
            ArrayList<Bson> filters = new ArrayList<Bson>();
            filters.add(Filters.in((String)"node_id", nodesIds));
            String string = timestampField = query.getOrder() == CollectionItemsOrdering.byCreationDate ? "creation_date" : "update_date";
            if (query.getStart() != null) {
                filters.add(Filters.gte((String)timestampField, (Object)query.getStart()));
            }
            if (query.getEnd() != null) {
                filters.add(Filters.lte((String)timestampField, (Object)query.getEnd()));
            }
            if (query.getWith() != null) {
                filters.add(Filters.eq((String)"publisher", (Object)query.getWith().toString()));
            }
            Bson filter = Filters.and(filters);
            long count = this.itemsCollecton.count(filter);
            Long after = this.getItemPosition(query.getRsm().getAfter(), filter, timestampField);
            Long before = this.getItemPosition(query.getRsm().getBefore(), filter, timestampField);
            PubSubDAOMongo.calculateOffsetAndPosition((Query)query, (int)((int)count), (Integer)(before == null ? null : Integer.valueOf(before.intValue())), after == null ? null : Integer.valueOf(after.intValue()));
            HashMap nodeNames = new HashMap();
            this.nodesCollection.find(Filters.in((String)"_id", nodesIds)).projection(Projections.include((String[])new String[]{"node_name"})).forEach(document -> nodeNames.put(document.getObjectId((Object)"_id"), document.getString((Object)"node_name")));
            Document order = new Document(timestampField, (Object)1);
            FindIterable cursor = this.itemsCollecton.find(filter).sort((Bson)order).skip(query.getRsm().getIndex().intValue()).limit(query.getRsm().getMax());
            for (Document dto : cursor) {
                final ObjectId id = dto.getObjectId((Object)"_id");
                ObjectId nodeId = dto.getObjectId((Object)"node_id");
                String nodeName = (String)nodeNames.get(nodeId);
                String itemId = dto.getString((Object)"item_id");
                Date creationDate = dto.getDate((Object)timestampField);
                Element itemEl = this.itemDataToElement(dto.getString((Object)"item"));
                itemHandler.itemFound((Query)query, (MAMRepository.Item)new PubSubDAO.Item(nodeName, nodeId, itemId, creationDate, itemEl){

                    public String getId() {
                        return id.toString();
                    }
                });
            }
        }
        catch (Exception ex) {
            throw new RepositoryException((Throwable)ex);
        }
    }

    protected <T> List<T> readAllValuesForField(MongoCollection<Document> collection, String field, Bson filter) throws MongoException {
        FindIterable cursor = collection.find(filter).projection((Bson)new Document(field, (Object)1)).batchSize(this.batchSize);
        ArrayList<Object> result = new ArrayList<Object>();
        for (Document item : cursor) {
            Object val = item.get((Object)field);
            result.add(val);
        }
        return result;
    }

    protected <T> List<T> readAllValuesForField(MongoCollection<Document> collection, String field, Bson filter, Bson sort) throws MongoException {
        FindIterable cursor = collection.find(filter).sort(sort).projection((Bson)new Document(field, (Object)1)).batchSize(this.batchSize);
        ArrayList<Object> result = new ArrayList<Object>();
        for (Document item : cursor) {
            Object val = item.get((Object)field);
            result.add(val);
        }
        return result;
    }

    public void removeAllFromRootCollection(BareJID serviceJid) throws RepositoryException {
        try {
            byte[] serviceJidId = this.generateId(serviceJid);
            Document crit = new Document("service_jid_id", (Object)serviceJidId);
            this.itemsCollecton.deleteMany((Bson)crit);
            this.affiliationsCollection.deleteMany((Bson)crit);
            this.subscriptionsCollection.deleteMany((Bson)crit);
            crit = new Document("service_jid_id", (Object)serviceJidId);
            this.nodesCollection.deleteMany((Bson)crit);
        }
        catch (MongoException ex) {
            throw new RepositoryException("Could not remove all nodes from root collection", (Throwable)ex);
        }
    }

    public void removeFromRootCollection(BareJID serviceJid, ObjectId nodeId) throws RepositoryException {
    }

    public void removeNodeSubscription(BareJID serviceJid, ObjectId nodeId, BareJID jid) throws RepositoryException {
        try {
            byte[] serviceJidId = this.generateId(serviceJid);
            byte[] jidId = this.generateId(jid);
            Document crit = new Document("node_id", (Object)nodeId).append("service_jid_id", (Object)serviceJidId).append("jid_id", (Object)jidId);
            this.subscriptionsCollection.deleteMany((Bson)crit);
        }
        catch (MongoException ex) {
            throw new RepositoryException("Could not remove user subscriptions", (Throwable)ex);
        }
    }

    public void removeService(BareJID serviceJid) throws RepositoryException {
        try {
            this.removeAllFromRootCollection(serviceJid);
            byte[] jidId = this.generateId(serviceJid);
            this.serviceJidsCollection.deleteOne((Bson)new Document("_id", (Object)jidId));
            Document crit = new Document("jid_id", (Object)jidId);
            this.affiliationsCollection.deleteMany((Bson)crit);
            this.subscriptionsCollection.deleteMany((Bson)crit);
        }
        catch (MongoException ex) {
            throw new RepositoryException("Could not remove service with jid = " + serviceJid, (Throwable)ex);
        }
    }

    public void setDataSource(MongoDataSource dataSource) {
        this.db = dataSource.getDatabase();
        if (!Helper.collectionExists(this.db, PUBSUB_SERVICE_JIDS)) {
            this.db.createCollection(PUBSUB_SERVICE_JIDS);
        }
        this.serviceJidsCollection = this.db.getCollection(PUBSUB_SERVICE_JIDS);
        Helper.indexCreateOrReplace(this.serviceJidsCollection, new Document("service_jid", (Object)1), new IndexOptions().unique(true));
        if (!Helper.collectionExists(this.db, PUBSUB_NODES)) {
            this.db.createCollection(PUBSUB_NODES);
        }
        this.nodesCollection = this.db.getCollection(PUBSUB_NODES);
        this.nodesCollection.createIndex((Bson)new Document("service_jid_id", (Object)1).append("node_name_id", (Object)1), new IndexOptions().unique(true));
        this.nodesCollection.createIndex((Bson)new Document("service_jid_id", (Object)1).append("node_name_id", (Object)1).append("collection", (Object)1), new IndexOptions().unique(true));
        this.nodesCollection.createIndex((Bson)new Document("collection", (Object)1));
        if (!Helper.collectionExists(this.db, PUBSUB_AFFILIATIONS)) {
            this.db.createCollection(PUBSUB_AFFILIATIONS);
        }
        this.affiliationsCollection = this.db.getCollection(PUBSUB_AFFILIATIONS);
        this.affiliationsCollection.createIndex((Bson)new Document("node_id", (Object)1));
        this.affiliationsCollection.createIndex((Bson)new Document("node_id", (Object)1).append("jid_id", (Object)1), new IndexOptions().unique(true));
        if (!Helper.collectionExists(this.db, PUBSUB_SUBSCRIPTIONS)) {
            this.db.createCollection(PUBSUB_SUBSCRIPTIONS);
        }
        this.subscriptionsCollection = this.db.getCollection(PUBSUB_SUBSCRIPTIONS);
        this.subscriptionsCollection.createIndex((Bson)new Document("node_id", (Object)1));
        this.subscriptionsCollection.createIndex((Bson)new Document("node_id", (Object)1).append("jid_id", (Object)1), new IndexOptions().unique(true));
        if (!Helper.collectionExists(this.db, PUBSUB_ITEMS)) {
            this.db.createCollection(PUBSUB_ITEMS);
        }
        this.itemsCollecton = this.db.getCollection(PUBSUB_ITEMS);
        this.itemsCollecton.createIndex((Bson)new Document("node_id", (Object)1));
        this.itemsCollecton.createIndex((Bson)new Document("node_id", (Object)1).append("item_id", (Object)1), new IndexOptions().unique(true));
        this.itemsCollecton.createIndex((Bson)new Document("node_id", (Object)1).append("creation_date", (Object)1));
    }

    public void updateNodeAffiliation(BareJID serviceJid, ObjectId nodeId, String nodeName, UsersAffiliation userAffiliation) throws RepositoryException {
        try {
            byte[] serviceJidId = this.generateId(serviceJid);
            byte[] jidId = this.generateId(userAffiliation.getJid());
            Document crit = new Document("node_id", (Object)nodeId).append("service_jid_id", (Object)serviceJidId).append("jid_id", (Object)jidId);
            if (userAffiliation.getAffiliation() == Affiliation.none) {
                this.affiliationsCollection.deleteMany((Bson)crit);
            } else {
                this.affiliationsCollection.updateOne((Bson)crit, (Bson)new Document("$setOnInsert", (Object)new Document("node_name", (Object)nodeName)).append("$set", (Object)new Document("affiliation", (Object)userAffiliation.getAffiliation().name()).append("service_jid", (Object)serviceJid.toString()).append("jid", (Object)userAffiliation.getJid().toString())), new UpdateOptions().upsert(true));
            }
        }
        catch (MongoException ex) {
            throw new RepositoryException("Could not update user affiliations", (Throwable)ex);
        }
    }

    public void updateNodeConfig(BareJID serviceJid, ObjectId nodeId, String serializedNodeConfig, ObjectId collectionId) throws RepositoryException {
        try {
            Document crit = new Document("_id", (Object)nodeId);
            Document set = new Document("configuration", (Object)serializedNodeConfig);
            Document dto = new Document("$set", (Object)set);
            if (collectionId != null) {
                set.append("collection", (Object)collectionId);
            } else {
                dto.append("$unset", (Object)new Document("collection", (Object)""));
            }
            this.nodesCollection.updateOne((Bson)crit, (Bson)dto);
        }
        catch (MongoException ex) {
            throw new RepositoryException("Error while updating node configuration in repository", (Throwable)ex);
        }
    }

    public void updateNodeSubscription(BareJID serviceJid, ObjectId nodeId, String nodeName, UsersSubscription userSubscription) throws RepositoryException {
        try {
            byte[] serviceJidId = this.generateId(serviceJid);
            byte[] jidId = this.generateId(userSubscription.getJid());
            Document crit = new Document("node_id", (Object)nodeId).append("service_jid_id", (Object)serviceJidId).append("jid_id", (Object)jidId);
            if (userSubscription.getSubscription() == Subscription.none) {
                this.subscriptionsCollection.deleteMany((Bson)crit);
            } else {
                this.subscriptionsCollection.updateOne((Bson)crit, (Bson)new Document("$setOnInsert", (Object)new Document("node_name", (Object)nodeName)).append("$set", (Object)new Document("subscription", (Object)userSubscription.getSubscription().name()).append("subscription_id", (Object)userSubscription.getSubid()).append("service_jid", (Object)serviceJid.toString()).append("jid", (Object)userSubscription.getJid().toString())), new UpdateOptions().upsert(true));
            }
        }
        catch (MongoException ex) {
            throw new RepositoryException("Could not update user subscriptions", (Throwable)ex);
        }
    }

    public SchemaLoader.Result updateSchema(Optional<Version> oldVersion, Version newVersion) throws RepositoryException {
        Document update;
        byte[] newJidId;
        byte[] oldJidId;
        String jid;
        for (Document oldServiceDoc : this.serviceJidsCollection.find().batchSize(100)) {
            byte[] newServiceId;
            String serviceJid = (String)oldServiceDoc.get((Object)"service_jid");
            byte[] oldServiceId = ((Binary)oldServiceDoc.get((Object)"_id")).getData();
            if (Arrays.equals(oldServiceId, newServiceId = this.calculateHash(serviceJid.toLowerCase()))) continue;
            Document updateQuery = new Document("service_jid_id", (Object)oldServiceId);
            Document updateValues = new Document("service_jid_id", (Object)newServiceId);
            Arrays.asList(this.nodesCollection, this.itemsCollecton, this.subscriptionsCollection, this.affiliationsCollection).forEach(col -> col.updateMany((Bson)updateQuery, (Bson)new Document("$set", (Object)updateValues)));
            Document newServiceDoc = new Document((Map)oldServiceDoc).append("_id", (Object)newServiceId);
            this.serviceJidsCollection.findOneAndDelete((Bson)oldServiceDoc);
            this.serviceJidsCollection.insertOne((Object)newServiceDoc);
        }
        for (Document oldAffil : this.affiliationsCollection.find().projection(Projections.include((String[])new String[]{"jid", "jid_id"})).batchSize(1000)) {
            jid = (String)oldAffil.get((Object)"jid");
            oldJidId = ((Binary)oldAffil.get((Object)"jid_id")).getData();
            if (Arrays.equals(oldJidId, newJidId = this.calculateHash(jid.toLowerCase()))) continue;
            update = new Document("jid_id", (Object)newJidId);
            this.affiliationsCollection.updateOne((Bson)oldAffil, (Bson)new Document("$set", (Object)update));
        }
        for (Document oldSubs : this.subscriptionsCollection.find().projection(Projections.include((String[])new String[]{"jid", "jid_id"})).batchSize(1000)) {
            jid = (String)oldSubs.get((Object)"jid");
            oldJidId = ((Binary)oldSubs.get((Object)"jid_id")).getData();
            if (Arrays.equals(oldJidId, newJidId = this.calculateHash(jid.toLowerCase()))) continue;
            update = new Document("jid_id", (Object)newJidId);
            this.subscriptionsCollection.updateOne((Bson)oldSubs, (Bson)new Document("$set", (Object)update));
        }
        return SchemaLoader.Result.ok;
    }

    public void writeItem(BareJID serviceJid, ObjectId nodeId, long timeInMilis, String id, String publisher, Element item) throws RepositoryException {
        try {
            byte[] serviceJidId = this.generateId(serviceJid);
            Document crit = new Document("service_jid_id", (Object)serviceJidId).append("service_jid", (Object)serviceJid.toString());
            crit.append("node_id", (Object)nodeId).append("item_id", (Object)id);
            Document dto = new Document("$set", (Object)new Document("update_date", (Object)new Date()).append("publisher", (Object)publisher).append("item", (Object)item.toString()));
            dto.append("$setOnInsert", (Object)new Document("creation_date", (Object)new Date()));
            this.itemsCollecton.updateOne((Bson)crit, (Bson)dto, new UpdateOptions().upsert(true));
        }
        catch (MongoException ex) {
            throw new RepositoryException("Could not write item to repository", (Throwable)ex);
        }
    }
}

