/*
 * Decompiled with CFR 0.152.
 */
package tigase.mongodb;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ShaTest {
    public static void main(String[] argc) {
        String[] algs = new String[]{"SHA1", "SHA-256", "SHA-512"};
        int[] sizes = new int[]{10, 20, 50, 100, 1000, 2000};
        for (int i = 0; i < sizes.length; ++i) {
            for (String alg : algs) {
                ShaTest.test(alg, 1000000, sizes[i]);
            }
        }
    }

    public static void test(String alg, int tries, int size) {
        String test = new String();
        for (int i = 0; i < size; ++i) {
            test = test + (char)i;
        }
        long start = System.currentTimeMillis();
        for (int i = 0; i < tries; ++i) {
            try {
                MessageDigest md = MessageDigest.getInstance(alg);
                byte[] byArray = md.digest(test.getBytes());
                continue;
            }
            catch (NoSuchAlgorithmException ex) {
                Logger.getLogger(ShaTest.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        long end = System.currentTimeMillis();
        System.out.println(alg + " " + tries + " for " + size + " in " + (end - start) + "ms");
    }
}

