/*
 * Decompiled with CFR 0.152.
 */
package tigase.mongodb;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoException;
import com.mongodb.client.MongoDatabase;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;
import tigase.db.DBInitException;
import tigase.db.DataSource;
import tigase.db.Repository;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.util.Version;

@Repository.Meta(isDefault=true, supportedUris={"mongodb:.*"})
public class MongoDataSource
implements DataSource,
UnregisterAware {
    private static final Logger log = Logger.getLogger(MongoDataSource.class.getName());
    @ConfigField(desc="Automatic schema management", alias="schema-management")
    private boolean automaticSchemaManagement = true;
    private MongoDatabase db;
    private MongoClient mongo;
    private String resourceUri;

    public boolean automaticSchemaManagement() {
        return this.automaticSchemaManagement;
    }

    public void beforeUnregister() {
        this.mongo.close();
    }

    public MongoDatabase getDatabase() {
        return this.db;
    }

    public String getResourceUri() {
        return this.resourceUri;
    }

    public Optional<Version> getSchemaVersion(String component) {
        if (component == null || component.isEmpty()) {
            log.log(Level.WARNING, "Wrong component name passed: " + component);
            return Optional.empty();
        }
        try {
            MongoDatabase db = this.getDatabase();
            if (db != null) {
                Document crit = new Document("_id", (Object)component);
                Document version = (Document)db.getCollection("tig_schema_versions").find((Bson)new Document((Map)crit)).first();
                if (version != null && version.get((Object)"version") != null) {
                    return Optional.of(Version.of((String)((String)version.get((Object)"version"))));
                }
            }
        }
        catch (MongoException ex) {
            log.log(Level.WARNING, ex.getMessage());
        }
        return Optional.empty();
    }

    @Deprecated
    public void initRepository(String resource_uri, Map<String, String> params) throws DBInitException {
        this.initialize(resource_uri);
    }

    public void initialize(String resource_uri) throws DBInitException {
        this.resourceUri = resource_uri;
        MongoClientURI uri = new MongoClientURI(resource_uri);
        this.mongo = new MongoClient(uri);
        this.db = this.mongo.getDatabase(uri.getDatabase());
    }
}

