/*
 * Decompiled with CFR 0.152.
 */
package tigase.mongodb.pubsub;

import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import tigase.component.exceptions.RepositoryException;
import tigase.db.util.RepositoryVersionAware;
import tigase.mongodb.MongoDataSource;
import tigase.pubsub.Affiliation;
import tigase.pubsub.NodeType;
import tigase.pubsub.Subscription;
import tigase.pubsub.repository.AbstractPubSubDAOTest;
import tigase.pubsub.repository.INodeMeta;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.util.Version;
import tigase.xmpp.jid.BareJID;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class PubSubDAOMongoTest
extends AbstractPubSubDAOTest<MongoDataSource> {
    private byte[] generateId(String in) throws RepositoryException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            return md.digest(in.getBytes());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RepositoryException("Should not happen!!", (Throwable)ex);
        }
    }

    protected MongoDatabase getDatabase() {
        return ((MongoDataSource)this.getDataSource()).getDatabase();
    }

    protected String getMAMID(Object nodeId, String itemId) {
        Document dto = (Document)this.getDatabase().getCollection("tig_pubsub_items").find(Filters.and((Bson[])new Bson[]{Filters.eq((String)"node_id", (Object)nodeId), Filters.eq((String)"item_id", (Object)itemId)})).first();
        return dto.getObjectId((Object)"_id").toString();
    }

    @Test
    public void testSchemaUpgrade_JidComparison() throws Exception {
        BareJID serviceJid = BareJID.bareJIDInstance((String)"TeSt@example.com");
        byte[] serviceJidId = this.generateId(serviceJid.toString());
        this.getDatabase().getCollection("tig_pubsub_service_jids").insertOne((Object)new Document("_id", (Object)serviceJidId).append("service_jid", (Object)serviceJid.toString()));
        String nodeName = "test-node-" + UUID.randomUUID().toString();
        byte[] nodeNameId = this.generateId(nodeName);
        ObjectId nodeId = new ObjectId();
        this.getDatabase().getCollection("tig_pubsub_nodes").insertOne((Object)new Document("_id", (Object)nodeId).append("service_jid_id", (Object)serviceJidId).append("service_jid", (Object)serviceJid.toString()).append("node_name_id", (Object)nodeNameId).append("node_name", (Object)nodeName).append("owner", (Object)serviceJid.toString()).append("type", (Object)NodeType.leaf.name()).append("creation_time", (Object)new Date()));
        String itemId = UUID.randomUUID().toString();
        this.getDatabase().getCollection("tig_pubsub_items").insertOne((Object)new Document("service_jid_id", (Object)serviceJidId).append("service_jid", (Object)serviceJid.toString()).append("node_id", (Object)nodeId).append("item_id", (Object)itemId).append("update_date", (Object)new Date()).append("publisher", (Object)serviceJid.toString()).append("item", (Object)"<dummy-item/>").append("creation_date", (Object)new Date()));
        this.getDatabase().getCollection("tig_pubsub_affiliations").insertOne((Object)new Document("node_id", (Object)nodeId).append("service_jid_id", (Object)serviceJidId).append("service_jid", (Object)serviceJid.toString()).append("jid_id", (Object)serviceJidId).append("jid", (Object)serviceJid.toString()).append("node_name", (Object)nodeName).append("affiliation", (Object)Affiliation.owner.name()));
        this.getDatabase().getCollection("tig_pubsub_subscriptions").insertOne((Object)new Document("node_id", (Object)nodeId).append("service_jid_id", (Object)serviceJidId).append("service_jid", (Object)serviceJid.toString()).append("jid_id", (Object)serviceJidId).append("jid", (Object)serviceJid.toString()).append("node_name", (Object)nodeName).append("subscription", (Object)Subscription.subscribed.name()).append("subscription_id", (Object)UUID.randomUUID().toString()));
        Assert.assertNull((Object)this.dao.getNodeMeta(serviceJid, nodeName));
        ((RepositoryVersionAware)this.dao).updateSchema(Optional.of(Version.ZERO), Version.ZERO);
        Assert.assertNotNull((Object)this.getDatabase().getCollection("tig_pubsub_service_jids").find((Bson)new Document("service_jid", (Object)serviceJid.toString().toLowerCase())));
        INodeMeta meta = this.dao.getNodeMeta(serviceJid, nodeName);
        Assert.assertNotNull((Object)meta);
        Assert.assertEquals((Object)serviceJid.toString(), (Object)meta.getCreator().toString());
        Assert.assertNotNull((Object)this.dao.getItem(serviceJid, meta.getNodeId(), itemId));
        UsersAffiliation affil = this.dao.getNodeAffiliations(serviceJid, meta.getNodeId()).getSubscriberAffiliation(serviceJid);
        Assert.assertNotNull((Object)affil);
        Assert.assertEquals((Object)serviceJid.toString(), (Object)affil.getJid().toString());
        Assert.assertEquals((Object)Subscription.subscribed, (Object)this.dao.getNodeSubscriptions(serviceJid, meta.getNodeId()).getSubscription(serviceJid));
        this.dao.removeService(serviceJid);
    }
}

