/*
 * Decompiled with CFR 0.152.
 */
package tigase.mongodb;

import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import org.bson.Document;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import tigase.db.DBInitException;
import tigase.db.TigaseDBException;
import tigase.mongodb.MongoDataSource;
import tigase.mongodb.MongoRepository;
import tigase.util.Version;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xmpp.jid.BareJID;

public class MongoRepositoryTest {
    protected static String uri = System.getProperty("testDbUri");
    @ClassRule
    public static TestRule rule = new TestRule(){

        public Statement apply(Statement stmnt, Description d) {
            if (uri == null) {
                return new Statement(){

                    public void evaluate() throws Throwable {
                        Assume.assumeTrue((String)"Ignored due to not passed DB URI!", (boolean)false);
                    }
                };
            }
            return stmnt;
        }
    };
    private MongoDataSource dataSource;
    private MongoRepository repo;

    private void prepareUserAutoCreateRepo() throws Exception {
        this.repo.autoCreateUser = true;
    }

    @Before
    public void setup() throws DBInitException {
        this.dataSource = new MongoDataSource();
        this.dataSource.initRepository(uri, new HashMap());
        this.repo = new MongoRepository();
        this.repo.setDataSource(this.dataSource);
    }

    @After
    public void tearDown() throws TigaseDBException {
        this.repo.removeUser(BareJID.bareJIDInstanceNS((String)"test-1@example.com"));
        this.repo = null;
    }

    @Test
    public void testAddDataListUserAutoCreate() throws Exception {
        this.prepareUserAutoCreateRepo();
        BareJID userJID = BareJID.bareJIDInstanceNS((String)"test-1@example.com");
        Object[] data = new String[]{"test1", "test2", "test3"};
        this.repo.addDataList(userJID, "test-node", "test-key", (String[])data);
        Assert.assertTrue((String)"User autocreation failed", (boolean)this.repo.userExists(userJID));
        Assert.assertArrayEquals((Object[])data, (Object[])this.repo.getDataList(userJID, "test-node", "test-key"));
    }

    @Test
    public void testData() throws TigaseStringprepException, TigaseDBException {
        BareJID jid = BareJID.bareJIDInstance((String)"test-1@example.com");
        this.repo.addUser(jid);
        Assert.assertTrue((String)"User creation failed", (boolean)this.repo.userExists(jid));
        this.repo.setData(jid, "key1", "test value 1");
        Object[] keys = this.repo.getKeys(jid);
        Assert.assertArrayEquals((Object[])new String[]{"key1"}, (Object[])keys);
        this.repo.setData(jid, "test/node", "key2", "test value 2");
        keys = this.repo.getKeys(jid);
        Assert.assertArrayEquals((Object[])new String[]{"key1"}, (Object[])keys);
        keys = this.repo.getKeys(jid, "test/node");
        Assert.assertArrayEquals((Object[])new String[]{"key2"}, (Object[])keys);
        this.repo.setDataList(jid, "test/node2", "list", new String[]{"item1", "item2"});
        keys = this.repo.getKeys(jid, "test/node2");
        Assert.assertArrayEquals((Object[])new String[]{"list"}, (Object[])keys);
        Object[] subnodes = this.repo.getSubnodes(jid);
        Assert.assertArrayEquals((Object[])new String[]{"test"}, (Object[])subnodes);
        subnodes = this.repo.getSubnodes(jid, "test");
        Assert.assertArrayEquals((Object[])new String[]{"node", "node2"}, (Object[])subnodes);
        this.repo.setDataList(jid, "test/node3/subnode1", "list", new String[]{"item1", "item2"});
        subnodes = this.repo.getSubnodes(jid, "test/");
        Assert.assertArrayEquals((Object[])new String[]{"node", "node2", "node3"}, (Object[])subnodes);
        this.repo.removeData(jid, "key1");
        keys = this.repo.getKeys(jid);
        Assert.assertArrayEquals((Object[])new String[0], (Object[])keys);
        this.repo.removeData(jid, "test/node", "key2");
        subnodes = this.repo.getSubnodes(jid);
        Assert.assertArrayEquals((Object[])new String[]{"test"}, (Object[])subnodes);
        subnodes = this.repo.getSubnodes(jid, "test");
        Assert.assertArrayEquals((Object[])new String[]{"node2", "node3"}, (Object[])subnodes);
        this.repo.removeData(jid, "test/node2", "list");
        subnodes = this.repo.getSubnodes(jid, "test");
        Assert.assertEquals((Object[])new String[]{"node3"}, (Object[])subnodes);
        this.repo.removeData(jid, "test/node3/subnode1", "list");
        subnodes = this.repo.getSubnodes(jid, "test");
        Assert.assertEquals(null, (Object[])subnodes);
        this.repo.setDataList(jid, "test/node2", "list", new String[]{"item1", "item2"});
        subnodes = this.repo.getSubnodes(jid, "test");
        Assert.assertArrayEquals((Object[])new String[]{"node2"}, (Object[])subnodes);
        this.repo.removeSubnode(jid, "test");
        subnodes = this.repo.getSubnodes(jid, "test");
        Assert.assertEquals(null, (Object[])subnodes);
        this.repo.setDataList(jid, "test/node2", "list", new String[]{"item1", "item2"});
        subnodes = this.repo.getSubnodes(jid, "test");
        Assert.assertArrayEquals((Object[])new String[]{"node2"}, (Object[])subnodes);
        this.repo.removeSubnode(jid, "test/");
        subnodes = this.repo.getSubnodes(jid, "test");
        Assert.assertEquals(null, (Object[])subnodes);
        this.repo.setDataList(jid, "test/node2/", "list", new String[]{"item1", "item2"});
        subnodes = this.repo.getSubnodes(jid, "test");
        Assert.assertArrayEquals((Object[])new String[]{"node2"}, (Object[])subnodes);
        this.repo.removeSubnode(jid, "test");
        subnodes = this.repo.getSubnodes(jid, "test");
        Assert.assertEquals(null, (Object[])subnodes);
        this.repo.removeUser(jid);
        Assert.assertFalse((String)"User removal failed", (boolean)this.repo.userExists(jid));
    }

    @Test
    public void testExeutionTimes() throws Exception {
        BareJID jid = BareJID.bareJIDInstance((String)"test-1@example.com");
        this.repo.addUser(jid);
        int counts = 1000;
        for (int i = 0; i < counts; ++i) {
            this.repo.setData(jid, "rooms/test-" + i + "@test", "creation-date", "date-" + i);
            this.repo.setData(jid, "rooms/test-" + i + "@test", "value", "date-" + i);
        }
        long start = System.currentTimeMillis();
        for (int i = 0; i < counts; ++i) {
            this.repo.removeSubnode(jid, "rooms/test-" + i + "@test");
        }
        long end = System.currentTimeMillis();
        long time = end - start;
        System.out.println("executed in " + time + "ms for " + counts + " " + time / (long)counts + " per execution");
        long timeLimit = counts * 2;
        Assert.assertTrue((String)("Test should be executed in less than " + timeLimit + "ms"), (timeLimit > time ? 1 : 0) != 0);
    }

    @Test
    public void testSchemaUpgrade_JidComparison() throws Exception {
        BareJID jid = BareJID.bareJIDInstance((String)(UUID.randomUUID().toString() + "_TEST"), (String)"example.com");
        byte[] uid = this.repo.calculateHash(jid.toString());
        Document userDoc = new Document("_id", (Object)uid).append("user_id", (Object)jid.toString()).append("domain", (Object)jid.getDomain());
        this.dataSource.getDatabase().getCollection("tig_users").insertOne((Object)userDoc);
        Document nodeDoc = new Document("uid", (Object)uid).append("node", (Object)"test-1").append("key", (Object)"test-2").append("value", (Object)"VALUE");
        this.dataSource.getDatabase().getCollection("tig_nodes").insertOne((Object)nodeDoc);
        Assert.assertNull((Object)this.repo.getData(jid, "test-1", "test-2"));
        this.repo.updateSchema(Optional.of(Version.ZERO), Version.ZERO);
        Assert.assertEquals((Object)"VALUE", (Object)this.repo.getData(jid, "test-1", "test-2"));
        this.repo.removeUser(jid);
    }

    @Test
    public void testSetDataListUserAutoCreate() throws Exception {
        this.prepareUserAutoCreateRepo();
        BareJID userJID = BareJID.bareJIDInstanceNS((String)"test-1@example.com");
        Object[] data = new String[]{"test1", "test2", "test3"};
        this.repo.setDataList(userJID, "test-node", "test-key", (String[])data);
        Assert.assertTrue((String)"User autocreation failed", (boolean)this.repo.userExists(userJID));
        Assert.assertArrayEquals((Object[])data, (Object[])this.repo.getDataList(userJID, "test-node", "test-key"));
    }

    @Test
    public void testSetDataUserAutoCreate() throws Exception {
        this.prepareUserAutoCreateRepo();
        BareJID userJID = BareJID.bareJIDInstanceNS((String)"test-1@example.com");
        String data = "test-data";
        this.repo.setData(userJID, "test-node", "test-key", data);
        Assert.assertTrue((String)"User autocreation failed", (boolean)this.repo.userExists(userJID));
        Assert.assertEquals((Object)data, (Object)this.repo.getData(userJID, "test-node", "test-key"));
    }

    @Test
    public void testUser() throws TigaseStringprepException, TigaseDBException {
        BareJID jid = BareJID.bareJIDInstance((String)"test-1@example.com");
        this.repo.addUser(jid);
        Assert.assertTrue((String)"User creation failed", (boolean)this.repo.userExists(jid));
        Assert.assertEquals((long)1L, (long)this.repo.getUsersCount("example.com"));
        Assert.assertEquals((long)0L, (long)this.repo.getUsersCount("test.com"));
        Assert.assertEquals((long)1L, (long)this.repo.getUsersCount());
        Assert.assertEquals((Object)jid, this.repo.getUsers().get(0));
        this.repo.removeUser(jid);
        Assert.assertFalse((String)"User removal failed", (boolean)this.repo.userExists(jid));
        this.repo.addUser(jid, "password");
        Assert.assertTrue((String)"User creation failed", (boolean)this.repo.userExists(jid));
        this.repo.updatePassword(jid, "password");
        Assert.assertEquals((String)"Changing to the same password failed", (Object)"password", (Object)this.repo.getPassword(jid));
        this.repo.updatePassword(jid, "diffpass");
        Assert.assertEquals((String)"Changing to different password failed", (Object)"diffpass", (Object)this.repo.getPassword(jid));
        this.repo.removeUser(jid);
        Assert.assertFalse((String)"User removal failed", (boolean)this.repo.userExists(jid));
    }
}

