/*
 * Decompiled with CFR 0.152.
 */
package tigase.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.ErrorCategory;
import com.mongodb.MongoException;
import com.mongodb.MongoWriteException;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.DeleteManyModel;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.UpdateResult;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.Binary;
import tigase.annotations.TigaseDeprecated;
import tigase.auth.credentials.Credentials;
import tigase.db.AuthRepository;
import tigase.db.AuthRepositoryImpl;
import tigase.db.AuthorizationException;
import tigase.db.DBInitException;
import tigase.db.DataSourceAware;
import tigase.db.Repository;
import tigase.db.TigaseDBException;
import tigase.db.UserExistsException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.db.util.RepositoryVersionAware;
import tigase.db.util.SchemaLoader;
import tigase.kernel.beans.config.ConfigField;
import tigase.mongodb.Helper;
import tigase.mongodb.MongoDataSource;
import tigase.mongodb.MongoRepositoryVersionAware;
import tigase.util.StringUtilities;
import tigase.util.Version;
import tigase.xmpp.jid.BareJID;

@Repository.Meta(supportedUris={"mongodb:.*"})
@Repository.SchemaId(id="server", name="Tigase XMPP Server (Core)", external=false)
@RepositoryVersionAware.SchemaVersion
@Deprecated
@TigaseDeprecated(since="8.0.0")
public class MongoRepositoryOld
implements AuthRepository,
UserRepository,
DataSourceAware<MongoDataSource>,
MongoRepositoryVersionAware {
    protected static final String USERS_COLLECTION = "tig_users";
    protected static final String NODES_COLLECTION = "tig_nodes";
    protected static final String ID_KEY = "user_id";
    protected static final String DOMAIN_KEY = "domain";
    private static final Logger log = Logger.getLogger(MongoRepositoryOld.class.getCanonicalName());
    private static final String JID_HASH_ALG = "SHA-256";
    private static final int DEF_BATCH_SIZE = 100;
    private static final String AUTO_CREATE_USER_KEY = "autoCreateUser=";
    private static final Charset UTF8 = Charset.forName("UTF-8");
    @ConfigField(desc="Auto create user", alias="autoCreateUser=")
    protected boolean autoCreateUser = false;
    private AuthRepository auth;
    @ConfigField(desc="Batch size", alias="batch-size")
    private int batchSize = 100;
    private MongoDataSource dataSource;
    private MongoDatabase db;
    private MongoCollection<Document> nodesCollection;
    private MongoCollection<Document> usersCollection;

    public void addDataList(BareJID user, String subnode, String key, String[] list) throws UserNotFoundException, TigaseDBException {
        subnode = this.normalizeSubnode(subnode);
        try {
            byte[] uid = this.generateId(user);
            Document dto = new Document("uid", (Object)uid).append("node", (Object)subnode).append("key", (Object)key).append("values", Arrays.asList(list));
            this.nodesCollection.insertOne((Object)dto);
            if (this.autoCreateUser) {
                this.ensureUserExists(user, uid);
            }
        }
        catch (MongoException ex) {
            throw new TigaseDBException("Problem adding data list to repository", (Throwable)ex);
        }
    }

    public void addUser(BareJID user) throws UserExistsException, TigaseDBException {
        this.addUserRepo(user);
    }

    public void addUser(BareJID user, String password) throws UserExistsException, TigaseDBException {
        this.auth.addUser(user, password);
    }

    private Object addUserRepo(BareJID user) throws UserExistsException, TigaseDBException {
        try {
            byte[] id = this.generateId(user);
            Document userDto = new Document().append(ID_KEY, (Object)user.toString());
            userDto.append(DOMAIN_KEY, (Object)user.getDomain());
            userDto.append("_id", (Object)id);
            this.usersCollection.insertOne((Object)userDto);
            return id;
        }
        catch (MongoWriteException ex) {
            if (ex.getError() != null && ex.getError().getCategory() == ErrorCategory.DUPLICATE_KEY) {
                throw new UserExistsException("Error adding user to repository: ", (Throwable)ex);
            }
            throw new TigaseDBException("Error adding user to repository: ", (Throwable)ex);
        }
        catch (MongoException ex) {
            throw new TigaseDBException("Error adding user to repository: ", (Throwable)ex);
        }
    }

    protected byte[] calculateHash(String user) throws TigaseDBException {
        try {
            MessageDigest md = MessageDigest.getInstance(JID_HASH_ALG);
            return md.digest(user.getBytes(UTF8));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new TigaseDBException("Should not happen!!", (Throwable)ex);
        }
    }

    private Document createCrit(BareJID user, String subnode, String key) throws TigaseDBException {
        subnode = this.normalizeSubnode(subnode);
        byte[] uid = this.generateId(user);
        Document crit = new Document("uid", (Object)uid);
        if (key != null) {
            crit.append("key", (Object)key);
        }
        if (subnode == null) {
            crit.append("node", (Object)new Document("$exists", (Object)false));
        } else {
            crit.append("node", (Object)subnode);
        }
        return crit;
    }

    private void ensureUserExists(BareJID user, byte[] id) throws TigaseDBException {
        try {
            BasicDBObject userDto = new BasicDBObject();
            userDto.append(DOMAIN_KEY, (Object)user.getDomain());
            if (id == null) {
                id = this.generateId(user);
            }
            userDto.append("_id", (Object)id);
            this.usersCollection.updateOne((Bson)userDto, (Bson)new Document("$set", (Object)new Document((Map)userDto).append(ID_KEY, (Object)user.toString())), new UpdateOptions().upsert(true));
        }
        catch (MongoException ex) {
            throw new TigaseDBException("Error adding user to repository: ", (Throwable)ex);
        }
    }

    protected byte[] generateId(BareJID user) throws TigaseDBException {
        return this.calculateHash(user.toString().toLowerCase());
    }

    public AuthRepository.AccountStatus getAccountStatus(BareJID user) throws TigaseDBException {
        return this.auth.getAccountStatus(user);
    }

    public Credentials getCredentials(BareJID user, String username) throws TigaseDBException {
        return this.auth.getCredentials(user, username);
    }

    public String getData(BareJID user, String subnode, String key, String def) throws UserNotFoundException, TigaseDBException {
        String value = this.getData(user, subnode, key);
        if (value == null) {
            value = def;
        }
        return value;
    }

    public String getData(BareJID user, String subnode, String key) throws UserNotFoundException, TigaseDBException {
        try {
            Document result = this.getDataInt(user, subnode, key);
            return result != null ? result.getString((Object)"value") : null;
        }
        catch (MongoException ex) {
            throw new TigaseDBException("Problem retrieving data from repository", (Throwable)ex);
        }
    }

    public String getData(BareJID user, String key) throws UserNotFoundException, TigaseDBException {
        try {
            Document result = this.getDataInt(user, null, key);
            return result != null ? result.getString((Object)"value") : null;
        }
        catch (MongoException ex) {
            throw new TigaseDBException("Problem retrieving data from repository", (Throwable)ex);
        }
    }

    private Document getDataInt(BareJID user, String subnode, String key) throws TigaseDBException {
        Document crit = this.createCrit(user, subnode, key);
        return (Document)this.nodesCollection.find((Bson)crit).first();
    }

    public String[] getDataList(BareJID user, String subnode, String key) throws UserNotFoundException, TigaseDBException {
        try {
            ArrayList<String> values = new ArrayList<String>();
            Document crit = this.createCrit(user, subnode, key);
            FindIterable cursor = this.nodesCollection.find((Bson)crit).batchSize(this.batchSize);
            for (Document it : cursor) {
                if (it.containsKey((Object)"values")) {
                    values.addAll((List)it.get((Object)"values"));
                    continue;
                }
                if (!it.containsKey((Object)"value")) continue;
                values.add((String)it.get((Object)"value"));
            }
            return values.toArray(new String[values.size()]);
        }
        catch (MongoException ex) {
            throw new TigaseDBException("Problem retrieving data list from repository", (Throwable)ex);
        }
    }

    public String[] getKeys(BareJID user, String subnode) throws UserNotFoundException, TigaseDBException {
        try {
            Document crit = this.createCrit(user, subnode, null);
            List<String> result = this.readAllDistinctValuesForField(this.nodesCollection, "key", crit);
            return result.toArray(new String[result.size()]);
        }
        catch (MongoException ex) {
            throw new TigaseDBException("Problem retrieving keys for " + user + " and subnode " + subnode + " from repository", (Throwable)ex);
        }
    }

    public String[] getKeys(BareJID user) throws UserNotFoundException, TigaseDBException {
        return this.getKeys(user, null);
    }

    public String getPassword(BareJID user) throws UserNotFoundException, TigaseDBException {
        return this.auth.getPassword(user);
    }

    public String getResourceUri() {
        return this.dataSource.getResourceUri();
    }

    public String[] getSubnodes(BareJID user) throws UserNotFoundException, TigaseDBException {
        return this.getSubnodes(user, null);
    }

    public String[] getSubnodes(BareJID user, String subnode) throws UserNotFoundException, TigaseDBException {
        subnode = this.normalizeSubnode(subnode);
        try {
            byte[] uid = this.generateId(user);
            Document crit = new Document("uid", (Object)uid);
            Pattern regex = Pattern.compile("^" + (subnode != null ? subnode + "/" : "") + "[^/]*");
            crit.append("node", (Object)regex);
            List result = this.readAllDistinctValuesForField(this.nodesCollection, "node", crit);
            ArrayList<String> res = new ArrayList<String>();
            for (String node : result) {
                int idx;
                if (subnode != null) {
                    node = node.substring(subnode.length() + 1);
                }
                if ((idx = node.indexOf("/")) > 0) {
                    node = node.substring(0, idx);
                }
                if (res.contains(node)) continue;
                res.add(node);
            }
            return res.isEmpty() ? null : res.toArray(new String[res.size()]);
        }
        catch (MongoException ex) {
            throw new TigaseDBException("Error getting subnode from repository: ", (Throwable)ex);
        }
    }

    @Deprecated
    public long getUserUID(BareJID user) throws TigaseDBException {
        return 0L;
    }

    public List<BareJID> getUsers() throws TigaseDBException {
        ArrayList<BareJID> users = new ArrayList<BareJID>(1000);
        try {
            FindIterable cursor = this.usersCollection.find().projection((Bson)new Document(ID_KEY, (Object)1)).batchSize(this.batchSize);
            for (Document entry : cursor) {
                users.add(BareJID.bareJIDInstanceNS((String)((String)entry.get((Object)ID_KEY))));
            }
        }
        catch (MongoException ex) {
            throw new TigaseDBException("Problem loading user list from repository", (Throwable)ex);
        }
        return users;
    }

    public long getUsersCount() {
        try {
            return this.usersCollection.count((Bson)new Document());
        }
        catch (MongoException ex) {
            return -1L;
        }
    }

    public long getUsersCount(String domain) {
        try {
            Document crit = new Document();
            crit.append(DOMAIN_KEY, (Object)domain.toLowerCase());
            return this.usersCollection.count((Bson)crit);
        }
        catch (MongoException ex) {
            return -1L;
        }
    }

    @Deprecated
    public void initRepository(String resource_uri, Map<String, String> params) throws DBInitException {
        try {
            if (this.db == null) {
                MongoDataSource ds = new MongoDataSource();
                ds.initRepository(resource_uri, params);
                this.setDataSource(ds);
            }
        }
        catch (MongoException ex) {
            throw new DBInitException("Could not connect to MongoDB server using URI = " + resource_uri, (Throwable)ex);
        }
    }

    public boolean isUserDisabled(BareJID user) throws UserNotFoundException, TigaseDBException {
        return this.auth.isUserDisabled(user);
    }

    public void loggedIn(BareJID jid) throws TigaseDBException {
        this.auth.loggedIn(jid);
    }

    public void logout(BareJID user) throws UserNotFoundException, TigaseDBException {
        this.auth.logout(user);
    }

    private String normalizeSubnode(String subnode) {
        if (subnode != null) {
            String[] split = subnode.split("/");
            subnode = StringUtilities.stringArrayToString((String[])split, (String)"/");
        }
        return subnode;
    }

    public boolean otherAuth(Map<String, Object> authProps) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        return this.auth.otherAuth(authProps);
    }

    public void queryAuth(Map<String, Object> authProps) {
        this.auth.queryAuth(authProps);
    }

    protected <T> List<T> readAllDistinctValuesForField(MongoCollection<Document> collection, String field, Document crit) throws MongoException {
        FindIterable cursor = collection.find((Bson)crit).projection((Bson)new BasicDBObject(field, (Object)1)).batchSize(this.batchSize);
        ArrayList<Object> result = new ArrayList<Object>();
        for (Document item : cursor) {
            Object val = item.get((Object)field);
            if (result.contains(val)) continue;
            result.add(val);
        }
        return result;
    }

    public void removeCredential(BareJID user, String username) throws TigaseDBException {
    }

    public void removeData(BareJID user, String key) throws UserNotFoundException, TigaseDBException {
        this.removeData(user, null, key);
    }

    public void removeData(BareJID user, String subnode, String key) throws UserNotFoundException, TigaseDBException {
        try {
            Document crit = this.createCrit(user, subnode, key);
            this.db.getCollection(NODES_COLLECTION).deleteMany((Bson)crit);
        }
        catch (MongoException ex) {
            throw new TigaseDBException("Error data from repository: ", (Throwable)ex);
        }
    }

    public void removeSubnode(BareJID user, String subnode) throws UserNotFoundException, TigaseDBException {
        subnode = this.normalizeSubnode(subnode);
        try {
            byte[] uid = this.generateId(user);
            Document crit = new Document("uid", (Object)uid);
            Pattern regex = Pattern.compile("^" + (subnode != null ? subnode : "") + "[^/]*");
            crit.append("node", (Object)regex);
            this.nodesCollection.deleteMany((Bson)crit);
        }
        catch (MongoException ex) {
            throw new TigaseDBException("Error removing subnode from repository: ", (Throwable)ex);
        }
    }

    public void removeUser(BareJID user) throws UserNotFoundException, TigaseDBException {
        try {
            Document userDto = new Document();
            byte[] id = this.generateId(user);
            userDto.append("_id", (Object)id);
            this.usersCollection.deleteOne((Bson)userDto);
            this.removeSubnode(user, null);
        }
        catch (MongoException e) {
            throw new TigaseDBException("Error removing user from repository: ", (Throwable)e);
        }
    }

    public void setAccountStatus(BareJID user, AuthRepository.AccountStatus status) throws TigaseDBException {
        this.auth.setAccountStatus(user, status);
    }

    public void setData(BareJID user, String key, String value) throws UserNotFoundException, TigaseDBException {
        this.setData(user, null, key, value);
    }

    public void setData(BareJID user, String subnode, String key, String value) throws UserNotFoundException, TigaseDBException {
        try {
            Document crit = this.createCrit(user, subnode, key);
            Document dto = new Document((Map)crit).append("value", (Object)value);
            if (subnode == null) {
                dto.remove((Object)"node");
            }
            this.nodesCollection.updateOne((Bson)crit, (Bson)new Document("$set", (Object)dto), new UpdateOptions().upsert(true));
            if (this.autoCreateUser) {
                this.ensureUserExists(user, null);
            }
        }
        catch (MongoException ex) {
            throw new TigaseDBException("Problem setting values in repository", (Throwable)ex);
        }
    }

    public void setDataList(BareJID user, String subnode, String key, String[] list) throws UserNotFoundException, TigaseDBException {
        try {
            Document crit = this.createCrit(user, subnode, key);
            Document dto = new Document((Map)crit).append("values", Arrays.asList(list));
            if (subnode == null) {
                dto.remove((Object)"node");
            }
            ArrayList<Object> operation = new ArrayList<Object>();
            operation.add(new DeleteManyModel((Bson)crit));
            operation.add(new InsertOneModel((Object)dto));
            this.nodesCollection.bulkWrite(operation);
            if (this.autoCreateUser) {
                this.ensureUserExists(user, null);
            }
        }
        catch (MongoException ex) {
            throw new TigaseDBException("Problem setting values in repository", (Throwable)ex);
        }
    }

    public void setDataSource(MongoDataSource dataSource) {
        this.dataSource = dataSource;
        this.db = dataSource.getDatabase();
        Object users = null;
        if (!Helper.collectionExists(this.db, USERS_COLLECTION)) {
            this.db.createCollection(USERS_COLLECTION);
        }
        this.usersCollection = this.db.getCollection(USERS_COLLECTION);
        MongoCollection<Document> nodes = null;
        if (!Helper.collectionExists(this.db, NODES_COLLECTION)) {
            this.db.createCollection(NODES_COLLECTION);
        }
        this.nodesCollection = this.db.getCollection(NODES_COLLECTION);
        nodes = this.nodesCollection;
        nodes.createIndex((Bson)new BasicDBObject("uid", (Object)1));
        nodes.createIndex((Bson)new BasicDBObject("node", (Object)1));
        nodes.createIndex((Bson)new BasicDBObject("key", (Object)1));
        nodes.createIndex((Bson)new BasicDBObject("uid", (Object)1).append("node", (Object)1).append("key", (Object)1));
        this.auth = new AuthRepositoryImpl(this){

            public String getPassword(BareJID user) throws TigaseDBException {
                try {
                    byte[] id = MongoRepositoryOld.this.generateId(user);
                    Document userDto = (Document)MongoRepositoryOld.this.usersCollection.find((Bson)new BasicDBObject("_id", (Object)id)).projection((Bson)new BasicDBObject("password", (Object)1)).first();
                    if (userDto == null) {
                        throw new UserNotFoundException("User " + user + " not found in repository");
                    }
                    return (String)userDto.get((Object)"password");
                }
                catch (MongoException ex) {
                    throw new TigaseDBException("Error retrieving password for user " + user, (Throwable)ex);
                }
            }

            public void updatePassword(BareJID user, String password) throws TigaseDBException {
                try {
                    byte[] id = MongoRepositoryOld.this.generateId(user);
                    UpdateResult result = MongoRepositoryOld.this.usersCollection.updateOne((Bson)new BasicDBObject("_id", (Object)id), (Bson)new BasicDBObject("$set", (Object)new BasicDBObject("password", (Object)password)));
                    if (result == null || result.getMatchedCount() <= 0L) {
                        throw new UserNotFoundException("User " + user + " not found in repository");
                    }
                }
                catch (MongoException ex) {
                    throw new TigaseDBException("Error retrieving password for user " + user, (Throwable)ex);
                }
            }
        };
    }

    public void setUserDisabled(BareJID user, Boolean value) throws UserNotFoundException, TigaseDBException {
        this.auth.setUserDisabled(user, value);
    }

    public void updateCredential(BareJID user, String username, String password) throws TigaseDBException {
        this.auth.updateCredential(user, username, password);
    }

    public void updatePassword(BareJID user, String password) throws UserNotFoundException, TigaseDBException {
        this.auth.updatePassword(user, password);
    }

    public SchemaLoader.Result updateSchema(Optional<Version> oldVersion, Version newVersion) throws TigaseDBException {
        long usersCount = this.getUsersCount();
        List<BareJID> users = this.getUsers();
        for (Document doc : this.usersCollection.find().batchSize(1000)) {
            try {
                byte[] oldUid = ((Binary)doc.get((Object)"_id")).getData();
                String user = (String)doc.get((Object)ID_KEY);
                byte[] newUid = this.calculateHash(user.toLowerCase());
                if (Arrays.equals(oldUid, newUid)) continue;
                this.nodesCollection.updateMany((Bson)new Document("uid", (Object)oldUid), (Bson)new Document("$set", (Object)new Document("uid", (Object)newUid)));
                Document oldUserFilter = new Document("_id", (Object)oldUid).append(ID_KEY, (Object)user);
                Document oldUserDocument = (Document)this.usersCollection.find((Bson)oldUserFilter).first();
                Document newUserDocument = new Document((Map)oldUserDocument).append("_id", (Object)newUid);
                this.usersCollection.insertOne((Object)newUserDocument);
                this.usersCollection.findOneAndDelete((Bson)oldUserDocument);
            }
            catch (TigaseDBException ex) {
                log.log(Level.SEVERE, "Schema update failed!", ex);
            }
        }
        return SchemaLoader.Result.ok;
    }

    public boolean userExists(BareJID user) {
        try {
            BasicDBObject userDto = new BasicDBObject();
            byte[] id = this.generateId(user);
            userDto.append("_id", (Object)id);
            return this.usersCollection.count((Bson)userDto) > 0L;
        }
        catch (Exception e) {
            return false;
        }
    }
}

