/*
 * Decompiled with CFR 0.152.
 */
package tigase.mongodb.muc;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.Updates;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;
import tigase.component.exceptions.RepositoryException;
import tigase.db.Repository;
import tigase.db.TigaseDBException;
import tigase.kernel.beans.Inject;
import tigase.mongodb.Helper;
import tigase.mongodb.MongoDataSource;
import tigase.muc.Affiliation;
import tigase.muc.Room;
import tigase.muc.RoomConfig;
import tigase.muc.RoomWithId;
import tigase.muc.repository.AbstractMucDAO;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xmpp.jid.BareJID;

@Repository.Meta(supportedUris={"mongodb:.*"})
@Repository.SchemaId(id="muc", name="Tigase MUC Component", external=false)
public class MongoMucDAO
extends AbstractMucDAO<MongoDataSource, byte[]> {
    private static final Logger log = Logger.getLogger(MongoMucDAO.class.getCanonicalName());
    private static final int DEF_BATCH_SIZE = 100;
    private static final String HASH_ALG = "SHA-256";
    private static final String ROOMS_COLLECTION = "tig_muc_rooms";
    private static final String ROOM_AFFILIATIONS_COLLECTION = "tig_muc_room_affiliations";
    private static final Charset UTF8 = Charset.forName("UTF-8");
    protected MongoCollection<Document> roomAffilaitionsCollection;
    protected MongoCollection<Document> roomsCollection;
    private MongoDatabase db;
    @Inject
    private Room.RoomFactory roomFactory;

    protected byte[] calculateHash(String user) throws TigaseDBException {
        try {
            MessageDigest md = MessageDigest.getInstance(HASH_ALG);
            return md.digest(user.getBytes(UTF8));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new TigaseDBException("Should not happen!!", (Throwable)ex);
        }
    }

    public byte[] createRoom(RoomWithId<byte[]> room) throws RepositoryException {
        try {
            byte[] roomId = this.generateId(room.getRoomJID());
            String roomName = room.getConfig().getRoomName();
            Document roomDoc = new Document("_id", (Object)roomId).append("jid", (Object)room.getRoomJID().toString()).append("name", roomName != null && !roomName.isEmpty() ? roomName : null).append("config", (Object)room.getConfig().getAsElement().toString()).append("creator", (Object)room.getCreatorJid().toString()).append("creation_date", (Object)room.getCreationDate());
            this.roomsCollection.insertOne((Object)roomDoc);
            room.setId((Object)roomId);
            for (BareJID affJid : room.getAffiliations()) {
                Affiliation a = room.getAffiliation(affJid);
                this.setAffiliation(room, affJid, a);
            }
            return roomId;
        }
        catch (Exception ex) {
            throw new RepositoryException("Error while saving room " + room.getRoomJID() + " to database", (Throwable)ex);
        }
    }

    public void destroyRoom(BareJID roomJID) throws RepositoryException {
        try {
            byte[] roomId = this.generateId(roomJID);
            this.roomAffilaitionsCollection.deleteMany((Bson)new Document("room_id", (Object)roomId));
            this.roomsCollection.deleteOne((Bson)new Document("_id", (Object)roomId));
        }
        catch (Exception ex) {
            throw new RepositoryException("Error while removing room " + roomJID + " from database", (Throwable)ex);
        }
    }

    protected byte[] generateId(BareJID user) throws TigaseDBException {
        return this.calculateHash(user.toString().toLowerCase());
    }

    public Map<BareJID, Affiliation> getAffiliations(RoomWithId<byte[]> room) throws RepositoryException {
        HashMap<BareJID, Affiliation> affiliations = new HashMap<BareJID, Affiliation>();
        try {
            byte[] roomId = (byte[])room.getId();
            this.roomAffilaitionsCollection.find(Filters.eq((String)"room_id", (Object)roomId)).projection(Projections.include((String[])new String[]{"jid", "affiliation"})).forEach(doc -> {
                try {
                    BareJID jid = BareJID.bareJIDInstance((String)doc.getString((Object)"jid"));
                    Affiliation affiliation = Affiliation.valueOf((String)doc.getString((Object)"affiliation"));
                    affiliations.put(jid, affiliation);
                }
                catch (TigaseStringprepException ex) {
                    throw new RuntimeException(ex);
                }
            });
        }
        catch (Exception ex) {
            throw new RepositoryException("Error while reading room " + room.getRoomJID() + " affiliations from database", (Throwable)ex);
        }
        return affiliations;
    }

    public RoomWithId<byte[]> getRoom(BareJID roomJID) throws RepositoryException {
        try {
            byte[] roomId = this.generateId(roomJID);
            Document roomDoc = (Document)this.roomsCollection.find(Filters.eq((String)"_id", (Object)roomId)).first();
            if (roomDoc == null) {
                return null;
            }
            Date date = roomDoc.getDate((Object)"creation_date");
            BareJID creator = BareJID.bareJIDInstance((String)roomDoc.getString((Object)"creator"));
            RoomConfig roomConfig = new RoomConfig(roomJID);
            roomConfig.readFromElement(this.parseConfigElement(roomDoc.getString((Object)"config")));
            RoomWithId room = this.roomFactory.newInstance((Object)roomId, roomConfig, date, creator);
            String subject = roomDoc.getString((Object)"subject");
            String subjectCreator = roomDoc.getString((Object)"subject_creator_nick");
            room.setNewSubject(subject, subjectCreator);
            Date subjectDate = roomDoc.getDate((Object)"subject_date");
            room.setSubjectChangeDate(subjectDate);
            return room;
        }
        catch (Exception ex) {
            throw new RepositoryException("Error while reading room " + roomJID + " from database", (Throwable)ex);
        }
    }

    public ArrayList<BareJID> getRoomsJIDList() throws RepositoryException {
        ArrayList<BareJID> jids = new ArrayList<BareJID>();
        try {
            this.roomsCollection.find().projection(Projections.include((String[])new String[]{"jid"})).map(doc -> {
                try {
                    return BareJID.bareJIDInstance((String)doc.getString((Object)"jid"));
                }
                catch (TigaseStringprepException ex) {
                    throw new RuntimeException(ex);
                }
            }).forEach(jids::add);
        }
        catch (Exception ex) {
            throw new RepositoryException("Error while reading list of rooms jids from database", (Throwable)ex);
        }
        return jids;
    }

    public void setAffiliation(RoomWithId<byte[]> room, BareJID jid, Affiliation affiliation) throws RepositoryException {
        try {
            byte[] jidId = this.generateId(jid);
            Bson crit = Filters.and((Bson[])new Bson[]{Filters.eq((String)"room_id", (Object)room.getId()), Filters.eq((String)"jid_id", (Object)jidId)});
            if (affiliation == Affiliation.none) {
                this.roomAffilaitionsCollection.deleteOne(crit);
            } else {
                Bson update = Updates.combine((Bson[])new Bson[]{Updates.setOnInsert((String)"jid", (Object)jid.toString()), Updates.set((String)"affiliation", (Object)affiliation.name())});
                this.roomAffilaitionsCollection.updateOne(crit, update, new UpdateOptions().upsert(true));
            }
        }
        catch (Exception ex) {
            throw new RepositoryException("Error while setting affiliation for room " + room.getRoomJID() + " for jid " + jid + " to " + affiliation.name(), (Throwable)ex);
        }
    }

    public void setDataSource(MongoDataSource dataSource) {
        this.db = dataSource.getDatabase();
        if (!Helper.collectionExists(this.db, ROOMS_COLLECTION)) {
            this.db.createCollection(ROOMS_COLLECTION);
        }
        this.roomsCollection = this.db.getCollection(ROOMS_COLLECTION);
        this.roomsCollection.createIndex((Bson)new Document("jid", (Object)1), new IndexOptions().unique(true));
        if (!Helper.collectionExists(this.db, ROOM_AFFILIATIONS_COLLECTION)) {
            this.db.createCollection(ROOM_AFFILIATIONS_COLLECTION);
        }
        this.roomAffilaitionsCollection = this.db.getCollection(ROOM_AFFILIATIONS_COLLECTION);
        this.roomAffilaitionsCollection.createIndex((Bson)new Document("room_id", (Object)1));
        this.roomAffilaitionsCollection.createIndex((Bson)new Document("room_id", (Object)1).append("jid_id", (Object)1), new IndexOptions().unique(true));
    }

    public void setSubject(RoomWithId<byte[]> room, String subject, String creatorNickname, Date changeDate) throws RepositoryException {
        try {
            Bson crit = Filters.eq((String)"_id", (Object)room.getId());
            Document update = new Document("subject", (Object)subject).append("subject_creator_nick", (Object)creatorNickname).append("subject_date", (Object)changeDate);
            this.roomsCollection.updateOne(crit, (Bson)new Document("$set", (Object)update));
        }
        catch (Exception ex) {
            throw new RepositoryException("Error while setting subject for room " + room.getRoomJID() + " to " + subject + " by " + creatorNickname, (Throwable)ex);
        }
    }

    public void updateRoomConfig(RoomConfig roomConfig) throws RepositoryException {
        try {
            String roomName = roomConfig.getRoomName();
            Bson crit = Filters.eq((String)"_id", (Object)this.generateId(roomConfig.getRoomJID()));
            Bson update = Updates.combine((Bson[])new Bson[]{Updates.set((String)"config", (Object)roomConfig.getAsElement().toString()), Updates.set((String)"name", roomName != null && !roomName.isEmpty() ? roomName : null)});
            this.roomsCollection.updateOne(crit, update);
        }
        catch (Exception ex) {
            throw new RepositoryException("Error updating configuration of room " + roomConfig.getRoomJID(), (Throwable)ex);
        }
    }
}

