/*
 * Decompiled with CFR 0.152.
 */
package tigase.mongodb.muc;

import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.bson.Document;
import org.junit.Assert;
import org.junit.Test;
import tigase.component.PacketWriter;
import tigase.component.responses.AsyncCallback;
import tigase.mongodb.MongoDataSource;
import tigase.mongodb.muc.MongoHistoryProvider;
import tigase.muc.Affiliation;
import tigase.muc.Room;
import tigase.muc.RoomConfig;
import tigase.muc.RoomWithId;
import tigase.muc.history.AbstractHistoryProviderTest;
import tigase.server.Packet;
import tigase.util.Version;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class MongoHistoryProviderTest
extends AbstractHistoryProviderTest<MongoDataSource> {
    protected MongoHistoryProvider getProvider() {
        return (MongoHistoryProvider)this.historyProvider;
    }

    @Test
    public void testSchemaUpgrade_JidComparison() throws Exception {
        BareJID jid = BareJID.bareJIDInstance((String)"TeSt@muc.example");
        byte[] rid = this.getProvider().calculateHash(jid.toString());
        JID creatorJID = JID.jidInstance((String)"TeStX3@example");
        RoomConfig rc = new RoomConfig(jid);
        rc.setValue("muc#roomconfig_persistentroom", (Object)Boolean.TRUE);
        creationDate = new Date();
        RoomWithId room = this.roomFactory.newInstance(null, rc, creationDate, creatorJID.getBareJID());
        room.addAffiliationByJid(creatorJID.getBareJID(), Affiliation.owner);
        final String body = "Test JID Comparison";
        Document dto = new Document("room_jid_id", (Object)rid).append("room_jid", (Object)jid.toString()).append("event_type", (Object)1).append("sender_jid", (Object)creatorJID.getBareJID().toString()).append("sender_nickname", (Object)"Test 1").append("body", (Object)body).append("public_event", (Object)room.getConfig().isLoggingEnabled());
        dto.append("timestamp", (Object)new Date());
        this.getProvider().historyCollection.insertOne((Object)dto);
        this.getProvider().getHistoryMessages((Room)room, creatorJID, null, Integer.valueOf(1), null, null, new PacketWriter(){

            public void write(Collection<Packet> packets) {
                for (Packet p : packets) {
                    this.write(p);
                }
            }

            public void write(Packet packet) {
                Assert.assertTrue((String)"There should be no messages found!", (boolean)false);
            }

            public void write(Packet packet, AsyncCallback callback) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        });
        this.getProvider().updateSchema(Optional.of(Version.ZERO), Version.ZERO);
        final AtomicInteger count = new AtomicInteger(0);
        this.getProvider().getHistoryMessages((Room)room, creatorJID, null, Integer.valueOf(1), null, null, new PacketWriter(){

            public void write(Collection<Packet> packets) {
                for (Packet p : packets) {
                    this.write(p);
                }
            }

            public void write(Packet packet) {
                Assert.assertEquals((String)"Retrieved incorrect messsage", (Object)body, (Object)packet.getElement().getChildCDataStaticStr(new String[]{"message", "body"}));
                count.incrementAndGet();
            }

            public void write(Packet packet, AsyncCallback callback) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        });
        Assert.assertEquals((String)"Not retrieved correct number of messages", (long)1L, (long)count.get());
        this.getProvider().removeHistory((Room)room);
    }
}

