/*
 * Decompiled with CFR 0.152.
 */
package tigase.mongodb.archive;

import com.mongodb.AggregationOptions;
import com.mongodb.BasicDBObject;
import com.mongodb.Cursor;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import tigase.archive.AbstractCriteria;
import tigase.archive.RSM;
import tigase.archive.db.AbstractMessageArchiveRepository;
import tigase.archive.db.MessageArchiveRepository;
import tigase.db.DBInitException;
import tigase.db.Repository;
import tigase.db.TigaseDBException;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.BareJID;

@Repository.Meta(supportedUris={"mongodb:.*"})
public class MongoMessageArchiveRepository
extends AbstractMessageArchiveRepository<Criteria> {
    private static final Logger log = Logger.getLogger(MongoMessageArchiveRepository.class.getCanonicalName());
    private static final String HASH_ALG = "SHA-256";
    private static final String[] MSG_BODY_PATH = new String[]{"message", "body"};
    private static final String MSGS_COLLECTION = "tig_ma_msgs";
    private static final String STORE_PLAINTEXT_BODY_KEY = "store-plaintext-body";
    private static final SimpleParser parser = SingletonFactory.getParserInstance();
    private String resourceUri;
    private MongoClient mongo;
    private DB db;
    private boolean storePlaintextBody = true;

    private static byte[] generateId(BareJID user) throws TigaseDBException {
        try {
            MessageDigest md = MessageDigest.getInstance(HASH_ALG);
            return md.digest(user.toString().getBytes());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new TigaseDBException("Should not happen!!", (Throwable)ex);
        }
    }

    private static byte[] generateId(String user) throws TigaseDBException {
        try {
            MessageDigest md = MessageDigest.getInstance(HASH_ALG);
            return md.digest(user.getBytes());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new TigaseDBException("Should not happen!!", (Throwable)ex);
        }
    }

    public void archiveMessage(BareJID owner, BareJID buddy, MessageArchiveRepository.Direction direction, Date timestamp, Element msg, Set<String> tags) {
        try {
            String body;
            byte[] oid = MongoMessageArchiveRepository.generateId(owner);
            byte[] bid = MongoMessageArchiveRepository.generateId(buddy);
            String type = msg.getAttributeStaticStr("type");
            Date date = new Date(timestamp.getTime() - timestamp.getTime() % 86400000L);
            BasicDBObject dto = new BasicDBObject("owner", (Object)owner.toString()).append("owner_id", (Object)oid).append("buddy", (Object)buddy.toString()).append("buddy_id", (Object)bid).append("date", (Object)date).append("direction", (Object)direction.name()).append("ts", (Object)timestamp).append("type", (Object)type).append("msg", (Object)msg.toString());
            if (this.storePlaintextBody && (body = msg.getChildCData(MSG_BODY_PATH)) != null) {
                dto.append("body", (Object)body);
            }
            if (tags != null && !tags.isEmpty()) {
                dto.append("tags", new ArrayList<String>(tags));
            }
            this.db.getCollection(MSGS_COLLECTION).insert(new DBObject[]{dto});
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Problem adding new entry to DB: " + msg, ex);
        }
    }

    public List<Element> getCollections(BareJID owner, Criteria criteria) throws TigaseDBException {
        try (Cursor cursor = null;){
            criteria.setOwner(owner);
            BasicDBObject crit = criteria.getCriteriaDBObject();
            ArrayList<Element> results = new ArrayList<Element>();
            ArrayList<BasicDBObject> pipeline = new ArrayList<BasicDBObject>();
            BasicDBObject matchCrit = new BasicDBObject("$match", (Object)crit);
            pipeline.add(matchCrit);
            BasicDBObject groupCrit = new BasicDBObject("$group", (Object)new BasicDBObject("_id", (Object)new BasicDBObject("ts", (Object)"$date").append("buddy", (Object)"$buddy")).append("ts", (Object)new BasicDBObject("$min", (Object)"$ts")).append("buddy", (Object)new BasicDBObject("$min", (Object)"$buddy")));
            pipeline.add(groupCrit);
            BasicDBObject countCrit = new BasicDBObject("$group", (Object)new BasicDBObject("_id", (Object)1).append("count", (Object)new BasicDBObject("$sum", (Object)1)));
            pipeline.add(countCrit);
            cursor = this.db.getCollection(MSGS_COLLECTION).aggregate(pipeline, AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).outputMode(AggregationOptions.OutputMode.CURSOR).build());
            int count = 0;
            if (cursor.hasNext()) {
                count = (Integer)((DBObject)cursor.next()).get("count");
            }
            cursor.close();
            cursor = null;
            criteria.setSize(count);
            if (count > 0) {
                pipeline.clear();
                pipeline.add(matchCrit);
                pipeline.add(groupCrit);
                BasicDBObject sort = new BasicDBObject("$sort", (Object)new BasicDBObject("ts", (Object)1).append("buddy", (Object)1));
                pipeline.add(sort);
                if (criteria.getOffset() > 0) {
                    BasicDBObject skipCrit = new BasicDBObject("$skip", (Object)criteria.getOffset());
                    pipeline.add(skipCrit);
                }
                BasicDBObject limitCrit = new BasicDBObject("$limit", (Object)criteria.getLimit());
                pipeline.add(limitCrit);
                cursor = this.db.getCollection(MSGS_COLLECTION).aggregate(pipeline, AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).outputMode(AggregationOptions.OutputMode.CURSOR).build());
                while (cursor.hasNext()) {
                    DBObject dto = (DBObject)cursor.next();
                    String buddy = (String)dto.get("buddy");
                    Date ts = (Date)dto.get("ts");
                    this.addCollectionToResults(results, buddy, ts);
                }
            }
            RSM rsm = criteria.getRSM();
            rsm.setResults(Integer.valueOf(count), Integer.valueOf(criteria.getOffset()));
            if (!results.isEmpty()) {
                rsm.setFirst(String.valueOf(criteria.getOffset()));
                rsm.setLast(String.valueOf(criteria.getOffset() + (results.size() - 1)));
            }
            ArrayList<Element> arrayList = results;
            return arrayList;
        }
    }

    public List<Element> getItems(BareJID owner, Criteria criteria) throws TigaseDBException {
        try (DBCursor cursor = null;){
            criteria.setOwner(owner);
            BasicDBObject crit = criteria.getCriteriaDBObject();
            ArrayList<Element> results = new ArrayList<Element>();
            cursor = this.db.getCollection(MSGS_COLLECTION).find((DBObject)crit);
            int count = cursor.count();
            criteria.setSize(count);
            if (criteria.getOffset() > 0) {
                cursor.skip(criteria.getOffset());
            }
            cursor.limit(criteria.getLimit()).sort((DBObject)new BasicDBObject("ts", (Object)1));
            if (cursor.hasNext()) {
                Date startTimestamp = criteria.getStart();
                DomBuilderHandler domHandler = new DomBuilderHandler();
                while (cursor.hasNext()) {
                    DBObject dto = cursor.next();
                    String msgStr = (String)dto.get("msg");
                    Date ts = (Date)dto.get("ts");
                    MessageArchiveRepository.Direction direction = MessageArchiveRepository.Direction.valueOf((String)((String)dto.get("direction")));
                    if (startTimestamp == null) {
                        startTimestamp = ts;
                    }
                    String with = crit.containsField("buddy") ? null : (String)dto.get("buddy");
                    parser.parse((SimpleHandler)domHandler, msgStr.toCharArray(), 0, msgStr.length());
                    Queue queue = domHandler.getParsedElements();
                    Element msg = null;
                    while ((msg = (Element)queue.poll()) != null) {
                        this.addMessageToResults(results, startTimestamp, msg, ts, direction, with);
                    }
                }
            }
            RSM rsm = criteria.getRSM();
            rsm.setResults(Integer.valueOf(count), Integer.valueOf(criteria.getOffset()));
            if (!results.isEmpty()) {
                rsm.setFirst(String.valueOf(criteria.getOffset()));
                rsm.setLast(String.valueOf(criteria.getOffset() + (results.size() - 1)));
            }
            ArrayList<Element> arrayList = results;
            return arrayList;
        }
    }

    public void removeItems(BareJID owner, String withJid, Date start, Date end) throws TigaseDBException {
        try {
            byte[] oid = MongoMessageArchiveRepository.generateId(owner);
            byte[] wid = MongoMessageArchiveRepository.generateId(withJid);
            if (start == null) {
                start = new Date(0L);
            }
            if (end == null) {
                end = new Date(0L);
            }
            BasicDBObject dateCrit = new BasicDBObject("$gte", (Object)start).append("$lte", (Object)end);
            BasicDBObject crit = new BasicDBObject("owner_id", (Object)oid).append("owner", (Object)owner.toString()).append("buddy_id", (Object)wid).append("buddy", (Object)withJid).append("ts", (Object)dateCrit);
            this.db.getCollection(MSGS_COLLECTION).remove((DBObject)crit);
        }
        catch (Exception ex) {
            throw new TigaseDBException("Cound not remove items", (Throwable)ex);
        }
    }

    public List<String> getTags(BareJID owner, String startsWith, Criteria criteria) throws TigaseDBException {
        ArrayList<String> results = new ArrayList<String>();
        try (Cursor cursor = null;){
            byte[] oid = MongoMessageArchiveRepository.generateId(owner);
            Pattern tagPattern = Pattern.compile(startsWith + ".*");
            ArrayList<BasicDBObject> pipeline = new ArrayList<BasicDBObject>();
            BasicDBObject crit = new BasicDBObject("owner_id", (Object)oid).append("owner", (Object)owner.toString());
            BasicDBObject matchCrit = new BasicDBObject("$match", (Object)crit);
            pipeline.add(matchCrit);
            pipeline.add(new BasicDBObject("$unwind", (Object)"$tags"));
            pipeline.add(new BasicDBObject("$match", (Object)new BasicDBObject("tags", (Object)tagPattern)));
            pipeline.add(new BasicDBObject("$group", (Object)new BasicDBObject("_id", (Object)"$tags")));
            pipeline.add(new BasicDBObject("$group", (Object)new BasicDBObject("_id", (Object)1).append("count", (Object)new BasicDBObject("$sum", (Object)1))));
            cursor = this.db.getCollection(MSGS_COLLECTION).aggregate(pipeline, AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).outputMode(AggregationOptions.OutputMode.CURSOR).build());
            int count = 0;
            if (cursor.hasNext()) {
                count = (Integer)((DBObject)cursor.next()).get("count");
            }
            cursor.close();
            criteria.setSize(count);
            if (count > 0) {
                pipeline.remove(pipeline.size() - 1);
                pipeline.add(new BasicDBObject("$sort", (Object)new BasicDBObject("_id", (Object)1)));
                if (criteria.getOffset() > 0) {
                    pipeline.add(new BasicDBObject("$skip", (Object)criteria.getOffset()));
                }
                pipeline.add(new BasicDBObject("$limit", (Object)criteria.getLimit()));
                cursor = this.db.getCollection(MSGS_COLLECTION).aggregate(pipeline, AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).outputMode(AggregationOptions.OutputMode.CURSOR).build());
                while (cursor.hasNext()) {
                    DBObject dto = (DBObject)cursor.next();
                    results.add((String)dto.get("_id"));
                }
                RSM rsm = criteria.getRSM();
                rsm.setResults(Integer.valueOf(count), Integer.valueOf(criteria.getOffset()));
                if (!results.isEmpty()) {
                    rsm.setFirst(String.valueOf(criteria.getOffset()));
                    rsm.setLast(String.valueOf(criteria.getOffset() + (results.size() - 1)));
                }
            }
        }
        return results;
    }

    public void initRepository(String resource_uri, Map<String, String> params) throws DBInitException {
        try {
            this.storePlaintextBody = params.containsKey(STORE_PLAINTEXT_BODY_KEY) ? Boolean.parseBoolean(params.get(STORE_PLAINTEXT_BODY_KEY)) : true;
            this.resourceUri = resource_uri;
            MongoClientURI uri = new MongoClientURI(resource_uri);
            this.mongo = new MongoClient(uri);
            this.db = this.mongo.getDB(uri.getDatabase());
            DBCollection msgs = !this.db.collectionExists(MSGS_COLLECTION) ? this.db.createCollection(MSGS_COLLECTION, (DBObject)new BasicDBObject()) : this.db.getCollection(MSGS_COLLECTION);
            msgs.createIndex((DBObject)new BasicDBObject("owner_id", (Object)1).append("date", (Object)1));
            msgs.createIndex((DBObject)new BasicDBObject("owner_id", (Object)1).append("buddy_id", (Object)1).append("ts", (Object)1));
            msgs.createIndex((DBObject)new BasicDBObject("body", (Object)"text"));
            msgs.createIndex((DBObject)new BasicDBObject("owner_id", (Object)1).append("tags", (Object)1));
        }
        catch (UnknownHostException ex) {
            throw new DBInitException("Could not connect to MongoDB server using URI = " + resource_uri, (Throwable)ex);
        }
    }

    public void destroy() {
        if (this.mongo != null) {
            this.mongo.close();
        }
    }

    public AbstractCriteria newCriteriaInstance() {
        return new Criteria();
    }

    public static class Criteria
    extends AbstractCriteria<Date> {
        private BareJID owner;

        protected void setOwner(BareJID owner) {
            this.owner = owner;
        }

        protected Date convertTimestamp(Date date) {
            return date;
        }

        protected BasicDBObject getCriteriaDBObject() throws TigaseDBException {
            byte[] oid = MongoMessageArchiveRepository.generateId(this.owner);
            BasicDBObject crit = new BasicDBObject("owner_id", (Object)oid).append("owner", (Object)this.owner.toString());
            if (this.getWith() != null) {
                String withJid = this.getWith();
                byte[] wid = MongoMessageArchiveRepository.generateId(withJid);
                crit.append("buddy_id", (Object)wid).append("buddy", (Object)withJid);
            }
            BasicDBObject dateCrit = null;
            if (this.getStart() != null) {
                if (dateCrit == null) {
                    dateCrit = new BasicDBObject();
                }
                dateCrit.append("$gte", (Object)this.getStart());
            }
            if (this.getEnd() != null) {
                if (dateCrit == null) {
                    dateCrit = new BasicDBObject();
                }
                dateCrit.append("$lte", (Object)this.getEnd());
            }
            if (dateCrit != null) {
                crit.append("ts", (Object)dateCrit);
            }
            if (!this.getTags().isEmpty()) {
                crit.append("tags", (Object)new BasicDBObject("$all", new ArrayList(this.getTags())));
            }
            if (!this.getContains().isEmpty()) {
                StringBuilder containsSb = new StringBuilder();
                for (String contains : this.getContains()) {
                    if (containsSb.length() > 0) {
                        containsSb.append(" ");
                    }
                    containsSb.append(contains);
                }
                crit.append("$text", (Object)new BasicDBObject("$search", (Object)containsSb.toString()));
            }
            return crit;
        }
    }
}

