/*
 * Decompiled with CFR 0.152.
 */
package tigase.mongodb;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import tigase.mongodb.MongoMsgRepository;
import tigase.mongodb.MongoRepository;
import tigase.mongodb.cluster.ClConMongoRepository;
import tigase.osgi.ModulesManager;

public class Activator
implements BundleActivator,
ServiceListener {
    private static final Logger log = Logger.getLogger(Activator.class.getCanonicalName());
    private BundleContext context = null;
    private Set<Class<?>> exportedClasses = null;
    private ModulesManager serviceManager = null;
    private ServiceReference serviceReference = null;

    private void registerAddons() {
        if (this.serviceManager != null) {
            for (Class<?> exportedClass : this.exportedClasses) {
                this.serviceManager.registerClass(exportedClass);
            }
            this.serviceManager.update();
        }
    }

    public void serviceChanged(ServiceEvent event) {
        if (event.getType() == 1) {
            if (this.serviceReference == null) {
                this.serviceReference = event.getServiceReference();
                this.serviceManager = (ModulesManager)this.context.getService(this.serviceReference);
                this.registerAddons();
            }
        } else if (event.getType() == 4 && this.serviceReference == event.getServiceReference()) {
            this.unregisterAddons();
            this.context.ungetService(this.serviceReference);
            this.serviceManager = null;
            this.serviceReference = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext bc) throws Exception {
        Activator activator = this;
        synchronized (activator) {
            this.context = bc;
            this.exportedClasses = new HashSet();
            this.exportedClasses.add(MongoRepository.class);
            this.exportedClasses.add(MongoMsgRepository.class);
            this.exportedClasses.add(ClConMongoRepository.class);
            this.tryExportClass("tigase.mongodb.pubsub.PubSubDAOMongo");
            this.tryExportClass("tigase.mongodb.muc.MongoHistoryProvider");
            this.tryExportClass("tigase.mongodb.archive.MongoMessageArchiveRepository");
            bc.addServiceListener((ServiceListener)this, "(&(objectClass=" + ModulesManager.class.getName() + "))");
            this.serviceReference = bc.getServiceReference(ModulesManager.class.getName());
            if (this.serviceReference != null) {
                this.serviceManager = (ModulesManager)bc.getService(this.serviceReference);
                this.registerAddons();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext bc) throws Exception {
        Activator activator = this;
        synchronized (activator) {
            if (this.serviceManager != null) {
                this.unregisterAddons();
                this.context.ungetService(this.serviceReference);
                this.serviceManager = null;
                this.serviceReference = null;
            }
            this.exportedClasses = null;
        }
    }

    private void unregisterAddons() {
        if (this.serviceManager != null) {
            for (Class<?> exportedClass : this.exportedClasses) {
                try {
                    this.serviceManager.unregisterClass(exportedClass);
                }
                catch (Exception ex) {
                    log.log(Level.WARNING, "exception unregistering removing exported class " + exportedClass.getCanonicalName(), ex);
                }
            }
            this.serviceManager.update();
        }
    }

    private void tryExportClass(String className) {
        try {
            Class<?> cls = this.getClass().getClassLoader().loadClass(className);
            if (cls != null) {
                this.exportedClasses.add(cls);
            }
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "exception trying to export class " + className, ex);
        }
    }
}

