/*
 * Decompiled with CFR 0.152.
 */
package tigase.mongodb.muc;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import tigase.component.PacketWriter;
import tigase.db.DBInitException;
import tigase.db.Repository;
import tigase.db.TigaseDBException;
import tigase.muc.Affiliation;
import tigase.muc.Room;
import tigase.muc.RoomConfig;
import tigase.muc.history.AbstractHistoryProvider;
import tigase.server.Packet;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

@Repository.Meta(supportedUris={"mongodb:.*"})
public class MongoHistoryProvider
extends AbstractHistoryProvider {
    private static final String HASH_ALG = "SHA-256";
    private static final String HISTORY_COLLECTION = "muc_history";
    private String resourceUri;
    private MongoClient mongo;
    private DB db;

    private byte[] generateId(BareJID user) throws TigaseDBException {
        try {
            MessageDigest md = MessageDigest.getInstance(HASH_ALG);
            return md.digest(user.toString().getBytes());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new TigaseDBException("Should not happen!!", (Throwable)ex);
        }
    }

    public void addJoinEvent(Room room, Date date, JID senderJID, String nickName) {
    }

    public void addLeaveEvent(Room room, Date date, JID senderJID, String nickName) {
    }

    public void addMessage(Room room, Element message, String body, JID senderJid, String senderNickname, Date time) {
        try {
            byte[] rid = this.generateId(room.getRoomJID());
            BasicDBObject dto = new BasicDBObject("room_jid_id", (Object)rid).append("room_jid", (Object)room.getRoomJID().toString()).append("event_type", (Object)1).append("sender_jid", (Object)senderJid.toString()).append("sender_nickname", (Object)senderNickname).append("body", (Object)body).append("public_event", (Object)room.getConfig().isLoggingEnabled());
            if (time != null) {
                dto.append("timestamp", (Object)time);
            }
            if (message != null) {
                dto.append("msg", (Object)message.toString());
            }
            this.db.getCollection(HISTORY_COLLECTION).insert(new DBObject[]{dto});
        }
        catch (Exception ex) {
            this.log.log(Level.WARNING, "Can't add MUC message to database", ex);
            throw new RuntimeException(ex);
        }
    }

    public void addSubjectChange(Room room, Element message, String subject, JID senderJid, String senderNickname, Date time) {
    }

    public void destroy() {
        if (this.mongo != null) {
            this.mongo.close();
        }
    }

    public void getHistoryMessages(Room room, JID senderJID, Integer maxchars, Integer maxstanzas, Integer seconds, Date since, PacketWriter writer) {
        Affiliation recipientAffiliation = room.getAffiliation(senderJID.getBareJID());
        boolean addRealJids = room.getConfig().getRoomAnonymity() == RoomConfig.Anonymity.nonanonymous || room.getConfig().getRoomAnonymity() == RoomConfig.Anonymity.semianonymous && (recipientAffiliation == Affiliation.owner || recipientAffiliation == Affiliation.admin);
        try (DBCursor cursor = null;){
            int limit;
            byte[] rid = this.generateId(room.getRoomJID());
            int maxMessages = room.getConfig().getMaxHistory();
            int n = limit = maxstanzas != null ? Math.min(maxMessages, maxstanzas) : maxMessages;
            if (since == null && seconds != null && maxstanzas == null) {
                since = new Date(new Date().getTime() - (long)(seconds * 1000));
            }
            BasicDBObject crit = new BasicDBObject("room_jid_id", (Object)rid).append("room_jid", (Object)room.getRoomJID().toString());
            if (since != null) {
                crit.append("timestamp", (Object)new BasicDBObject("$gte", (Object)since));
                BasicDBObject order = new BasicDBObject("timestamp", (Object)1);
                cursor = this.db.getCollection(HISTORY_COLLECTION).find((DBObject)crit).limit(limit).sort((DBObject)order);
                while (cursor.hasNext()) {
                    DBObject dto = cursor.next();
                    Packet packet = this.createMessage(room.getRoomJID(), senderJID, dto, addRealJids);
                    writer.write(packet);
                }
            } else {
                BasicDBObject order = new BasicDBObject("timestamp", (Object)-1);
                cursor = this.db.getCollection(HISTORY_COLLECTION).find((DBObject)crit).limit(limit).sort((DBObject)order);
                ArrayList<Packet> results = new ArrayList<Packet>();
                while (cursor.hasNext()) {
                    DBObject dto = cursor.next();
                    Packet packet = this.createMessage(room.getRoomJID(), senderJID, dto, addRealJids);
                    results.add(packet);
                }
                Collections.reverse(results);
                writer.write(results);
            }
        }
    }

    public void init(Map<String, Object> props) {
        DBCollection history = !this.db.collectionExists(HISTORY_COLLECTION) ? this.db.createCollection(HISTORY_COLLECTION, (DBObject)new BasicDBObject()) : this.db.getCollection(HISTORY_COLLECTION);
        history.createIndex((DBObject)new BasicDBObject("room_jid_id", (Object)1));
        history.createIndex((DBObject)new BasicDBObject("room_jid_id", (Object)1).append("timestamp", (Object)1));
    }

    public boolean isPersistent() {
        return true;
    }

    public void removeHistory(Room room) {
        try {
            byte[] rid = this.generateId(room.getRoomJID());
            BasicDBObject crit = new BasicDBObject("room_jid_id", (Object)rid).append("room_jid", (Object)room.getRoomJID().toString());
            this.db.getCollection(HISTORY_COLLECTION).remove((DBObject)crit);
        }
        catch (Exception ex) {
            if (this.log.isLoggable(Level.SEVERE)) {
                this.log.log(Level.SEVERE, "Can't remove history", ex);
            }
            throw new RuntimeException(ex);
        }
    }

    public void initRepository(String resource_uri, Map<String, String> params) throws DBInitException {
        try {
            this.resourceUri = resource_uri;
            MongoClientURI uri = new MongoClientURI(resource_uri);
            this.mongo = new MongoClient(uri);
            this.db = this.mongo.getDB(uri.getDatabase());
        }
        catch (UnknownHostException ex) {
            throw new DBInitException("Could not connect to MongoDB server using URI = " + resource_uri, (Throwable)ex);
        }
    }

    private Packet createMessage(BareJID roomJid, JID senderJID, DBObject dto, boolean addRealJids) throws TigaseStringprepException {
        String sender_nickname = (String)dto.get("sender_nickname");
        String msg = (String)dto.get("msg");
        String body = (String)dto.get("body");
        String sender_jid = (String)dto.get("sender_jid");
        Date timestamp = (Date)dto.get("timestamp");
        return this.createMessage(roomJid, senderJID, sender_nickname, msg, body, sender_jid, addRealJids, timestamp);
    }
}

