/*
 * Decompiled with CFR 0.152.
 */
package tigase.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.BulkWriteOperation;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.DuplicateKeyException;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoException;
import com.mongodb.WriteResult;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import tigase.db.AuthRepository;
import tigase.db.AuthRepositoryImpl;
import tigase.db.AuthorizationException;
import tigase.db.DBInitException;
import tigase.db.Repository;
import tigase.db.TigaseDBException;
import tigase.db.UserExistsException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.xmpp.BareJID;

@Repository.Meta(supportedUris={"mongodb:.*"})
public class MongoRepository
implements AuthRepository,
UserRepository {
    private static final String JID_HASH_ALG = "SHA-256";
    private static final String USERS_COLLECTION = "tig_users";
    private static final String NODES_COLLECTION = "tig_nodes";
    private static final String ID_KEY = "user_id";
    private static final String DOMAIN_KEY = "domain";
    private String resourceUri;
    private MongoClient mongo;
    private DB db;
    private AuthRepository auth;

    private byte[] generateId(BareJID user) throws TigaseDBException {
        try {
            MessageDigest md = MessageDigest.getInstance(JID_HASH_ALG);
            return md.digest(user.toString().getBytes());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new TigaseDBException("Should not happen!!", (Throwable)ex);
        }
    }

    public void initRepository(String resource_uri, Map<String, String> params) throws DBInitException {
        try {
            this.resourceUri = resource_uri;
            MongoClientURI uri = new MongoClientURI(resource_uri);
            this.mongo = new MongoClient(uri);
            this.db = this.mongo.getDB(uri.getDatabase());
            DBCollection users = null;
            users = !this.db.collectionExists(USERS_COLLECTION) ? this.db.createCollection(USERS_COLLECTION, (DBObject)new BasicDBObject()) : this.db.getCollection(USERS_COLLECTION);
            DBCollection nodes = this.db.collectionExists(NODES_COLLECTION) ? this.db.getCollection(NODES_COLLECTION) : this.db.createCollection(NODES_COLLECTION, (DBObject)new BasicDBObject());
            nodes.createIndex((DBObject)new BasicDBObject("uid", (Object)1));
            nodes.createIndex((DBObject)new BasicDBObject("node", (Object)1));
            nodes.createIndex((DBObject)new BasicDBObject("key", (Object)1));
            this.auth = new AuthRepositoryImpl(this){

                public String getPassword(BareJID user) throws TigaseDBException {
                    try {
                        byte[] id = MongoRepository.this.generateId(user);
                        DBObject userDto = MongoRepository.this.db.getCollection(MongoRepository.USERS_COLLECTION).findOne((DBObject)new BasicDBObject("_id", (Object)id).append(MongoRepository.ID_KEY, (Object)user.toString()));
                        if (userDto == null) {
                            throw new UserNotFoundException("User " + user + " not found in repository");
                        }
                        return (String)userDto.get("password");
                    }
                    catch (MongoException ex) {
                        throw new TigaseDBException("Error retrieving password for user " + user, (Throwable)ex);
                    }
                }

                public void updatePassword(BareJID user, String password) throws TigaseDBException {
                    try {
                        byte[] id = MongoRepository.this.generateId(user);
                        WriteResult result = MongoRepository.this.db.getCollection(MongoRepository.USERS_COLLECTION).update((DBObject)new BasicDBObject("_id", (Object)id).append(MongoRepository.ID_KEY, (Object)user.toString()), (DBObject)new BasicDBObject("$set", (Object)new BasicDBObject("password", (Object)password)));
                        if (result == null || !result.isUpdateOfExisting()) {
                            throw new UserNotFoundException("User " + user + " not found in repository");
                        }
                    }
                    catch (MongoException ex) {
                        throw new TigaseDBException("Error retrieving password for user " + user, (Throwable)ex);
                    }
                }
            };
        }
        catch (UnknownHostException ex) {
            throw new DBInitException("Could not connect to MongoDB server using URI = " + resource_uri, (Throwable)ex);
        }
    }

    private Object addUserRepo(BareJID user) throws UserExistsException, TigaseDBException {
        try {
            BasicDBObject userDto = new BasicDBObject().append(ID_KEY, (Object)user.toString());
            userDto.append(DOMAIN_KEY, (Object)user.getDomain());
            byte[] id = this.generateId(user);
            userDto.append("_id", (Object)id);
            return this.db.getCollection(USERS_COLLECTION).insert(new DBObject[]{userDto}).getUpsertedId();
        }
        catch (DuplicateKeyException ex) {
            throw new UserExistsException("Error adding user to repository: ", (Throwable)ex);
        }
        catch (MongoException ex) {
            throw new TigaseDBException("Error adding user to repository: ", (Throwable)ex);
        }
    }

    public void addDataList(BareJID user, String subnode, String key, String[] list) throws UserNotFoundException, TigaseDBException {
        try {
            byte[] uid = this.generateId(user);
            BasicDBObject dto = new BasicDBObject("uid", (Object)uid).append("node", (Object)subnode).append("key", (Object)key).append("values", (Object)list);
            this.db.getCollection(NODES_COLLECTION).insert(new DBObject[]{dto});
        }
        catch (MongoException ex) {
            throw new TigaseDBException("Problem adding data list to repository", (Throwable)ex);
        }
    }

    public void addUser(BareJID user) throws UserExistsException, TigaseDBException {
        this.addUserRepo(user);
    }

    private BasicDBObject createCrit(BareJID user, String subnode, String key) throws TigaseDBException {
        byte[] uid = this.generateId(user);
        BasicDBObject crit = new BasicDBObject("uid", (Object)uid);
        if (key != null) {
            crit.append("key", (Object)key);
        }
        if (subnode == null) {
            crit.append("node", (Object)new BasicDBObject("$exists", (Object)false));
        } else {
            crit.append("node", (Object)subnode);
        }
        return crit;
    }

    private DBObject getDataInt(BareJID user, String subnode, String key) throws TigaseDBException {
        BasicDBObject crit = this.createCrit(user, subnode, key);
        return this.db.getCollection(NODES_COLLECTION).findOne((DBObject)crit);
    }

    public String getData(BareJID user, String subnode, String key, String def) throws UserNotFoundException, TigaseDBException {
        String value = this.getData(user, subnode, key);
        if (value == null) {
            value = def;
        }
        return value;
    }

    public String getData(BareJID user, String subnode, String key) throws UserNotFoundException, TigaseDBException {
        try {
            DBObject result = this.getDataInt(user, subnode, key);
            return result != null ? (String)result.get("value") : null;
        }
        catch (MongoException ex) {
            throw new TigaseDBException("Problem retrieving data from repository", (Throwable)ex);
        }
    }

    public String getData(BareJID user, String key) throws UserNotFoundException, TigaseDBException {
        try {
            DBObject result = this.getDataInt(user, null, key);
            return result != null ? (String)result.get("value") : null;
        }
        catch (MongoException ex) {
            throw new TigaseDBException("Problem retrieving data from repository", (Throwable)ex);
        }
    }

    public String[] getDataList(BareJID user, String subnode, String key) throws UserNotFoundException, TigaseDBException {
        try (DBCursor cursor = null;){
            ArrayList<String> values = new ArrayList<String>();
            BasicDBObject crit = this.createCrit(user, subnode, key);
            cursor = this.db.getCollection(NODES_COLLECTION).find((DBObject)crit);
            while (cursor.hasNext()) {
                DBObject it = cursor.next();
                if (it.containsField("values")) {
                    values.addAll((List)it.get("values"));
                    continue;
                }
                if (!it.containsField("value")) continue;
                values.add((String)it.get("value"));
            }
            String[] stringArray = values.toArray(new String[values.size()]);
            return stringArray;
        }
    }

    public String[] getKeys(BareJID user, String subnode) throws UserNotFoundException, TigaseDBException {
        try {
            BasicDBObject crit = this.createCrit(user, subnode, null);
            List result = this.db.getCollection(NODES_COLLECTION).distinct("key", (DBObject)crit);
            return result.toArray(new String[result.size()]);
        }
        catch (MongoException ex) {
            throw new TigaseDBException("Problem retrieving keys for " + user + " and subnode " + subnode + " from repository", (Throwable)ex);
        }
    }

    public String[] getKeys(BareJID user) throws UserNotFoundException, TigaseDBException {
        return this.getKeys(user, null);
    }

    public String getResourceUri() {
        return this.resourceUri;
    }

    public List<BareJID> getUsers() throws TigaseDBException {
        ArrayList<BareJID> users = new ArrayList<BareJID>(1000);
        try (DBCursor cursor = null;){
            cursor = this.db.getCollection(USERS_COLLECTION).find((DBObject)new BasicDBObject(), (DBObject)new BasicDBObject(ID_KEY, (Object)1));
            while (cursor.hasNext()) {
                DBObject entry = cursor.next();
                users.add(BareJID.bareJIDInstanceNS((String)((String)entry.get(ID_KEY))));
            }
        }
        return users;
    }

    public long getUsersCount() {
        try {
            return this.db.getCollection(USERS_COLLECTION).count();
        }
        catch (MongoException ex) {
            return -1L;
        }
    }

    public long getUsersCount(String domain) {
        try {
            BasicDBObject crit = new BasicDBObject();
            if (DOMAIN_KEY == null) {
                crit.append(DOMAIN_KEY, (Object)domain);
            } else {
                Pattern regex = Pattern.compile(".+@" + domain.replace(".", "\\.") + "$", 2);
                crit.append(ID_KEY, (Object)regex);
            }
            return this.db.getCollection(USERS_COLLECTION).count((DBObject)crit);
        }
        catch (MongoException ex) {
            return -1L;
        }
    }

    public boolean userExists(BareJID user) {
        try {
            BasicDBObject userDto = new BasicDBObject();
            byte[] id = this.generateId(user);
            userDto.append("_id", (Object)id);
            userDto.append(ID_KEY, (Object)user.toString());
            return this.db.getCollection(USERS_COLLECTION).count((DBObject)userDto) > 0L;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setDataList(BareJID user, String subnode, String key, String[] list) throws UserNotFoundException, TigaseDBException {
        try {
            BasicDBObject crit = this.createCrit(user, subnode, key);
            BasicDBObject dto = new BasicDBObject((Map)crit).append("values", (Object)list);
            if (subnode == null) {
                dto.remove((Object)"node");
            }
            BulkWriteOperation builder = this.db.getCollection(NODES_COLLECTION).initializeOrderedBulkOperation();
            builder.find((DBObject)crit).remove();
            builder.insert((DBObject)dto);
            builder.execute();
        }
        catch (MongoException ex) {
            throw new TigaseDBException("Problem setting values in repository", (Throwable)ex);
        }
    }

    public void setData(BareJID user, String key, String value) throws UserNotFoundException, TigaseDBException {
        this.setData(user, null, key, value);
    }

    public void setData(BareJID user, String subnode, String key, String value) throws UserNotFoundException, TigaseDBException {
        try {
            BasicDBObject crit = this.createCrit(user, subnode, key);
            BasicDBObject dto = new BasicDBObject((Map)crit).append("value", (Object)value);
            if (subnode == null) {
                dto.remove((Object)"node");
            }
            this.db.getCollection(NODES_COLLECTION).update((DBObject)crit, (DBObject)dto, true, false);
        }
        catch (MongoException ex) {
            throw new TigaseDBException("Problem setting values in repository", (Throwable)ex);
        }
    }

    public void removeUser(BareJID user) throws UserNotFoundException, TigaseDBException {
        try {
            BasicDBObject userDto = new BasicDBObject();
            byte[] id = this.generateId(user);
            userDto.append("_id", (Object)id);
            userDto.append(ID_KEY, (Object)user.toString());
            this.db.getCollection(USERS_COLLECTION).remove((DBObject)userDto);
            this.removeSubnode(user, null);
        }
        catch (MongoException e) {
            throw new TigaseDBException("Error removing user from repository: ", (Throwable)e);
        }
    }

    public void removeSubnode(BareJID user, String subnode) throws UserNotFoundException, TigaseDBException {
        try {
            byte[] uid = this.generateId(user);
            BasicDBObject crit = new BasicDBObject("uid", (Object)uid);
            Pattern regex = Pattern.compile("^" + (subnode != null ? subnode + "/" : "") + "[^/]*", 2);
            crit.append("node", (Object)regex);
            this.db.getCollection(NODES_COLLECTION).remove((DBObject)crit);
        }
        catch (MongoException ex) {
            throw new TigaseDBException("Error removing subnode from repository: ", (Throwable)ex);
        }
    }

    public void removeData(BareJID user, String key) throws UserNotFoundException, TigaseDBException {
        this.removeData(user, null, key);
    }

    public void removeData(BareJID user, String subnode, String key) throws UserNotFoundException, TigaseDBException {
        try {
            BasicDBObject crit = this.createCrit(user, subnode, key);
            this.db.getCollection(NODES_COLLECTION).remove((DBObject)crit);
        }
        catch (MongoException ex) {
            throw new TigaseDBException("Error data from repository: ", (Throwable)ex);
        }
    }

    @Deprecated
    public long getUserUID(BareJID user) throws TigaseDBException {
        return 0L;
    }

    public String[] getSubnodes(BareJID user) throws UserNotFoundException, TigaseDBException {
        return this.getSubnodes(user, null);
    }

    public String[] getSubnodes(BareJID user, String subnode) throws UserNotFoundException, TigaseDBException {
        try {
            byte[] uid = this.generateId(user);
            BasicDBObject crit = new BasicDBObject("uid", (Object)uid);
            Pattern regex = Pattern.compile("^" + (subnode != null ? subnode + "/" : "") + "[^/]*", 2);
            crit.append("node", (Object)regex);
            List result = this.db.getCollection(NODES_COLLECTION).distinct("node", (DBObject)crit);
            ArrayList<String> res = new ArrayList<String>();
            for (String node : result) {
                int idx;
                if (subnode != null) {
                    node = node.substring(subnode.length() + 1);
                }
                if ((idx = node.indexOf("/")) > 0) {
                    node = node.substring(0, idx);
                }
                if (res.contains(node)) continue;
                res.add(node);
            }
            return res.isEmpty() ? null : res.toArray(new String[res.size()]);
        }
        catch (MongoException ex) {
            throw new TigaseDBException("Error removing subnode from repository: ", (Throwable)ex);
        }
    }

    public void addUser(BareJID user, String password) throws UserExistsException, TigaseDBException {
        this.auth.addUser(user, password);
    }

    public boolean digestAuth(BareJID user, String digest, String id, String alg) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        return this.auth.digestAuth(user, digest, id, alg);
    }

    public void logout(BareJID user) throws UserNotFoundException, TigaseDBException {
        this.auth.logout(user);
    }

    public boolean otherAuth(Map<String, Object> authProps) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        return this.auth.otherAuth(authProps);
    }

    public boolean plainAuth(BareJID user, String password) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        return this.auth.plainAuth(user, password);
    }

    public void queryAuth(Map<String, Object> authProps) {
        this.auth.queryAuth(authProps);
    }

    public String getPassword(BareJID user) throws UserNotFoundException, TigaseDBException {
        return null;
    }

    public void updatePassword(BareJID user, String password) throws UserNotFoundException, TigaseDBException {
        this.auth.updatePassword(user, password);
    }
}

