/*
 * Decompiled with CFR 0.152.
 */
package tigase.mix.adhoc;

import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.adhoc.AdHocCommand;
import tigase.component.adhoc.AdHocCommandException;
import tigase.component.adhoc.AdHocResponse;
import tigase.component.adhoc.AdhHocRequest;
import tigase.xml.Element;
import tigase.xmpp.Authorization;

public abstract class AbstractAdhocCommand
implements AdHocCommand {
    private static final Logger log = Logger.getLogger(AbstractAdhocCommand.class.getCanonicalName());
    private final String name;
    private final String node;

    protected AbstractAdhocCommand(String node, String name) {
        this.name = name;
        this.node = node;
    }

    public String getName() {
        return this.name;
    }

    public String getNode() {
        return this.node;
    }

    public void execute(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
        try {
            Element responseForm;
            Element data = request.getCommand().getChild("x", "jabber:x:data");
            if (request.isAction("cancel")) {
                response.cancelSession();
            } else if (data == null) {
                response.getElements().add(this.prepareForm(request, response));
                response.startSession();
            } else if ("submit".equals(data.getAttributeStaticStr("type")) && (responseForm = this.submitForm(request, response, data)) != null) {
                response.getElements().add(responseForm);
            }
        }
        catch (AdHocCommandException ex) {
            throw ex;
        }
        catch (Exception e) {
            log.log(Level.FINE, "Exception during execution of adhoc command " + this.getNode(), e);
            throw new AdHocCommandException(Authorization.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    protected abstract Element prepareForm(AdhHocRequest var1, AdHocResponse var2) throws AdHocCommandException;

    protected abstract Element submitForm(AdhHocRequest var1, AdHocResponse var2, Element var3) throws AdHocCommandException;

    protected String assertNotEmpty(String input, String message) throws AdHocCommandException {
        if (input == null || input.isBlank()) {
            throw new AdHocCommandException(Authorization.BAD_REQUEST, message);
        }
        return input.trim();
    }
}

