/*
 * Decompiled with CFR 0.152.
 */
package tigase.mix.modules;

import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.criteria.Criteria;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.mix.IMixComponent;
import tigase.mix.model.IParticipant;
import tigase.mix.model.MixAction;
import tigase.mix.model.MixLogic;
import tigase.mix.model.MixRepository;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.exceptions.PubSubException;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="channelRelayModule", parent=IMixComponent.class, active=true)
public class ChannelRelayModule
extends AbstractPubSubModule {
    private static final Criteria CRIT_RELAY = new Criteria(){

        public Criteria add(Criteria criteria) {
            return null;
        }

        public boolean match(Element element) {
            if (element.getName() != "iq" && element.getName() != "presence") {
                return false;
            }
            String to = element.getAttributeStaticStr("to");
            if (to == null) {
                return false;
            }
            JID jid = JID.jidInstanceNS((String)to);
            if (jid.getLocalpart() == null) {
                return false;
            }
            return jid.getLocalpart().contains("#");
        }
    };
    @Inject
    private MixRepository mixRepository;
    @Inject
    private MixLogic mixLogic;

    public Criteria getModuleCriteria() {
        return CRIT_RELAY;
    }

    public boolean canHandle(Packet packet) {
        if (packet.getElemName() != "iq" && packet.getElemName() != "message") {
            return false;
        }
        JID jid = packet.getStanzaTo();
        if (jid == null || jid.getLocalpart() == null) {
            return false;
        }
        return jid.getLocalpart().contains("#");
    }

    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        JID to = packet.getStanzaTo();
        if (to == null || to.getLocalpart() == null) {
            throw new PubSubException(Authorization.BAD_REQUEST);
        }
        int idx = to.getLocalpart().indexOf(35);
        String recipientId = to.getLocalpart().substring(0, idx);
        BareJID channelJID = BareJID.bareJIDInstanceNS((String)to.getLocalpart().substring(idx + 1), (String)to.getDomain());
        BareJID senderJID = packet.getStanzaFrom().getBareJID();
        try {
            this.mixLogic.checkPermission(channelJID, senderJID, MixAction.relay);
            IParticipant recipient = this.mixRepository.getParticipant(channelJID, recipientId);
            IParticipant sender = this.mixRepository.getParticipant(channelJID, senderJID);
            if (recipient == null || sender == null) {
                throw new PubSubException(Authorization.ITEM_NOT_FOUND);
            }
            Packet forward = packet.copyElementOnly();
            forward.initVars(JID.jidInstanceNS((String)(sender.getParticipantId() + "#" + channelJID.getLocalpart()), (String)channelJID.getDomain(), (String)packet.getStanzaFrom().getResource()), JID.jidInstanceNS((BareJID)recipient.getRealJid(), (String)packet.getStanzaTo().getResource()));
            this.packetWriter.write(forward);
        }
        catch (RepositoryException ex) {
            throw new PubSubException(Authorization.INTERNAL_SERVER_ERROR, null, (Exception)((Object)ex));
        }
    }
}

