/*
 * Decompiled with CFR 0.152.
 */
package tigase.mix.modules;

import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.mix.IMixComponent;
import tigase.mix.model.MixAction;
import tigase.mix.model.MixLogic;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.PublishItemModule;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;

@Bean(name="channelDestroyModule", parent=IMixComponent.class, active=true)
public class ChannelDestroyModule
extends AbstractPubSubModule {
    private static final Criteria CRIT_DESTROY = ElementCriteria.nameType((String)"iq", (String)"set").add((Criteria)ElementCriteria.name((String)"destroy", (String)"urn:xmpp:mix:core:1"));
    private static final String[] DESTROY_PATH = new String[]{"iq", "destroy"};
    @Inject
    private MixLogic mixLogic;
    @Inject
    private PublishItemModule publishModule;

    public Criteria getModuleCriteria() {
        return CRIT_DESTROY;
    }

    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        if (packet.getStanzaTo().getLocalpart() != null) {
            throw new PubSubException(Authorization.BAD_REQUEST);
        }
        String channel = packet.getAttributeStaticStr(DESTROY_PATH, "channel");
        if (channel == null) {
            throw new PubSubException(Authorization.BAD_REQUEST);
        }
        BareJID channelJID = BareJID.bareJIDInstanceNS((String)channel, (String)packet.getStanzaTo().getDomain());
        try {
            this.mixLogic.checkPermission(channelJID, packet.getStanzaFrom().getBareJID(), MixAction.manage);
            String[] nodes = this.getRepository().getRootCollection(channelJID);
            if (nodes != null) {
                for (String node : nodes) {
                    AbstractNodeConfig config = this.getRepository().getNodeConfig(channelJID, node);
                    if (config == null) continue;
                    Element del = new Element("delete", new String[]{"node"}, new String[]{node});
                    this.publishModule.generateNodeNotifications(channelJID, node, del, null, false);
                }
            }
            this.getRepository().deleteService(channelJID);
            this.packetWriter.write(packet.okResult((Element)null, 0));
        }
        catch (RepositoryException ex) {
            throw new PubSubException(Authorization.INTERNAL_SERVER_ERROR, null, (Exception)((Object)ex));
        }
    }
}

