/*
 * Decompiled with CFR 0.152.
 */
package tigase.mix.model;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.ScheduledTask;
import tigase.component.exceptions.RepositoryException;
import tigase.eventbus.EventBus;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.mix.model.RoomPresenceRepository;
import tigase.mix.modules.RoomPresenceModule;
import tigase.pubsub.CollectionItemsOrdering;
import tigase.pubsub.repository.IItems;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.server.AbstractMessageReceiver;
import tigase.server.Packet;
import tigase.server.ReceiverTimeoutHandler;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.vhosts.VHostManagerIfc;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="roomGhostbuster", parent=RoomPresenceModule.class, active=true)
public class RoomGhostbuster
extends ScheduledTask {
    private static final Logger log = Logger.getLogger(RoomGhostbuster.class.getCanonicalName());
    private static final Set<String> REASONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("gone", "item-not-found", "policy-violation", "recipient-unavailable", "redirect", "remote-server-not-found", "remote-server-timeout", "service-unavailable")));
    private final ConcurrentHashMap<JID, MonitoredObject> monitoredObjects = new ConcurrentHashMap();
    private final ReceiverTimeoutHandler pingTimeoutHandler = new ReceiverTimeoutHandler(){

        public void responseReceived(Packet data, Packet response) {
            block2: {
                try {
                    RoomGhostbuster.this.onPingReceived(response);
                }
                catch (Exception e) {
                    if (!log.isLoggable(Level.WARNING)) break block2;
                    log.log(Level.WARNING, "Problem on handling ping response", e);
                }
            }
        }

        public void timeOutExpired(Packet data) {
            block3: {
                try {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Received ping timeout for ping " + data.getElement().getAttributeStaticStr("id"));
                    }
                    RoomGhostbuster.this.onPingTimeout(data.getStanzaTo());
                }
                catch (Exception e) {
                    if (!log.isLoggable(Level.WARNING)) break block3;
                    log.log(Level.WARNING, "Problem on handling ping timeout", e);
                }
            }
        }
    };
    @Inject(bean="service")
    private AbstractMessageReceiver component;
    @Inject(nullAllowed=true)
    private GhostbusterFilter filter;
    @Inject
    private EventBus eventBus;
    @Inject
    private IPubSubRepository pubSubRepository;
    @Inject
    private VHostManagerIfc vHostManager;
    @Inject
    private RoomPresenceRepository roomPresenceRepository;
    private boolean firstRun = true;

    public RoomGhostbuster() {
        super(Duration.ofMinutes(10L), Duration.ofMinutes(5L));
    }

    public void register(BareJID channelJID, JID occupantJID) {
        MonitoredObject object = this.registerInternal(channelJID, occupantJID);
        if (object != null) {
            object.updateLastActivity();
        }
    }

    private MonitoredObject registerInternal(BareJID channelJID, JID occupantJID) {
        return this.monitoredObjects.compute(occupantJID, (k, prev) -> {
            MonitoredObject o = prev == null ? new MonitoredObject(occupantJID) : prev;
            o.addChannel(channelJID);
            return o;
        });
    }

    public void unregister(BareJID channelJID, JID occupantJID) {
        this.monitoredObjects.computeIfPresent(occupantJID, (k, o) -> {
            o.updateLastActivity();
            o.removeChannel(channelJID);
            return o.isEmpty() ? null : o;
        });
    }

    public void run() {
        try {
            if (this.firstRun) {
                this.firstRun = false;
                ForkJoinPool.commonPool().submit(() -> {
                    try {
                        for (JID vhost : this.vHostManager.getAllVHosts()) {
                            List channels = this.pubSubRepository.getServices(BareJID.bareJIDInstanceNS(null, (String)(this.component.getName() + "." + vhost.getDomain())), null);
                            if (channels == null) continue;
                            for (BareJID channel : channels) {
                                String[] ids;
                                IItems items = this.pubSubRepository.getNodeItems(channel, "urn:xmpp:mix:nodes:participants");
                                if (items == null || (ids = items.getItemsIds(CollectionItemsOrdering.byUpdateDate)) == null) continue;
                                Set<String> participantIds = this.roomPresenceRepository.getRoomParticipantsIds(channel);
                                for (String id : ids) {
                                    Element participantEl;
                                    IItems.IItem item;
                                    if (!id.startsWith("temp-") || participantIds.contains(id) || (item = items.getItem(id)) == null || (participantEl = item.getItem().getChild("participant", "urn:xmpp:mix:core:1")) == null) continue;
                                    String jid = participantEl.getChildCData(el -> el.getName() == "jid");
                                    String resource = participantEl.getChildCData(el -> el.getName() == "resource" && el.getXMLNS() == "tigase:mix:muc:0");
                                    if (jid == null || resource == null) continue;
                                    this.eventBus.fire((Object)new KickoutEvent(this.component.getName(), channel, JID.jidInstanceNS((BareJID)BareJID.bareJIDInstanceNS((String)jid), (String)resource)));
                                }
                            }
                        }
                    }
                    catch (RepositoryException ex) {
                        log.log(Level.WARNING, "failed to load temporary occupants from database to ghostbuster!", ex);
                    }
                });
            }
            long border = System.currentTimeMillis() - 3600000L;
            this.monitoredObjects.values().stream().filter(obj -> !obj.wasActiveSince(border)).filter(obj -> this.filter == null || this.filter.shouldSendPing(obj.getOccupantJID())).forEach(this::pingMonitoredObject);
        }
        catch (Throwable ex) {
            log.log(Level.FINEST, "exception during pinging room occupant", ex);
        }
    }

    protected void pingMonitoredObject(MonitoredObject monitoredObject) {
        try {
            BareJID sourceJID = monitoredObject.getPingSource();
            if (sourceJID == null) {
                return;
            }
            Packet packet = this.createPing(sourceJID, monitoredObject.getOccupantJID());
            this.component.addOutPacketWithTimeout(packet, this.pingTimeoutHandler, 1L, TimeUnit.MINUTES);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Pinged " + monitoredObject.getOccupantJID());
            }
        }
        catch (Throwable ex) {
            log.log(Level.FINEST, "exception during pinging room occupant", ex);
        }
    }

    protected Packet createPing(BareJID sourceJID, JID destinationJID) throws TigaseStringprepException {
        String id = "png-" + UUID.randomUUID().toString();
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Pinging " + destinationJID + ". id=" + id);
        }
        Element ping = new Element("iq", new String[]{"type", "id", "from", "to"}, new String[]{"get", id, sourceJID.toString(), destinationJID.toString()});
        ping.addChild((XMLNodeIfc)new Element("ping", new String[]{"xmlns"}, new String[]{"urn:xmpp:ping"}));
        Packet packet = Packet.packetInstance((Element)ping);
        packet.setXMLNS("jabber:client");
        return packet;
    }

    protected void onPingReceived(Packet packet) throws TigaseStringprepException {
        if (packet.getStanzaFrom() == null) {
            return;
        }
        MonitoredObject o = this.monitoredObjects.get(packet.getStanzaFrom());
        if (o == null) {
            return;
        }
        if (packet.getType() == StanzaType.error && Optional.ofNullable(packet.getElement()).map(el -> el.getChild("error")).filter(elem -> Optional.ofNullable(elem.getChildren()).filter(el -> el.stream().anyMatch(e -> (e.getXMLNS() == null || e.getXMLNS() == "urn:ietf:params:xml:ns:xmpp-stanzas") && REASONS.contains(e.getName()))).isPresent()).isPresent()) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Received presence error: " + packet.getElement().toString());
            }
            for (BareJID channel : o.getChannels()) {
                this.eventBus.fire((Object)new KickoutEvent(this.component.getName(), channel, o.occupantJID));
            }
        } else {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Update activity of " + o.getOccupantJID());
            }
            o.updateLastActivity();
        }
    }

    protected void onPingTimeout(JID stanzaTo) throws TigaseStringprepException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Timeouted ping to: " + stanzaTo);
        }
    }

    public class KickoutEvent {
        private final String componentName;
        private final BareJID channelJID;
        private final JID occupantJID;

        public KickoutEvent(String componentName, BareJID channelJID, JID occupantJID) {
            this.componentName = componentName;
            this.channelJID = channelJID;
            this.occupantJID = occupantJID;
        }

        public String getComponentName() {
            return this.componentName;
        }

        public BareJID getChannelJID() {
            return this.channelJID;
        }

        public JID getOccupantJID() {
            return this.occupantJID;
        }
    }

    @FunctionalInterface
    public static interface GhostbusterFilter {
        public boolean shouldSendPing(JID var1);
    }

    protected class MonitoredObject {
        private final JID occupantJID;
        private long lastActivity = 0L;
        private HashSet<BareJID> channels = new HashSet();

        public MonitoredObject(JID occupantJID) {
            this.occupantJID = occupantJID;
        }

        public JID getOccupantJID() {
            return this.occupantJID;
        }

        public synchronized BareJID getPingSource() {
            if (!this.channels.isEmpty()) {
                return this.channels.iterator().next();
            }
            return null;
        }

        public synchronized boolean wasActiveSince(long since) {
            return this.lastActivity > since;
        }

        protected synchronized void updateLastActivity() {
            this.lastActivity = System.currentTimeMillis();
        }

        protected synchronized void addChannel(BareJID channel) {
            this.channels.add(channel);
        }

        protected synchronized void removeChannel(BareJID channel) {
            this.channels.remove(channel);
        }

        protected synchronized BareJID[] getChannels() {
            return this.channels.toArray(new BareJID[this.channels.size()]);
        }

        protected synchronized boolean isEmpty() {
            return this.channels.isEmpty();
        }
    }
}

