/*
 * Decompiled with CFR 0.152.
 */
package tigase.mix.model;

import java.util.List;
import tigase.mix.model.IParticipant;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.jid.BareJID;

public class Participant
implements IParticipant {
    private final String participantId;
    private BareJID realJid;
    private String nick;

    public Participant(String participantId, BareJID realJid, String nick) {
        this.participantId = participantId;
        this.realJid = realJid;
        this.nick = nick;
    }

    public Participant(String participantId, Element participantEl) {
        this.participantId = participantId;
        List children = participantEl.getChildren();
        if (children != null) {
            for (Element child : children) {
                switch (child.getName()) {
                    case "jid": {
                        this.realJid = BareJID.bareJIDInstanceNS((String)child.getCData());
                        break;
                    }
                    case "nick": {
                        this.nick = child.getCData();
                        break;
                    }
                }
            }
        }
    }

    @Override
    public String getParticipantId() {
        return this.participantId;
    }

    @Override
    public BareJID getRealJid() {
        return this.realJid;
    }

    @Override
    public String getNick() {
        return this.nick;
    }

    @Override
    public Element toElement() {
        Element participantEl = new Element("participant");
        participantEl.setXMLNS("urn:xmpp:mix:core:1");
        if (this.nick != null) {
            participantEl.addChild((XMLNodeIfc)new Element("nick", this.nick));
        }
        if (this.realJid != null) {
            participantEl.addChild((XMLNodeIfc)new Element("jid", this.realJid.toString()));
        }
        return participantEl;
    }
}

