/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.db;

import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import tigase.archive.db.AbstractMessageArchiveRepositoryTest;
import tigase.archive.db.JDBCMessageArchiveRepository;
import tigase.archive.db.MessageArchiveRepository;
import tigase.db.DBInitException;
import tigase.db.DataRepository;
import tigase.db.RepositoryFactory;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.jid.JID;

public class JDBCMessageArchiveRepositoryTest
extends AbstractMessageArchiveRepositoryTest<DataRepository, MessageArchiveRepository> {
    private static final String PROJECT_ID = "message-archiving";
    private static final String VERSION = "3.1.0-SNAPSHOT";
    @ClassRule
    public static TestRule rule = new TestRule(){

        public Statement apply(Statement stmnt, Description d) {
            if (uri == null || !uri.startsWith("jdbc:")) {
                return new Statement(){

                    public void evaluate() throws Throwable {
                        Assume.assumeTrue((String)"Ignored due to not passed DB URI!", (boolean)false);
                    }
                };
            }
            return stmnt;
        }
    };

    @BeforeClass
    public static void loadSchema() throws DBInitException {
        JDBCMessageArchiveRepositoryTest.loadSchema((String)PROJECT_ID, (String)VERSION, Collections.singleton("message-archive"));
    }

    @Ignore
    @Test
    public void testDeadlocksOnInsert() throws InterruptedException, ClassNotFoundException, SQLException, InstantiationException, IllegalAccessException {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("data-repo-pool-size", "40");
            DataRepository dataRepo = RepositoryFactory.getDataRepository(null, (String)uri, params);
            final JDBCMessageArchiveRepository repo = new JDBCMessageArchiveRepository();
            repo.setDataSource(dataRepo);
            ArrayDeque<2> threads = new ArrayDeque<2>();
            for (int i = 0; i < 128; ++i) {
                final int ti = i;
                final JID jid = JID.jidInstanceNS((String)("user-" + i + "@test-domain.com/res-1"));
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        try {
                            for (int j = 0; j < 1000; ++j) {
                                Element message = new Element("message", new String[]{"from", "to", "type", "id"}, new String[]{jid.toString(), jid.getBareJID().toString(), "set", UUID.randomUUID().toString()});
                                message.addChild((XMLNodeIfc)new Element("bind", UUID.randomUUID().toString(), new String[]{"action"}, new String[]{"login"}));
                                repo.archiveMessage(jid.getBareJID(), jid, new Date(), message, UUID.randomUUID().toString(), new HashSet());
                            }
                            System.out.println("executed last insert for thread " + ti);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                };
                threads.offer(t);
                t.start();
            }
            Thread t = null;
            while ((t = (Thread)threads.poll()) != null) {
                t.join();
            }
        }
        catch (DBInitException ex) {
            ex.printStackTrace();
        }
    }
}

