/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.db;

import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.MethodSorters;
import org.junit.runners.model.Statement;
import tigase.archive.QueryCriteria;
import tigase.archive.db.MessageArchiveRepository;
import tigase.archive.xep0136.Query;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.db.AbstractDataSourceAwareTestCase;
import tigase.db.DataSource;
import tigase.db.DataSourceAware;
import tigase.db.TigaseDBException;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;
import tigase.xmpp.mam.MAMRepository;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public abstract class AbstractMessageArchiveRepositoryTest<DS extends DataSource, R extends MessageArchiveRepository>
extends AbstractDataSourceAwareTestCase<DS, R> {
    private static final SimpleDateFormat formatter2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXX");
    protected static String emoji = "\ud83d\ude97\ud83d\udca9\ud83d\ude21";
    @ClassRule
    public static TestRule rule = new TestRule(){

        public Statement apply(Statement stmnt, Description d) {
            if (uri == null) {
                return new Statement(){

                    public void evaluate() throws Throwable {
                        Assume.assumeTrue((String)"Ignored due to not passed DB URI!", (boolean)false);
                    }
                };
            }
            return stmnt;
        }
    };
    private static JID buddy = null;
    private static JID buddy2 = null;
    private static JID owner = null;
    private static Date testStart = null;
    protected boolean checkEmoji = true;
    protected DataSource dataSource;
    protected MessageArchiveRepository<QueryCriteria, DataSource> repo;
    private static List<String> archivedMessagesIds;

    @BeforeClass
    public static void initialize() {
        owner = JID.jidInstanceNS((String)("UA-" + UUID.randomUUID()), (String)"test", (String)"tigase-1");
        buddy = JID.jidInstanceNS((String)("UA-" + UUID.randomUUID()), (String)"test", (String)"tigase-2");
        buddy2 = JID.jidInstanceNS((String)("UA-" + UUID.randomUUID()), (String)"test", (String)"tigase-3");
    }

    @Before
    public void setup() {
        this.repo = (MessageArchiveRepository)this.getDataSourceAware();
    }

    @Test
    public void test1_archiveMessage1() throws RepositoryException, ComponentException {
        if (uri == null) {
            return;
        }
        Date date = new Date();
        Object body = "Test 1";
        if (this.checkEmoji) {
            body = (String)body + emoji;
        }
        Element msg = new Element("message", new String[]{"from", "to", "type"}, new String[]{owner.toString(), buddy2.toString(), StanzaType.chat.name()});
        msg.addChild((XMLNodeIfc)new Element("body", (String)body));
        String stableId = UUID.randomUUID().toString();
        this.repo.archiveMessage(owner.getBareJID(), buddy2, date, msg, stableId, null);
        archivedMessagesIds.add(stableId);
        QueryCriteria crit = (QueryCriteria)this.repo.newQuery();
        crit.setQuestionerJID(owner.copyWithoutResource());
        crit.setWith(buddy2.copyWithoutResource());
        crit.setStart(date);
        crit.getRsm().setIndex(Integer.valueOf(0));
        crit.getRsm().setMax(1);
        ArrayList msgs = new ArrayList();
        this.repo.queryItems((tigase.xmpp.mam.Query)crit, (qc, item) -> {
            item.getMessage().setName(((MessageArchiveRepository.Item)item).getDirection().toElementName());
            msgs.add(item.getMessage());
        });
        Assert.assertEquals((String)"Incorrect number of message", (long)1L, (long)msgs.size());
        Element res = (Element)msgs.get(0);
        Assert.assertEquals((String)"Incorrect direction", (Object)MessageArchiveRepository.Direction.outgoing.toElementName(), (Object)res.getName());
        Assert.assertEquals((String)"Incorrect message body", (Object)body, (Object)res.getChildCData(res.getName() + "/body"));
    }

    @Test
    public void test1_archiveMessage2() throws RepositoryException, ComponentException {
        Date date;
        if (uri == null) {
            return;
        }
        testStart = date = new Date();
        Object body = "Test 1";
        if (this.checkEmoji) {
            body = (String)body + emoji;
        }
        Element msg = new Element("message", new String[]{"from", "to", "type"}, new String[]{owner.toString(), buddy.toString(), StanzaType.chat.name()});
        msg.addChild((XMLNodeIfc)new Element("body", (String)body));
        String stableId = UUID.randomUUID().toString();
        this.repo.archiveMessage(owner.getBareJID(), buddy, date, msg, stableId, null);
        archivedMessagesIds.add(stableId);
        QueryCriteria crit = (QueryCriteria)this.repo.newQuery();
        crit.setQuestionerJID(owner.copyWithoutResource());
        crit.setWith(buddy.copyWithoutResource());
        crit.setStart(date);
        crit.getRsm().setIndex(Integer.valueOf(0));
        crit.getRsm().setMax(1);
        ArrayList msgs = new ArrayList();
        this.repo.queryItems((tigase.xmpp.mam.Query)crit, (qc, item) -> {
            item.getMessage().setName(((MessageArchiveRepository.Item)item).getDirection().toElementName());
            msgs.add(item.getMessage());
        });
        Assert.assertEquals((String)"Incorrect number of message", (long)1L, (long)msgs.size());
        Element res = (Element)msgs.get(0);
        Assert.assertEquals((String)"Incorrect direction", (Object)MessageArchiveRepository.Direction.outgoing.toElementName(), (Object)res.getName());
        Assert.assertEquals((String)"Incorrect message body", (Object)body, (Object)res.getChildCData(res.getName() + "/body"));
    }

    @Test
    public void test2_archiveMessage2withTags() throws InterruptedException, RepositoryException, ComponentException {
        Thread.sleep(2000L);
        Date date = new Date();
        Object body = "Test 2 with #Test123";
        if (this.checkEmoji) {
            body = (String)body + emoji;
        }
        Element msg = new Element("message", new String[]{"from", "to", "type"}, new String[]{owner.toString(), buddy.toString(), StanzaType.chat.name()});
        msg.addChild((XMLNodeIfc)new Element("body", (String)body));
        HashSet<Object> tags = new HashSet<Object>();
        if (this.checkEmoji) {
            tags.add("#Test123" + emoji);
        } else {
            tags.add("#Test123");
        }
        String stableId = UUID.randomUUID().toString();
        this.repo.archiveMessage(owner.getBareJID(), buddy, date, msg, stableId, tags);
        archivedMessagesIds.add(stableId);
        QueryCriteria crit = (QueryCriteria)this.repo.newQuery();
        crit.setQuestionerJID(owner.copyWithoutResource());
        crit.setWith(buddy.copyWithoutResource());
        crit.setStart(date);
        crit.getRsm().setIndex(Integer.valueOf(0));
        crit.getRsm().setMax(1);
        ArrayList msgs = new ArrayList();
        this.repo.queryItems((tigase.xmpp.mam.Query)crit, (qc, item) -> {
            item.getMessage().setName(((MessageArchiveRepository.Item)item).getDirection().toElementName());
            msgs.add(item.getMessage());
        });
        Assert.assertEquals((String)"Incorrect number of message", (long)1L, (long)msgs.size());
        Element res = (Element)msgs.get(0);
        Assert.assertEquals((String)"Incorrect direction", (Object)MessageArchiveRepository.Direction.outgoing.toElementName(), (Object)res.getName());
        Assert.assertEquals((String)"Incorrect message body", (Object)body, (Object)res.getChildCData(res.getName() + "/body"));
    }

    @Test
    public void test3_getCollections() throws TigaseDBException {
        QueryCriteria crit = (QueryCriteria)this.repo.newQuery();
        crit.setQuestionerJID(owner.copyWithoutResource());
        crit.setWith(buddy.copyWithoutResource());
        crit.setStart(testStart);
        ArrayList chats = new ArrayList();
        this.repo.queryCollections((Query)crit, (qc, col) -> chats.add(new ColItem(col.getWith(), col.getStartTs())));
        Assert.assertEquals((String)"Incorrect number of collections", (long)1L, (long)chats.size());
        ColItem chat = (ColItem)chats.get(0);
        Assert.assertEquals((String)"Incorrect buddy", (Object)buddy.getBareJID(), (Object)BareJID.bareJIDInstanceNS((String)chat.with));
        Assert.assertEquals((String)"Incorrect timestamp", (long)(testStart.getTime() / 1000L), (long)(chat.ts.getTime() / 1000L));
    }

    @Test
    public void test3_getCollectionsByTag() throws TigaseDBException {
        QueryCriteria crit = (QueryCriteria)this.repo.newQuery();
        crit.setQuestionerJID(owner.copyWithoutResource());
        crit.setWith(buddy.copyWithoutResource());
        crit.setStart(testStart);
        if (this.checkEmoji) {
            crit.addTag("#Test123" + emoji);
        } else {
            crit.addTag("#Test123");
        }
        ArrayList chats = new ArrayList();
        this.repo.queryCollections((Query)crit, (qc, col) -> chats.add(new ColItem(col.getWith(), col.getStartTs())));
        if (chats.isEmpty()) {
            ArrayList chats1 = new ArrayList();
            crit = (QueryCriteria)this.repo.newQuery();
            crit.setQuestionerJID(owner.copyWithoutResource());
            crit.setWith(buddy.copyWithoutResource());
            crit.setStart(testStart);
            this.repo.queryCollections((Query)crit, (qc, col) -> chats1.add(new ColItem(col.getWith(), col.getStartTs())));
            System.out.println("total no. of chats: " + chats1.size());
        }
        Assert.assertEquals((String)"Incorrect number of collections", (long)1L, (long)chats.size());
        ColItem chat = (ColItem)chats.get(0);
        Assert.assertEquals((String)"Incorrect buddy", (Object)buddy.getBareJID(), (Object)BareJID.bareJIDInstanceNS((String)chat.with));
    }

    @Test
    public void test4_getItems_withIndex() throws InterruptedException, RepositoryException, ComponentException {
        QueryCriteria crit = (QueryCriteria)this.repo.newQuery();
        crit.setUseMessageIdInRsm(false);
        crit.setQuestionerJID(owner.copyWithoutResource());
        crit.setWith(buddy.copyWithoutResource());
        crit.setStart(testStart);
        ArrayList msgs = new ArrayList();
        this.repo.queryItems((tigase.xmpp.mam.Query)crit, (qc, item) -> {
            item.getMessage().setName(((MessageArchiveRepository.Item)item).getDirection().toElementName());
            msgs.add(item.getMessage());
            if (qc.getRsm().getFirst() == null) {
                qc.getRsm().setFirst(item.getId());
            }
            qc.getRsm().setLast(item.getId());
        });
        Assert.assertEquals((String)"Incorrect number of message", (long)2L, (long)msgs.size());
        Element res = (Element)msgs.get(0);
        Assert.assertEquals((String)"Incorrect direction", (Object)MessageArchiveRepository.Direction.outgoing.toElementName(), (Object)res.getName());
        Assert.assertEquals((String)"Incorrect message body", (Object)("Test 1" + (this.checkEmoji ? emoji : "")), (Object)res.getChildCData(res.getName() + "/body"));
        res = (Element)msgs.get(1);
        Assert.assertEquals((String)"Incorrect direction", (Object)MessageArchiveRepository.Direction.outgoing.toElementName(), (Object)res.getName());
        Assert.assertEquals((String)"Incorrect message body", (Object)("Test 2 with #Test123" + (this.checkEmoji ? emoji : "")), (Object)res.getChildCData(res.getName() + "/body"));
        String first = crit.getRsm().getFirst();
        String last = crit.getRsm().getLast();
        crit = (QueryCriteria)this.repo.newQuery();
        crit.setUseMessageIdInRsm(false);
        crit.setQuestionerJID(owner.copyWithoutResource());
        crit.setWith(buddy.copyWithoutResource());
        crit.setStart(testStart);
        crit.getRsm().setAfter(first);
        msgs.clear();
        this.repo.queryItems((tigase.xmpp.mam.Query)crit, (qc, item) -> msgs.add(item.getMessage()));
        Assert.assertEquals((long)1L, (long)msgs.size());
        crit = (QueryCriteria)this.repo.newQuery();
        crit.setUseMessageIdInRsm(false);
        crit.setQuestionerJID(owner.copyWithoutResource());
        crit.setWith(buddy.copyWithoutResource());
        crit.setStart(testStart);
        crit.getRsm().setBefore(last);
        msgs.clear();
        this.repo.queryItems((tigase.xmpp.mam.Query)crit, (qc, item) -> msgs.add(item.getMessage()));
        Assert.assertEquals((long)1L, (long)msgs.size());
        crit = (QueryCriteria)this.repo.newQuery();
        crit.setUseMessageIdInRsm(false);
        crit.setQuestionerJID(owner.copyWithoutResource());
        crit.setStart(testStart);
        msgs.clear();
        this.repo.queryItems((tigase.xmpp.mam.Query)crit, (qc, item) -> msgs.add(item.getMessage()));
        Assert.assertTrue((String)"Incorrect number of message", (msgs.size() >= 1 ? 1 : 0) != 0);
    }

    @Test
    public void test4_getItems_withUID() throws InterruptedException, RepositoryException, ComponentException {
        QueryCriteria crit = (QueryCriteria)this.repo.newQuery();
        crit.setQuestionerJID(owner.copyWithoutResource());
        crit.setWith(buddy.copyWithoutResource());
        crit.setStart(testStart);
        ArrayList msgs = new ArrayList();
        this.repo.queryItems((tigase.xmpp.mam.Query)crit, (qc, item) -> {
            item.getMessage().setName(((MessageArchiveRepository.Item)item).getDirection().toElementName());
            msgs.add(item.getMessage());
            if (qc.getRsm().getFirst() == null) {
                qc.getRsm().setFirst(item.getId());
            }
            qc.getRsm().setLast(item.getId());
        });
        Assert.assertEquals((String)"Incorrect number of message", (long)2L, (long)msgs.size());
        Element res = (Element)msgs.get(0);
        Assert.assertEquals((String)"Incorrect direction", (Object)MessageArchiveRepository.Direction.outgoing.toElementName(), (Object)res.getName());
        Assert.assertEquals((String)"Incorrect message body", (Object)("Test 1" + (this.checkEmoji ? emoji : "")), (Object)res.getChildCData(res.getName() + "/body"));
        res = (Element)msgs.get(1);
        Assert.assertEquals((String)"Incorrect direction", (Object)MessageArchiveRepository.Direction.outgoing.toElementName(), (Object)res.getName());
        Assert.assertEquals((String)"Incorrect message body", (Object)("Test 2 with #Test123" + (this.checkEmoji ? emoji : "")), (Object)res.getChildCData(res.getName() + "/body"));
        String first = crit.getRsm().getFirst();
        String last = crit.getRsm().getLast();
        crit = (QueryCriteria)this.repo.newQuery();
        crit.setQuestionerJID(owner.copyWithoutResource());
        crit.setWith(buddy.copyWithoutResource());
        crit.setStart(testStart);
        crit.getRsm().setAfter(first);
        msgs.clear();
        this.repo.queryItems((tigase.xmpp.mam.Query)crit, (qc, item) -> msgs.add(item.getMessage()));
        Assert.assertEquals((long)1L, (long)msgs.size());
        crit = (QueryCriteria)this.repo.newQuery();
        crit.setQuestionerJID(owner.copyWithoutResource());
        crit.setWith(buddy.copyWithoutResource());
        crit.setStart(testStart);
        crit.getRsm().setBefore(last);
        msgs.clear();
        this.repo.queryItems((tigase.xmpp.mam.Query)crit, (qc, item) -> msgs.add(item.getMessage()));
        Assert.assertEquals((long)1L, (long)msgs.size());
        crit = (QueryCriteria)this.repo.newQuery();
        crit.setQuestionerJID(owner.copyWithoutResource());
        crit.setStart(testStart);
        msgs.clear();
        this.repo.queryItems((tigase.xmpp.mam.Query)crit, (qc, item) -> msgs.add(item.getMessage()));
        Assert.assertTrue((String)"Incorrect number of message", (msgs.size() >= 1 ? 1 : 0) != 0);
    }

    @Test
    public void test4_getItemWithIds() throws RepositoryException, ComponentException {
        QueryCriteria crit = (QueryCriteria)this.repo.newQuery();
        crit.setQuestionerJID(owner);
        String stableId = archivedMessagesIds.get(0);
        crit.setIds(Collections.singleton(stableId));
        ArrayList items = new ArrayList();
        this.repo.queryItems((tigase.xmpp.mam.Query)crit, (qc, item) -> items.add(item));
        Assert.assertEquals((long)1L, (long)items.size());
        Assert.assertEquals((Object)stableId, (Object)((MAMRepository.Item)items.get(0)).getId());
        items.clear();
        stableId = archivedMessagesIds.get(archivedMessagesIds.size() - 1);
        crit.setIds(Collections.singleton(stableId));
        this.repo.queryItems((tigase.xmpp.mam.Query)crit, (qc, item) -> items.add(item));
        Assert.assertEquals((long)1L, (long)items.size());
        Assert.assertEquals((Object)stableId, (Object)((MAMRepository.Item)items.get(0)).getId());
    }

    @Test
    public void test4_getItemWithAfterIdBeforeId() throws RepositoryException, ComponentException {
        QueryCriteria crit = (QueryCriteria)this.repo.newQuery();
        crit.setQuestionerJID(owner);
        Assert.assertTrue((archivedMessagesIds.size() >= 3 ? 1 : 0) != 0);
        String afterId = archivedMessagesIds.get(0);
        String beforeId = archivedMessagesIds.get(archivedMessagesIds.size() - 1);
        List expectedIds = archivedMessagesIds.stream().skip(1L).limit(archivedMessagesIds.size() - 2).collect(Collectors.toList());
        crit.setAfterId(afterId);
        crit.setBeforeId(beforeId);
        ArrayList items = new ArrayList();
        this.repo.queryItems((tigase.xmpp.mam.Query)crit, (qc, item) -> items.add(item));
        Assert.assertEquals((long)expectedIds.size(), (long)items.size());
        Assert.assertArrayEquals((Object[])expectedIds.toArray(), (Object[])items.stream().map(MAMRepository.Item::getId).toArray());
    }

    @Test
    public void test4_getItemsWithTag_withIndex() throws InterruptedException, RepositoryException, ComponentException {
        QueryCriteria crit = (QueryCriteria)this.repo.newQuery();
        crit.setQuestionerJID(owner);
        crit.setUseMessageIdInRsm(false);
        crit.setQuestionerJID(owner.copyWithoutResource());
        crit.setWith(buddy.copyWithoutResource());
        crit.setStart(testStart);
        if (this.checkEmoji) {
            crit.addTag("#Test123" + emoji);
        } else {
            crit.addTag("#Test123");
        }
        ArrayList msgs = new ArrayList();
        this.repo.queryItems((tigase.xmpp.mam.Query)crit, (qc, item) -> {
            item.getMessage().setName(((MessageArchiveRepository.Item)item).getDirection().toElementName());
            msgs.add(item.getMessage());
            if (qc.getRsm().getFirst() == null) {
                qc.getRsm().setFirst(item.getId());
            }
            qc.getRsm().setLast(item.getId());
        });
        Assert.assertEquals((String)"Incorrect number of message", (long)1L, (long)msgs.size());
        Element res = (Element)msgs.get(0);
        Assert.assertEquals((String)"Incorrect direction", (Object)MessageArchiveRepository.Direction.outgoing.toElementName(), (Object)res.getName());
        Assert.assertEquals((String)"Incorrect message body", (Object)("Test 2 with #Test123" + (this.checkEmoji ? emoji : "")), (Object)res.getChildCData(res.getName() + "/body"));
        String first = crit.getRsm().getFirst();
        crit = (QueryCriteria)this.repo.newQuery();
        crit.setUseMessageIdInRsm(false);
        crit.setQuestionerJID(owner.copyWithoutResource());
        crit.setWith(buddy.copyWithoutResource());
        crit.setStart(testStart);
        if (this.checkEmoji) {
            crit.addTag("#Test123" + emoji);
        } else {
            crit.addTag("#Test123");
        }
        crit.getRsm().setAfter(first);
        msgs.clear();
        this.repo.queryItems((tigase.xmpp.mam.Query)crit, (qc, item) -> msgs.add(item.getMessage()));
        Assert.assertEquals((long)0L, (long)msgs.size());
        crit = (QueryCriteria)this.repo.newQuery();
        crit.setUseMessageIdInRsm(false);
        crit.setQuestionerJID(owner.copyWithoutResource());
        crit.setStart(testStart);
        if (this.checkEmoji) {
            crit.addTag("#Test123" + emoji);
        } else {
            crit.addTag("#Test123");
        }
        msgs.clear();
        this.repo.queryItems((tigase.xmpp.mam.Query)crit, (qc, item) -> msgs.add(item.getMessage()));
        Assert.assertTrue((String)"Incorrect number of message", (msgs.size() >= 1 ? 1 : 0) != 0);
    }

    @Test
    public void test4_getItemsWithTag_withUID() throws InterruptedException, RepositoryException, ComponentException {
        QueryCriteria crit = (QueryCriteria)this.repo.newQuery();
        crit.setQuestionerJID(owner.copyWithoutResource());
        crit.setWith(buddy.copyWithoutResource());
        crit.setStart(testStart);
        if (this.checkEmoji) {
            crit.addTag("#Test123" + emoji);
        } else {
            crit.addTag("#Test123");
        }
        ArrayList msgs = new ArrayList();
        this.repo.queryItems((tigase.xmpp.mam.Query)crit, (qc, item) -> {
            item.getMessage().setName(((MessageArchiveRepository.Item)item).getDirection().toElementName());
            msgs.add(item.getMessage());
            if (qc.getRsm().getFirst() == null) {
                qc.getRsm().setFirst(item.getId());
            }
            qc.getRsm().setLast(item.getId());
        });
        Assert.assertEquals((String)"Incorrect number of message", (long)1L, (long)msgs.size());
        Element res = (Element)msgs.get(0);
        Assert.assertEquals((String)"Incorrect direction", (Object)MessageArchiveRepository.Direction.outgoing.toElementName(), (Object)res.getName());
        Assert.assertEquals((String)"Incorrect message body", (Object)("Test 2 with #Test123" + (this.checkEmoji ? emoji : "")), (Object)res.getChildCData(res.getName() + "/body"));
        String first = crit.getRsm().getFirst();
        crit = (QueryCriteria)this.repo.newQuery();
        crit.setQuestionerJID(owner.copyWithoutResource());
        crit.setWith(buddy.copyWithoutResource());
        crit.setStart(testStart);
        if (this.checkEmoji) {
            crit.addTag("#Test123" + emoji);
        } else {
            crit.addTag("#Test123");
        }
        crit.getRsm().setAfter(first);
        msgs.clear();
        this.repo.queryItems((tigase.xmpp.mam.Query)crit, (qc, item) -> msgs.add(item.getMessage()));
        Assert.assertEquals((long)0L, (long)msgs.size());
        crit = (QueryCriteria)this.repo.newQuery();
        crit.setQuestionerJID(owner.copyWithoutResource());
        crit.setStart(testStart);
        if (this.checkEmoji) {
            crit.addTag("#Test123" + emoji);
        } else {
            crit.addTag("#Test123");
        }
        msgs.clear();
        this.repo.queryItems((tigase.xmpp.mam.Query)crit, (qc, item) -> msgs.add(item.getMessage()));
        Assert.assertTrue((String)"Incorrect number of message", (msgs.size() >= 1 ? 1 : 0) != 0);
    }

    @Test
    public void test5_getCollectionsContains() throws TigaseDBException {
        QueryCriteria crit = (QueryCriteria)this.repo.newQuery();
        crit.setQuestionerJID(owner.copyWithoutResource());
        crit.setWith(buddy.copyWithoutResource());
        crit.setStart(testStart);
        crit.addContains("Test 1");
        ArrayList chats = new ArrayList();
        this.repo.queryCollections((Query)crit, (qc, col) -> chats.add(new ColItem(col.getWith(), col.getStartTs())));
        Assert.assertEquals((String)"Incorrect number of collections", (long)1L, (long)chats.size());
        ColItem chat = (ColItem)chats.get(0);
        Assert.assertEquals((String)"Incorrect buddy", (Object)buddy.getBareJID(), (Object)BareJID.bareJIDInstanceNS((String)chat.with));
        Assert.assertEquals((String)"Incorrect timestamp", (long)(testStart.getTime() / 1000L), (long)(chat.ts.getTime() / 1000L));
        crit = (QueryCriteria)this.repo.newQuery();
        crit.setQuestionerJID(owner.copyWithoutResource());
        crit.setWith(buddy.copyWithoutResource());
        crit.setStart(testStart);
        if (this.checkEmoji) {
            crit.addContains("Test 123" + emoji);
        } else {
            crit.addContains("Test 123");
        }
        chats.clear();
        this.repo.queryCollections((Query)crit, (qc, col) -> chats.add(new ColItem(col.getWith(), col.getStartTs())));
        Assert.assertEquals((String)"Incorrect number of collections", (long)0L, (long)chats.size());
    }

    @Test
    public void test6_getItems() throws InterruptedException, RepositoryException, ComponentException {
        QueryCriteria crit = (QueryCriteria)this.repo.newQuery();
        crit.setQuestionerJID(owner.copyWithoutResource());
        crit.setWith(buddy.copyWithoutResource());
        crit.setStart(testStart);
        crit.addContains("Test 1");
        ArrayList msgs = new ArrayList();
        this.repo.queryItems((tigase.xmpp.mam.Query)crit, (qc, item) -> {
            item.getMessage().setName(((MessageArchiveRepository.Item)item).getDirection().toElementName());
            msgs.add(item.getMessage());
        });
        Assert.assertEquals((String)"Incorrect number of message", (long)1L, (long)msgs.size());
        Element res = (Element)msgs.get(0);
        Assert.assertEquals((String)"Incorrect direction", (Object)MessageArchiveRepository.Direction.outgoing.toElementName(), (Object)res.getName());
        Assert.assertEquals((String)"Incorrect message body", (Object)("Test 1" + (this.checkEmoji ? emoji : "")), (Object)res.getChildCData(res.getName() + "/body"));
    }

    @Test
    public void test7_removeItems() throws RepositoryException, ComponentException {
        QueryCriteria crit = (QueryCriteria)this.repo.newQuery();
        crit.setQuestionerJID(owner.copyWithoutResource());
        crit.setWith(buddy.copyWithoutResource());
        crit.setStart(testStart);
        ArrayList msgs = new ArrayList();
        this.repo.queryItems((tigase.xmpp.mam.Query)crit, (qc, item) -> msgs.add(item.getMessage()));
        Assert.assertNotEquals((String)"No messages in repository to execute test - we should have some already", (long)0L, (long)msgs.size());
        this.repo.removeItems(owner.getBareJID(), buddy.getBareJID().toString(), testStart, new Date());
        msgs.clear();
        this.repo.queryItems((tigase.xmpp.mam.Query)crit, (qc, item) -> msgs.add(item.getMessage()));
        Assert.assertEquals((String)"Still some messages, while in this duration all should be deleted", (long)0L, (long)msgs.size());
        crit = (QueryCriteria)this.repo.newQuery();
        crit.setQuestionerJID(owner.copyWithoutResource());
        msgs.clear();
        this.repo.queryItems((tigase.xmpp.mam.Query)crit, (qc, item) -> msgs.add(item.getMessage()));
        Assert.assertNotEquals((String)"No messages in repository to execute test - we should have some already", (long)0L, (long)msgs.size());
        this.repo.removeItems(owner.getBareJID(), null, null, null);
        msgs.clear();
        this.repo.queryItems((tigase.xmpp.mam.Query)crit, (qc, item) -> msgs.add(item.getMessage()));
        Assert.assertEquals((String)"Still some messages, while in this duration all should be deleted", (long)0L, (long)msgs.size());
    }

    @Test
    public void test8_removeExpiredItems() throws RepositoryException, TigaseStringprepException, ComponentException {
        Date date = new Date();
        String uuid = UUID.randomUUID().toString();
        testStart = date;
        String body = "Test 1 " + uuid;
        Element msg = new Element("message", new String[]{"from", "to", "type"}, new String[]{owner.toString(), buddy.toString(), StanzaType.chat.name()});
        msg.addChild((XMLNodeIfc)new Element("body", body));
        Element delay = new Element("delay");
        LocalDateTime time = LocalDateTime.now().minusDays(1L).minusHours(1L);
        Date originalTime = new Date(time.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
        delay.setAttribute("stamp", formatter2.format(originalTime));
        msg.addChild((XMLNodeIfc)delay);
        this.repo.archiveMessage(owner.getBareJID(), buddy, originalTime, msg, UUID.randomUUID().toString(), null);
        QueryCriteria crit = (QueryCriteria)this.repo.newQuery();
        crit.setQuestionerJID(owner.copyWithoutResource());
        crit.setWith(buddy.copyWithoutResource());
        crit.addContains(uuid);
        crit.getRsm().setIndex(Integer.valueOf(0));
        crit.getRsm().setMax(1);
        ArrayList msgs = new ArrayList();
        this.repo.queryItems((tigase.xmpp.mam.Query)crit, (qc, item) -> msgs.add(item.getMessage()));
        Assert.assertEquals((String)"Incorrect number of messages", (long)1L, (long)msgs.size());
        crit = (QueryCriteria)this.repo.newQuery();
        crit.setQuestionerJID(owner.copyWithoutResource());
        crit.setWith(buddy.copyWithoutResource());
        crit.setStart(date);
        crit.addContains(uuid);
        crit.getRsm().setIndex(Integer.valueOf(0));
        crit.getRsm().setMax(1);
        msgs.clear();
        this.repo.queryItems((tigase.xmpp.mam.Query)crit, (qc, item) -> msgs.add(item.getMessage()));
        Assert.assertEquals((String)"Incorrect number of messages", (long)0L, (long)msgs.size());
        LocalDateTime before = LocalDateTime.now().minusDays(1L);
        this.repo.deleteExpiredMessages(BareJID.bareJIDInstance((String)owner.getDomain()), before);
        crit = (QueryCriteria)this.repo.newQuery();
        crit.setQuestionerJID(owner.copyWithoutResource());
        crit.setWith(buddy.copyWithoutResource());
        crit.addContains(uuid);
        crit.getRsm().setIndex(Integer.valueOf(0));
        crit.getRsm().setMax(1);
        msgs.clear();
        this.repo.queryItems((tigase.xmpp.mam.Query)crit, (qc, item) -> msgs.add(item.getMessage()));
        Assert.assertEquals((String)"Incorrect number of messages", (long)0L, (long)msgs.size());
    }

    @Test
    public void test9_jidComparison() throws TigaseStringprepException, ComponentException, RepositoryException {
        Date date = new Date();
        String uuid = UUID.randomUUID().toString();
        testStart = date;
        String body = "Test 1 " + uuid;
        BareJID ownerLower = BareJID.bareJIDInstance((String)owner.getLocalpart().toLowerCase(), (String)owner.getDomain());
        JID buddyLower = JID.jidInstance((String)buddy.getLocalpart().toLowerCase(), (String)buddy.getDomain(), (String)buddy.getResource());
        Element msg = new Element("message", new String[]{"from", "to", "type"}, new String[]{ownerLower.toString(), buddyLower.toString(), StanzaType.chat.name()});
        msg.addChild((XMLNodeIfc)new Element("body", body));
        this.repo.archiveMessage(ownerLower, buddyLower, testStart, msg, UUID.randomUUID().toString(), null);
        QueryCriteria crit = (QueryCriteria)this.repo.newQuery();
        crit.setQuestionerJID(owner.copyWithoutResource());
        crit.setWith(buddy.copyWithoutResource());
        crit.addContains(uuid);
        crit.getRsm().setIndex(Integer.valueOf(0));
        crit.getRsm().setMax(1);
        ArrayList msgs = new ArrayList();
        this.repo.queryItems((tigase.xmpp.mam.Query)crit, (qc, item) -> msgs.add(item.getMessage()));
        Assert.assertEquals((String)"Incorrect number of messages", (long)1L, (long)msgs.size());
        this.repo.removeItems(owner.getBareJID(), buddy.getBareJID().toString(), new Date(date.getTime() - 1000L), new Date());
    }

    protected Class<? extends DataSourceAware> getDataSourceAwareIfc() {
        return MessageArchiveRepository.class;
    }

    static {
        formatter2.setTimeZone(TimeZone.getTimeZone("UTC"));
        archivedMessagesIds = new ArrayList<String>();
    }

    private class ColItem {
        private Date ts;
        private String with;

        public ColItem(String with, Date ts) {
            this.with = with;
            this.ts = ts;
        }
    }
}

